/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler;

import com.google.common.base.Strings;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.CoreComponentsOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CoreComponentsClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<CoreComponentsHandler> {
    private static final int MAX_BARS = 40;
    private static final String[] BAR_STR_CACHE = new String[41];
    private static final Component NO_ARMOR = Component.literal((String)"-").withStyle(ChatFormatting.DARK_GRAY);
    private static final StatPanelLayout DEF_STAT_LAYOUT = StatPanelLayout.expandsLeft(0.995f, 0.005f);
    private static final StatPanelLayout DEFAULT_MESSAGE_LAYOUT = StatPanelLayout.expandsRight(0.005f, 0.15f);
    private final float[] lastPressure = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    private IGuiAnimatedStat powerStat;
    private IGuiAnimatedStat testMessageStat;
    private final List<WidgetButtonExtended> pressureButtons = new ArrayList<WidgetButtonExtended>();
    private boolean showPressureNumerically;
    private boolean forceUpdatePressureStat = true;

    public CoreComponentsClientHandler() {
        super(CommonUpgradeHandlers.coreComponentsHandler);
    }

    @Override
    public Optional<KeyMapping> getTriggerKeyBinding() {
        return Optional.of(KeyHandler.getInstance().keybindOpenOptions);
    }

    @Override
    public void onTriggered(ICommonArmorHandler armorHandler) {
        Minecraft mc = Minecraft.getInstance();
        if (PneumaticArmorItem.isPlayerWearingAnyPneumaticArmor((Player)mc.player)) {
            mc.setScreen((Screen)ArmorMainScreen.getInstance());
        }
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        if (!isEnabled) {
            return;
        }
        boolean needUpdate = this.forceUpdatePressureStat;
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot2 = ArmorUpgradeRegistry.ARMOR_SLOTS[i];
            if (this.lastPressure[i] != armorHandler.getArmorPressure(slot2)) {
                this.lastPressure[i] = armorHandler.getArmorPressure(slot2);
                needUpdate = true;
            }
            ItemStack stack = armorHandler.getPlayer().getItemBySlot(slot2);
            this.pressureButtons.get(i).setRenderStacks(stack.getItem() instanceof PneumaticArmorItem ? stack : ItemStack.EMPTY);
        }
        if (needUpdate) {
            List<Component> l = Arrays.stream(ArmorUpgradeRegistry.ARMOR_SLOTS).map(slot -> this.getPressureStr(armorHandler, (EquipmentSlot)slot)).collect(Collectors.toList());
            this.powerStat.setText(l);
            this.forceUpdatePressureStat = false;
        }
    }

    @Override
    public void initConfig() {
        this.showPressureNumerically = (Boolean)ConfigHelper.client().armor.showPressureNumerically.get();
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.setShowPressureNumerically(this.showPressureNumerically);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean shouldShowPressureNumerically() {
        return this.showPressureNumerically;
    }

    public void setShowPressureNumerically(boolean showPressureNumerically) {
        if (showPressureNumerically != this.showPressureNumerically) {
            this.reset();
            this.forceUpdatePressureStat = true;
        }
        this.showPressureNumerically = showPressureNumerically;
    }

    private Component getPressureStr(ICommonArmorHandler handler, EquipmentSlot slot) {
        if (!PneumaticArmorItem.isPneumaticArmorPiece(handler.getPlayer(), slot)) {
            return NO_ARMOR;
        }
        float pressure = handler.getArmorPressure(slot);
        if (pressure <= 0.5f && ClientUtils.getClientLevel().getGameTime() % 20L < 5L) {
            return Component.empty();
        }
        if (this.showPressureNumerically) {
            return Component.literal((String)String.format("%4.1f", Float.valueOf(Math.max(0.0f, pressure)))).withStyle(this.getColourForPressure(pressure));
        }
        return Component.literal((String)this.getBarStr(pressure));
    }

    private ChatFormatting getColourForPressure(float pressure) {
        if (pressure <= 0.1f) {
            return ChatFormatting.GRAY;
        }
        if (pressure < 0.5f) {
            return ChatFormatting.RED;
        }
        if (pressure < 2.0f) {
            return ChatFormatting.GOLD;
        }
        if (pressure < 4.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    private String getBarStr(float pressure) {
        int scaled = (int)(40.0f * pressure / 10.0f);
        int idx = Mth.clamp((int)scaled, (int)0, (int)40);
        if (BAR_STR_CACHE[idx] == null) {
            int n2 = 40 - scaled;
            CoreComponentsClientHandler.BAR_STR_CACHE[idx] = this.getColourForPressure(pressure) + Strings.repeat((String)"|", (int)scaled) + ChatFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)n2);
        }
        return BAR_STR_CACHE[idx];
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
    }

    @Override
    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.powerStat == null) {
            this.forceUpdatePressureStat = true;
            this.powerStat = PneumaticRegistry.getInstance().getClientArmorRegistry().makeHUDStatPanel((Component)Component.empty(), ItemStack.EMPTY, this);
            this.powerStat.setLineSpacing(14);
            this.powerStat.setSubwidgetRenderOffsets(-18, 0);
            this.pressureButtons.clear();
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                WidgetButtonExtended pressureButton = new WidgetButtonExtended(0, 5 + (3 - slot.getIndex()) * 14, 18, 18, (Component)Component.empty());
                ItemStack stack = ArmorMainScreen.ARMOR_STACKS[slot.getIndex()];
                pressureButton.setVisible(false);
                pressureButton.setRenderStacks(stack);
                this.powerStat.addSubWidget((AbstractWidget)pressureButton);
                this.pressureButtons.add(pressureButton);
            }
            this.powerStat.setMinimumContractedDimensions(0, 0);
            this.powerStat.setAutoLineWrap(false);
            this.powerStat.openStat();
        }
        return this.powerStat;
    }

    @Override
    public StatPanelLayout getDefaultStatLayout() {
        return DEF_STAT_LAYOUT;
    }

    @Override
    public void reset() {
        this.powerStat = null;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new CoreComponentsOptions(screen, this);
    }

    @Override
    public void onResolutionChanged() {
        this.powerStat = null;
        this.forceUpdatePressureStat = true;
        Arrays.fill(this.lastPressure, -1.0f);
    }

    public static StatPanelLayout getDefaultMessageLayout() {
        return DEFAULT_MESSAGE_LAYOUT;
    }

    public IGuiAnimatedStat getTestMessageStat() {
        if (this.testMessageStat == null) {
            StatPanelLayout messageLayout = ArmorHUDLayout.INSTANCE.getLayoutFor(CoreComponentsHandler.getMessageID(), CoreComponentsClientHandler.getDefaultMessageLayout());
            this.testMessageStat = new WidgetAnimatedStat(null, (Component)Component.literal((String)"Test Message: keep in mind that messages can be long!"), WidgetAnimatedStat.StatIcon.NONE, HUDHandler.getInstance().getStatOverlayColor(), null, messageLayout);
            this.testMessageStat.openStat();
        }
        return this.testMessageStat;
    }
}

