/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import me.desht.pneumaticcraft.client.model.ModelMinigun;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.util.Lazy;

public class MinigunItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ModelMinigun model;

    public MinigunItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
        this.model = new ModelMinigun(pEntityModelSet.bakeLayer(PNCModelLayers.MINIGUN));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Item item = stack.getItem();
        if (item instanceof MinigunItem) {
            MinigunItem itemMinigun = (MinigunItem)item;
            if (stack.hasTag()) {
                Minecraft mc = Minecraft.getInstance();
                int id = Objects.requireNonNull(stack.getTag()).getInt("owningPlayerId");
                Entity entity = ClientUtils.getClientLevel().getEntity(id);
                if (entity instanceof Player) {
                    boolean thirdPerson;
                    Player player = (Player)entity;
                    Minigun minigun = itemMinigun.getMinigun(stack, player);
                    matrixStack.pushPose();
                    boolean bl = thirdPerson = displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                    if (thirdPerson) {
                        if (mc.screen instanceof InventoryScreen) {
                            matrixStack.mulPose(Axis.XP.rotationDegrees(-180.0f));
                            matrixStack.translate(0.5, -1.0, -0.5);
                        } else {
                            matrixStack.scale(1.0f, -1.0f, -1.0f);
                            matrixStack.mulPose(Axis.XP.rotationDegrees(75.0f));
                            matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                            matrixStack.mulPose(Axis.ZP.rotationDegrees(0.0f));
                            matrixStack.translate(-0.5, -2.0, -0.3);
                        }
                    } else if (player.getOffhandItem() == stack) {
                        matrixStack.scale(0.0f, 0.0f, 0.0f);
                    } else {
                        matrixStack.scale(1.5f, 1.5f, 1.5f);
                        matrixStack.mulPose(Axis.XP.rotationDegrees(0.0f));
                        matrixStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                        if (mc.options.mainHand().get() == HumanoidArm.RIGHT) {
                            matrixStack.translate(-1.0, -1.7, 0.1);
                        } else {
                            matrixStack.translate(0.4, -1.7, 0.1);
                        }
                    }
                    this.model.renderMinigun(matrixStack, buffer, combinedLightIn, combinedOverlayIn, minigun, mc.getFrameTime(), false);
                    matrixStack.popPose();
                }
            }
        }
    }

    public static class RenderProperties
    implements IClientItemExtensions {
        static final Lazy<BlockEntityWithoutLevelRenderer> renderer = Lazy.of(() -> new MinigunItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return (BlockEntityWithoutLevelRenderer)renderer.get();
        }
    }
}

