/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ProgressBarRenderer {
    public static void render3d(PoseStack matrixStack, MultiBufferSource buffer, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.lerp((float)(progress / 100.0f), (float)minX, (float)maxX);
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH, (posMat, builder) -> {
            builder.vertex(posMat, minX, minY, zLevel).color(f1[0], f1[1], f1[2], f1[3]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, minX, minY + (maxY - minY), zLevel).color(f1[0], f1[1], f1[2], f1[3]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, x, minY + (maxY - minY), zLevel).color(f2[0], f2[1], f2[2], f2[3]).uv2(0xF000F0).endVertex();
            builder.vertex(posMat, x, minY, zLevel).color(f2[0], f2[1], f2[2], f2[3]).uv2(0xF000F0).endVertex();
        });
        Matrix3f normal = matrixStack.last().normal();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoops(1.5), (posMat, builder) -> {
            RenderUtils.normalLine(builder, posMat, normal, minX, minY, zLevel, minX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, minX, maxY, zLevel, maxX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, maxX, maxY, zLevel, maxX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, maxX, minY, zLevel, minX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
        });
    }

    public static void render2d(GuiGraphics graphics, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.lerp((float)(progress / 100.0f), (float)minX, (float)maxX);
        Matrix4f posMat = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.vertex(posMat, minX, minY, zLevel).color(f1[0], f1[1], f1[2], f1[3]).endVertex();
        builder.vertex(posMat, minX, minY + (maxY - minY), zLevel).color(f1[0], f1[1], f1[2], f1[3]).endVertex();
        builder.vertex(posMat, x, minY + (maxY - minY), zLevel).color(f2[0], f2[1], f2[2], f2[3]).endVertex();
        builder.vertex(posMat, x, minY, zLevel).color(f2[0], f2[1], f2[2], f2[3]).endVertex();
        Tesselator.getInstance().end();
        RenderSystem.lineWidth((float)2.0f);
        builder.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        builder.vertex(posMat, minX, minY, zLevel).color(0.0f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(posMat, minX, maxY, zLevel).color(0.0f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(posMat, maxX, maxY, zLevel).color(0.0f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(posMat, maxX, minY, zLevel).color(0.0f, 0.0f, 0.0f, 1.0f).endVertex();
        Tesselator.getInstance().end();
    }

    private static Pair<float[], float[]> calcColors(int color1, int color2, float progress) {
        float[] f1 = new TintColor(color1, true).getComponents(null);
        if (color1 != color2) {
            float[] f2 = new TintColor(color2, true).getComponents(null);
            for (int i = 0; i < f1.length; ++i) {
                f2[i] = Mth.lerp((float)(progress / 100.0f), (float)f1[i], (float)f2[i]);
            }
            return Pair.of((Object)f1, (Object)f2);
        }
        return Pair.of((Object)f1, (Object)f1);
    }
}

