/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.common.block.entity.utility.AerialInterfaceBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class AerialInterfaceRenderer
implements BlockEntityRenderer<AerialInterfaceBlockEntity> {
    private final SkullModel headModel;
    private static final double EXTRUSION = 0.05;

    public AerialInterfaceRenderer(BlockEntityRendererProvider.Context ctx) {
        this.headModel = new SkullModel(ctx.getModelSet().bakeLayer(ModelLayers.PLAYER_HEAD));
    }

    public void render(AerialInterfaceBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.gameProfileClient != null) {
            GameProfile gameProfile = tileEntityIn.gameProfileClient;
            Direction dir = tileEntityIn.getRotation();
            SkinManager skinManager = Minecraft.getInstance().getSkinManager();
            PlayerSkin playerSkin = skinManager.getInsecureSkin(gameProfile);
            RenderType renderType = RenderType.entityTranslucent((ResourceLocation)playerSkin.texture());
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5 + (double)dir.getStepX() * 0.25, 0.8, 0.5 + (double)dir.getStepZ() * 0.25);
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            VertexConsumer builder = bufferIn.getBuffer(renderType);
            this.headModel.setupAnim(0.0f, (float)dir.getOpposite().get2DDataValue() * 90.0f, -90.0f);
            this.headModel.renderToBuffer(matrixStackIn, builder, 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.popPose();
        }
    }
}

