/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.client.gui.AphorismTileScreen;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.AphorismTileBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;

public class AphorismTileRenderer
implements BlockEntityRenderer<AphorismTileBlockEntity> {
    private static final float ICON_SCALE = 9.0f;
    private static final String REDSTONE_STR = Pattern.quote("{redstone}");
    private final Font font;

    public AphorismTileRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.getFont();
    }

    /*
     * Unable to fully structure code
     */
    public void render(AphorismTileBlockEntity te, float v, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        RenderUtils.rotateMatrixForDirection(matrixStack, te.getRotation());
        zOff = te.isInvisible() != false ? 0.01 : 0.0625;
        matrixStack.translate(0.0, 1.0, 0.5 - zOff - 0.01);
        Objects.requireNonNull(this.font);
        fh = 9;
        var12_9 = Minecraft.getInstance().screen;
        if (!(var12_9 instanceof AphorismTileScreen)) ** GOTO lbl-1000
        g = (AphorismTileScreen)var12_9;
        if (g.blockEntity == te) {
            v0 = g;
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        editor = v0;
        textLines = te.getTextLines();
        lineWidth = te.getMaxLineWidth(editor != null);
        lineHeight = (float)(fh * textLines.length) * (1.0f + (float)(te.getMarginSize() + 1) * 0.075f);
        textScale = Math.min(0.875f / (float)lineWidth, 0.875f / lineHeight);
        matrixStack.scale(textScale, textScale, textScale);
        matrixStack.mulPose(Axis.ZP.rotationDegrees((float)(te.getTextRotation() * 90)));
        editedLine = editor == null ? -1 : editor.cursorY;
        showCursor = editor != null && (editor.updateCounter & 15) < 8;
        mid = (float)(textLines.length + 1) / 2.0f - 1.0f;
        for (i = 0; i < textLines.length; ++i) {
            if (!te.getIconAt(i).isEmpty() && editor == null) {
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStack.translate(0.0f, 8.0f * (mid - (float)i), 0.0f);
                matrixStack.scale(9.0f, 9.0f, 9.0f);
                Minecraft.getInstance().getItemRenderer().renderStatic(te.getIconAt(i), ItemDisplayContext.FIXED, combinedLight, OverlayTexture.NO_OVERLAY, matrixStack, buffer, te.getLevel(), 0);
                matrixStack.popPose();
                continue;
            }
            if (editedLine == i) {
                cursor = showCursor != false ? "\u25a0" : "\u25a1";
                cx = Math.min(editor.cursorX, textLines[i].length());
                textLine = textLines[i].substring(0, cx) + cursor + textLines[i].substring(cx);
            } else {
                textLine = textLines[i];
            }
            if (editor == null && te.isRedstoneLine(i)) {
                textLine = textLine.replaceAll(AphorismTileRenderer.REDSTONE_STR, Integer.toString(te.pollRedstone()));
            }
            x = (float)(-this.font.width((String)textLine)) / 2.0f;
            y = (float)(-(textLines.length * fh)) / 2.0f + (float)(i * fh) + 1.0f;
            this.font.drawInBatch((String)textLine, x, y, -16777216, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        }
        matrixStack.popPose();
    }
}

