/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ElevatorBaseRenderer
extends AbstractBlockEntityModelRenderer<ElevatorBaseBlockEntity> {
    private static final float FACTOR = 0.5625f;
    private static final float[] SHADE = new float[]{1.0f, 0.85f, 0.7f, 0.55f};
    private final ModelPart pole1;
    private final ModelPart pole2;
    private final ModelPart pole3;
    private final ModelPart pole4;
    private final ModelPart floor;
    private static final String POLE1 = "pole1";
    private static final String POLE2 = "pole2";
    private static final String POLE3 = "pole3";
    private static final String POLE4 = "pole4";
    private static final String FLOOR = "floor";

    public ElevatorBaseRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.ELEVATOR_BASE);
        this.pole1 = root.getChild(POLE1);
        this.pole2 = root.getChild(POLE2);
        this.pole3 = root.getChild(POLE3);
        this.pole4 = root.getChild(POLE4);
        this.floor = root.getChild(FLOOR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(POLE1, CubeListBuilder.create().texOffs(28, 41).addBox("pole1_0", -19.5f, 0.0f, -1.5f, 5.0f, 14.0f, 5.0f), PartPose.offset((float)17.0f, (float)9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild(POLE2, CubeListBuilder.create().texOffs(32, 19).addBox("pole2_0", -15.0f, 0.0f, -1.0f, 6.0f, 14.0f, 6.0f), PartPose.offset((float)12.0f, (float)9.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild(POLE3, CubeListBuilder.create().texOffs(0, 39).addBox("pole3_0", -8.5f, 0.0f, 8.5f, 7.0f, 14.0f, 7.0f), PartPose.offset((float)5.0f, (float)9.0f, (float)-12.0f));
        partdefinition.addOrReplaceChild(POLE4, CubeListBuilder.create().texOffs(0, 17).addBox("pole4_0", 0.0f, 0.0f, 0.0f, 8.0f, 14.0f, 8.0f), PartPose.offset((float)-4.0f, (float)9.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild(FLOOR, CubeListBuilder.create().texOffs(0, 0).addBox("floor_0", 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.offset((float)-8.0f, (float)8.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(ElevatorBaseBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.extension == 0.0) {
            return;
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_ELEVATOR));
        double extension = Mth.lerp((double)partialTicks, (double)te.oldExtension, (double)te.extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole4, 0, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole3, 1, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole2, 2, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole1, 3, extension);
        this.floor.render(matrixStackIn, builder, te.lightAbove, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(ElevatorBaseBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.fakeFloorTextureUV != null && te.fakeFloorTextureUV.length == 4) {
            matrixStack.pushPose();
            double extension = Mth.lerp((double)partialTicks, (double)te.oldExtension, (double)te.extension);
            matrixStack.translate(0.0, extension + (double)1.0005f, 0.0);
            VertexConsumer builder = iRenderTypeBuffer.getBuffer(ModRenderTypes.getTextureRender(TextureAtlas.LOCATION_BLOCKS));
            float uMin = te.fakeFloorTextureUV[0];
            float vMin = te.fakeFloorTextureUV[1];
            float uMax = te.fakeFloorTextureUV[2];
            float vMax = te.fakeFloorTextureUV[3];
            Matrix4f posMat = matrixStack.last().pose();
            builder.vertex(posMat, 0.0f, 0.0f, 1.0f).color(te.fakeFloorTextureTint).uv(uMin, vMax).uv2(te.lightAbove).endVertex();
            builder.vertex(posMat, 1.0f, 0.0f, 1.0f).color(te.fakeFloorTextureTint).uv(uMax, vMax).uv2(te.lightAbove).endVertex();
            builder.vertex(posMat, 1.0f, 0.0f, 0.0f).color(te.fakeFloorTextureTint).uv(uMax, vMin).uv2(te.lightAbove).endVertex();
            builder.vertex(posMat, 0.0f, 0.0f, 0.0f).color(te.fakeFloorTextureTint).uv(uMin, vMin).uv2(te.lightAbove).endVertex();
            matrixStack.popPose();
        }
    }

    private void renderPole(PoseStack matrixStackIn, VertexConsumer builder, int combinedLightIn, int combinedOverlayIn, ModelPart pole, int idx, double extension) {
        matrixStackIn.translate(0.0, -extension / 4.0, 0.0);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, 0.5625f, 0.0f);
        matrixStackIn.scale(1.0f, (float)(extension * 16.0 / 14.0 / 4.0), 1.0f);
        matrixStackIn.translate(0.0f, -0.5625f, 0.0f);
        pole.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, SHADE[idx], SHADE[idx], SHADE[idx], 1.0f);
        matrixStackIn.popPose();
    }

    public boolean shouldRenderOffScreen(ElevatorBaseBlockEntity te) {
        return true;
    }

    public boolean shouldRender(ElevatorBaseBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.atCenterOf((Vec3i)pBlockEntity.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)pCameraPos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public AABB getRenderBoundingBox(ElevatorBaseBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(blockEntity.extension);
    }
}

