/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.PneumaticDoorBaseBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PneumaticDoorBaseRenderer
extends AbstractBlockEntityModelRenderer<PneumaticDoorBaseBlockEntity> {
    private final ModelPart cylinder1;
    private final ModelPart cylinder2;
    private final ModelPart cylinder3;
    private static final String CYLINDER1 = "cylinder1";
    private static final String CYLINDER2 = "cylinder2";
    private static final String CYLINDER3 = "cylinder3";

    public PneumaticDoorBaseRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.PNEUMATIC_DOOR_BASE);
        this.cylinder1 = root.getChild(CYLINDER1);
        this.cylinder2 = root.getChild(CYLINDER2);
        this.cylinder3 = root.getChild(CYLINDER3);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(CYLINDER1, CubeListBuilder.create().texOffs(0, 0).addBox("cylinder1_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.offset((float)2.5f, (float)8.5f, (float)-6.0f));
        partdefinition.addOrReplaceChild(CYLINDER2, CubeListBuilder.create().texOffs(0, 13).addBox("cylinder2_0", 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 10.0f), PartPose.offset((float)3.0f, (float)9.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild(CYLINDER3, CubeListBuilder.create().texOffs(0, 25).addBox("cylinder3_0", 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 10.0f), PartPose.offset((float)3.5f, (float)9.5f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(PneumaticDoorBaseBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_PNEUMATIC_DOOR_BASE));
        float progress = Mth.lerp((float)partialTicks, (float)te.oldProgress, (float)te.progress);
        float cosinus = (float)Math.sin(Math.toRadians((1.0f - progress) * 90.0f)) * 12.0f / 16.0f;
        float sinus = 0.5625f - (float)Math.cos(Math.toRadians((1.0f - progress) * 90.0f)) * 9.0f / 16.0f;
        double extension = Math.sqrt(Math.pow(sinus, 2.0) + Math.pow(cosinus + 0.25f, 2.0));
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.translate(((double)(te.rightGoing ? -4 : 0) + 2.5) / 16.0, 0.0, -0.375);
        float cylinderAngle = (float)Math.toDegrees(Math.atan(sinus / (cosinus + 0.875f)));
        matrixStackIn.mulPose(te.rightGoing ? Axis.YP.rotationDegrees(cylinderAngle) : Axis.YN.rotationDegrees(cylinderAngle));
        matrixStackIn.translate(((double)(te.rightGoing ? -3 : 0) - 2.5) / 16.0, 0.0, 0.375);
        double extensionPart = extension * 0.5;
        int l = ClientUtils.getLightAt(te.getBlockPos().relative(te.getRotation()));
        this.cylinder1.render(matrixStackIn, builder, l, combinedOverlayIn);
        matrixStackIn.translate(0.0, 0.0, extensionPart);
        this.cylinder2.render(matrixStackIn, builder, l, combinedOverlayIn, 0.8f, 0.8f, 0.8f, 1.0f);
        matrixStackIn.translate(0.0, 0.0, extensionPart);
        this.cylinder3.render(matrixStackIn, builder, l, combinedOverlayIn, 0.6f, 0.6f, 0.6f, 1.0f);
    }
}

