/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.PneumaticDoorBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PneumaticDoorRenderer
extends AbstractBlockEntityModelRenderer<PneumaticDoorBlockEntity> {
    private static final String DOOR = "door";
    private final ModelPart door;

    public PneumaticDoorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.PNEUMATIC_DOOR);
        this.door = root.getChild(DOOR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(DOOR, CubeListBuilder.create().texOffs(0, 0).addBox("door_0", 0.0f, -11.0f, 0.0f, 16, 32, 3, 0, 0).addBox("door_1", 1.0f, -11.0f, 2.25f, 1, 32, 1, new CubeDeformation(-0.01f), 42, 2).addBox("door_2", 3.0f, -11.0f, 2.25f, 1, 32, 1, new CubeDeformation(-0.01f), 38, 2).addBox("door_3", 3.0f, -11.0f, -0.25f, 1, 32, 1, new CubeDeformation(-0.01f), 38, 2).addBox("door_4", 1.0f, -11.0f, -0.25f, 1, 32, 1, new CubeDeformation(-0.01f), 42, 2).addBox("door_5", 0.0f, -9.0f, 2.5f, 5, 1, 1, new CubeDeformation(-0.01f), 0, 46).addBox("door_6", 0.0f, 18.0f, 2.5f, 5, 1, 1, new CubeDeformation(-0.01f), 0, 44).addBox("door_7", 0.0f, -9.0f, -0.5f, 5, 1, 1, new CubeDeformation(-0.01f), 0, 46).addBox("door_8", 0.0f, 18.0f, -0.5f, 5, 1, 1, new CubeDeformation(-0.01f), 0, 44).addBox("door_9", 0.5f, 1.0f, 3.0f, 4, 8, 1, 16, 35).addBox("door_10", 0.5f, 1.0f, -1.0f, 4, 8, 1, 16, 35).addBox("door_11", 1.5f, 2.0f, 4.0f, 2, 2, 1, 26, 35).addBox("door_12", 1.5f, 2.0f, -2.0f, 2, 2, 1, 26, 35).addBox("door_13", 2.5f, 2.5f, 4.0f, 4, 1, 1, new CubeDeformation(-0.2f), 26, 38).addBox("door_14", 2.5f, 2.5f, -2.0f, 4, 1, 1, new CubeDeformation(-0.2f), 26, 38).addBox("door_15", 9.0f, -8.0f, 2.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 41).addBox("door_16", 9.0f, 9.0f, 2.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 38).addBox("door_17", 9.0f, 16.0f, 2.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 35).addBox("door_18", 9.0f, -8.0f, -0.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 41).addBox("door_19", 9.0f, 9.0f, -0.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 38).addBox("door_20", 9.0f, 16.0f, -0.25f, 7, 2, 1, new CubeDeformation(-0.01f), 0, 35).mirror(), PartPose.offset((float)-8.0f, (float)3.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(PneumaticDoorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (((Boolean)te.getBlockState().getValue((Property)PneumaticDoorBlock.TOP_DOOR)).booleanValue()) {
            return;
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_PNEUMATIC_DOOR_DYNAMIC));
        float rotation = Mth.lerp((float)partialTicks, (float)te.oldRotationAngle, (float)te.rotationAngle);
        boolean rightGoing = te.rightGoing;
        float[] rgb = DyeColor.byId((int)te.color).getTextureDiffuseColors();
        RenderUtils.rotateMatrixForDirection(matrixStackIn, te.getRotation());
        matrixStackIn.translate((float)(rightGoing ? -1 : 1) * 6.5f / 16.0f, 0.0f, -0.40625f);
        matrixStackIn.mulPose(rightGoing ? Axis.YN.rotationDegrees(rotation) : Axis.YP.rotationDegrees(rotation));
        matrixStackIn.translate((float)(rightGoing ? -1 : 1) * -6.5f / 16.0f, 0.0f, 0.40625f);
        if (rightGoing) {
            matrixStackIn.translate(0.0, 0.0, -0.40625);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrixStackIn.translate(0.0, 0.0, 0.40625);
        }
        this.door.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, rgb[0], rgb[1], rgb[2], 1.0f);
    }

    public AABB getRenderBoundingBox(PneumaticDoorBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

