/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.entity.spawning.SpawnerExtractorBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;

public class SpawnerExtractorRenderer
extends AbstractBlockEntityModelRenderer<SpawnerExtractorBlockEntity> {
    private static final AABB FLUID_BB = new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final String MODEL = "model";
    private final ModelPart model;

    public SpawnerExtractorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.bakeLayer(PNCModelLayers.SPAWNER_EXTRACTOR);
        this.model = root.getChild(MODEL);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(MODEL, CubeListBuilder.create().texOffs(0, 0).addBox("model_0", -3.0f, -16.25f, -3.0f, 6, 1, 6, new CubeDeformation(-0.01f), 23, 57).addBox("model_1", -3.0f, -14.75f, -3.0f, 6, 1, 6, new CubeDeformation(-0.01f), 23, 57).addBox("model_2", -2.5f, -15.5f, -2.5f, 5, 1, 5, new CubeDeformation(-0.01f), 44, 57).addBox("model_3", -1.0f, -16.0f, -1.0f, 2, 16, 2, 15, 46).mirror(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    void renderModel(SpawnerExtractorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)Textures.MODEL_SPAWNER_EXTRACTOR));
        float extension = te.getProgress() * -0.75f;
        matrixStackIn.translate(0.0f, extension, 0.0f);
        this.model.render(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(SpawnerExtractorBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getProgress() > 0.0f && te.getProgress() < 1.0f) {
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.8125, 0.0);
            VertexConsumer builder = iRenderTypeBuffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            TankRenderInfo info = new TankRenderInfo(new FluidStack(ModFluids.MEMORY_ESSENCE.get(), (int)(1000.0f * te.getProgress())), 1000, FLUID_BB, new Direction[0]);
            AbstractFluidTER.renderFluid(builder, info, matrixStack.last().pose(), combinedLightIn, combinedOverlayIn);
            matrixStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(SpawnerExtractorBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1));
    }
}

