/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelTransferGadget;
import me.desht.pneumaticcraft.client.render.entity.semiblock.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.TransferGadgetEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderTransferGadget
extends RenderSemiblockBase<TransferGadgetEntity> {
    private final ModelTransferGadget model;

    public RenderTransferGadget(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ModelTransferGadget(ctx.bakeLayer(PNCModelLayers.TRANSFER_GADGET));
    }

    public void render(TransferGadgetEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction side;
        if (entity.isAir()) {
            return;
        }
        matrixStackIn.pushPose();
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        matrixStackIn.translate(0.0, (side = entity.getSide()).getAxis() == Direction.Axis.Y ? 1.2 : -1.1, 0.0);
        switch (side) {
            case UP: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
                matrixStackIn.translate(-1.1, -1.1, 0.0);
                break;
            }
            case DOWN: {
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                matrixStackIn.translate(1.3, -1.1, 0.0);
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        this.model.renderToBuffer(matrixStackIn, builder, this.kludgeLightingLevel(entity, packedLightIn), OverlayTexture.pack((float)0.0f, (boolean)false), 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.popPose();
    }

    public Vec3 getRenderOffset(TransferGadgetEntity entityIn, float partialTicks) {
        VoxelShape shape = entityIn.getBlockState().getShape((BlockGetter)entityIn.getWorld(), entityIn.getBlockPos());
        double yOff = (shape.max(Direction.Axis.Y) - shape.min(Direction.Axis.Y)) / 2.0;
        return switch (entityIn.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Vec3(0.0, shape.min(Direction.Axis.Y), 0.0);
            case Direction.UP -> new Vec3(0.0, shape.max(Direction.Axis.Y), 0.0);
            case Direction.NORTH -> new Vec3(0.0, yOff, shape.min(Direction.Axis.Z) - 0.6);
            case Direction.SOUTH -> new Vec3(0.0, yOff, shape.max(Direction.Axis.Z) - 0.4);
            case Direction.WEST -> new Vec3(shape.min(Direction.Axis.X) - 0.6, yOff, 0.0);
            case Direction.EAST -> new Vec3(shape.max(Direction.Axis.X) - 0.4, yOff, 0.0);
        };
    }

    public ResourceLocation getTextureLocation(TransferGadgetEntity entityTransferGadget) {
        return entityTransferGadget.getIOMode().getTexture();
    }
}

