/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.joml.Matrix4f;

public abstract class AbstractFluidTER<T extends AbstractPneumaticCraftBlockEntity>
implements BlockEntityRenderer<T> {
    AbstractFluidTER(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (((AbstractPneumaticCraftBlockEntity)te).nonNullLevel().isLoaded(te.getBlockPos())) {
            VertexConsumer builder = buffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
            Matrix4f posMat = matrixStack.last().pose();
            for (TankRenderInfo tankRenderInfo : this.getTanksToRender(te)) {
                AbstractFluidTER.renderFluid(builder, tankRenderInfo, posMat, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public static void renderFluid(VertexConsumer builder, TankRenderInfo tankRenderInfo, Matrix4f posMat, int combinedLight, int combinedOverlay) {
        float v2;
        float v1;
        float u2;
        float u1;
        IFluidTank tank = tankRenderInfo.getTank();
        if (tank.getFluidAmount() == 0) {
            return;
        }
        Fluid fluid = tank.getFluid().getFluid();
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation texture = renderProps.getStillTexture(tank.getFluid());
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        int[] cols = RenderUtils.decomposeColor(renderProps.getTintColor(tank.getFluid()));
        AABB bounds = AbstractFluidTER.getRenderBounds(tank, tankRenderInfo.getBounds());
        float x1 = (float)bounds.minX;
        float x2 = (float)bounds.maxX;
        float y1 = (float)bounds.minY;
        float y2 = (float)bounds.maxY;
        float z1 = (float)bounds.minZ;
        float z2 = (float)bounds.maxZ;
        if (tankRenderInfo.shouldRender(Direction.DOWN)) {
            u1 = still.getU(x1);
            u2 = still.getU(x2);
            v1 = still.getV(z1);
            v2 = still.getV(z2);
            builder.vertex(posMat, x1, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, -1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x1, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, -1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, -1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, -1.0f, 0.0f).endVertex();
        }
        if (tankRenderInfo.shouldRender(Direction.UP)) {
            u1 = still.getU(x1);
            u2 = still.getU(x2);
            v1 = still.getV(z1);
            v2 = still.getV(z2);
            builder.vertex(posMat, x1, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 1.0f, 0.0f).endVertex();
            builder.vertex(posMat, x1, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 1.0f, 0.0f).endVertex();
        }
        if (tankRenderInfo.shouldRender(Direction.NORTH)) {
            u1 = still.getU(x1);
            u2 = still.getU(x2);
            v1 = still.getV(y1);
            v2 = still.getV(y2);
            builder.vertex(posMat, x1, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, -1.0f).endVertex();
            builder.vertex(posMat, x1, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, -1.0f).endVertex();
            builder.vertex(posMat, x2, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, -1.0f).endVertex();
            builder.vertex(posMat, x2, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, -1.0f).endVertex();
        }
        if (tankRenderInfo.shouldRender(Direction.SOUTH)) {
            u1 = still.getU(x1);
            u2 = still.getU(x2);
            v1 = still.getV(y1);
            v2 = still.getV(y2);
            builder.vertex(posMat, x2, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, 1.0f).endVertex();
            builder.vertex(posMat, x2, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, 1.0f).endVertex();
            builder.vertex(posMat, x1, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, 1.0f).endVertex();
            builder.vertex(posMat, x1, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(0.0f, 0.0f, 1.0f).endVertex();
        }
        if (tankRenderInfo.shouldRender(Direction.WEST)) {
            u1 = still.getU(y1);
            u2 = still.getU(y2);
            v1 = still.getV(z1);
            v2 = still.getV(z2);
            builder.vertex(posMat, x1, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(-1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x1, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(-1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x1, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(-1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x1, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(-1.0f, 0.0f, 0.0f).endVertex();
        }
        if (tankRenderInfo.shouldRender(Direction.EAST)) {
            u1 = still.getU(y1);
            u2 = still.getU(y2);
            v1 = still.getV(z1);
            v2 = still.getV(z2);
            builder.vertex(posMat, x2, y1, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y2, z1).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v1).overlayCoords(combinedOverlay).uv2(combinedLight).normal(1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y2, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u2, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(1.0f, 0.0f, 0.0f).endVertex();
            builder.vertex(posMat, x2, y1, z2).color(cols[1], cols[2], cols[3], cols[0]).uv(u1, v2).overlayCoords(combinedOverlay).uv2(combinedLight).normal(1.0f, 0.0f, 0.0f).endVertex();
        }
    }

    private static AABB getRenderBounds(IFluidTank tank, AABB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.maxY - tankBounds.minY;
        double y1 = tankBounds.minY;
        double y2 = tankBounds.minY + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getFluidType().isLighterThanAir()) {
            double yOff = tankBounds.maxY - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AABB(tankBounds.minX, y1, tankBounds.minZ, tankBounds.maxX, y2, tankBounds.maxZ);
    }

    static AABB rotateY(AABB in, int rot) {
        return switch (rot) {
            case 90 -> new AABB(1.0 - in.minZ, in.minY, in.minX, 1.0 - in.maxZ, in.maxY, in.maxX);
            case 180 -> new AABB(1.0 - in.minX, in.minY, 1.0 - in.minZ, 1.0 - in.maxX, in.maxY, 1.0 - in.maxZ);
            case 270 -> new AABB(in.minZ, in.minY, 1.0 - in.minX, in.maxZ, in.maxY, 1.0 - in.maxX);
            default -> throw new IllegalArgumentException("rot must be 90, 180 or 270");
        };
    }

    abstract Collection<TankRenderInfo> getTanksToRender(T var1);
}

