/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;

public class MinigunOverlay
implements IGuiOverlay {
    private static final float MINIGUN_TEXT_SIZE = 0.55f;

    public void render(ExtendedGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        MinigunItem itemMinigun;
        LocalPlayer player;
        Minecraft mc;
        block5: {
            block4: {
                Item item;
                mc = Minecraft.getInstance();
                player = mc.player;
                if (player == null || !((item = player.getMainHandItem().getItem()) instanceof MinigunItem)) break block4;
                itemMinigun = (MinigunItem)item;
                if (Minecraft.getInstance().options.getCameraType().isFirstPerson()) break block5;
            }
            return;
        }
        ItemStack heldStack = player.getMainHandItem();
        Minigun minigun = itemMinigun.getMinigun(heldStack, (Player)player);
        ItemStack ammo = minigun.getAmmoStack();
        if (!ammo.isEmpty()) {
            graphics.renderItem(ammo, width / 2 + 16, height / 2 - 7);
            int remaining = ammo.getMaxDamage() - ammo.getDamageValue();
            graphics.pose().pushPose();
            graphics.pose().translate((float)width / 2.0f + 32.0f, (float)height / 2.0f - 1.0f, 0.0f);
            graphics.pose().scale(0.55f, 0.55f, 1.0f);
            String text = remaining + "/" + ammo.getMaxDamage();
            graphics.drawString(mc.font, text, 1, 0, 0, false);
            graphics.drawString(mc.font, text, -1, 0, 0, false);
            graphics.drawString(mc.font, text, 0, 1, 0, false);
            graphics.drawString(mc.font, text, 0, -1, 0, false);
            graphics.drawString(mc.font, text, 0, 0, minigun.getAmmoColor(), false);
            graphics.pose().popPose();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)0.2f, (float)0.7f, (float)0.2f, (float)0.75f);
        graphics.blit(Textures.MINIGUN_CROSSHAIR, width / 2 - 7, height / 2 - 7, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class Listener {
        @SubscribeEvent
        public static void crosshairsEvent(RenderGuiOverlayEvent.Pre event) {
            boolean firstPerson = Minecraft.getInstance().options.getCameraType().isFirstPerson();
            if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) && ClientUtils.getClientPlayer().getMainHandItem().getItem() instanceof MinigunItem && firstPerson) {
                event.setCanceled(true);
            }
        }
    }
}

