/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

public class PneumaticArmorHUDOverlay
implements IGuiOverlay {
    private static final int PROGRESS_BAR_HEIGHT = 17;
    private final boolean[] gaveCriticalWarning = new boolean[4];
    private final boolean[] gaveLowPressureWarning = new boolean[4];

    public void render(ExtendedGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        ItemStack armorStack;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.options.hideGui || mc.screen != null || !PneumaticArmorItem.isPlayerWearingAnyPneumaticArmor((Player)player)) {
            return;
        }
        Window mw = Minecraft.getInstance().getWindow();
        graphics.pose().pushPose();
        CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer((Player)player);
        boolean anyArmorInInit = false;
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.getItemBySlot(slot);
            if (!(armorStack.getItem() instanceof PneumaticArmorItem) || !(comHudHandler.getArmorPressure(slot) >= 1.0E-4f) || comHudHandler.isArmorReady(slot)) continue;
            anyArmorInInit = true;
            break;
        }
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.getItemBySlot(slot);
            if (!(armorStack.getItem() instanceof PneumaticArmorItem) || !(comHudHandler.getArmorPressure(slot) >= 1.0E-4f)) continue;
            if (anyArmorInInit) {
                this.renderInitProgressBarForSlot(graphics, partialTicks, mw, comHudHandler, slot, armorStack);
            }
            if (!comHudHandler.isArmorReady(slot)) continue;
            this.renderHUDForSlot(graphics, partialTicks, (Player)player, comHudHandler, slot);
        }
        HUDHandler.getInstance().renderMessages(graphics, partialTicks);
        graphics.pose().popPose();
        if (comHudHandler.isArmorEnabled() && anyArmorInInit) {
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!PneumaticArmorItem.isPneumaticArmorPiece((Player)player, slot) || !(comHudHandler.getArmorPressure(slot) > 0.0f)) continue;
                String text = Math.min(100, comHudHandler.getTicksSinceEquipped(slot) * 100 / comHudHandler.getStartupTime(slot)) + "%";
                graphics.drawString(mc.font, text, (float)mw.getGuiScaledWidth() * 0.75f - 8.0f, (float)(14 + 17 * (3 - slot.getIndex())), 0xFFFF40, true);
            }
        }
    }

    private void renderInitProgressBarForSlot(GuiGraphics graphics, float partialTicks, Window mw, CommonArmorHandler comHudHandler, EquipmentSlot slot, ItemStack armorStack) {
        if (comHudHandler.isArmorEnabled()) {
            int xLeft = mw.getGuiScaledWidth() / 2;
            int yOffset = 10 + (3 - slot.getIndex()) * 17;
            float progress = (float)comHudHandler.getTicksSinceEquipped(slot) * 100.0f / (float)comHudHandler.getStartupTime(slot);
            progress = Math.min(100.0f, progress + partialTicks);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            ProgressBarRenderer.render2d(graphics, (float)mw.getGuiScaledWidth() / 2.0f, yOffset, mw.getGuiScaledWidth() - 10, yOffset + 17 - 1, -90.0f, progress, -1426079744, -1442775296);
            RenderSystem.disableBlend();
            graphics.renderItem(armorStack, xLeft + 2, yOffset);
        }
    }

    private void renderHUDForSlot(GuiGraphics matrixStack, float partialTicks, Player player, CommonArmorHandler comHudHandler, EquipmentSlot slot) {
        float pressure = comHudHandler.getArmorPressure(slot);
        this.handlePressureWarnings(player, slot, pressure);
        if (WidgetKeybindCheckBox.getCoreComponents().checked || Minecraft.getInstance().screen == null) {
            List<IArmorUpgradeClientHandler<?>> renderHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                StatPanelLayout layout;
                IArmorUpgradeClientHandler<?> clientHandler = renderHandlers.get(i);
                if (!comHudHandler.isUpgradeInserted(slot, i) || !comHudHandler.isUpgradeEnabled(slot, i) && clientHandler.isToggleable()) continue;
                IGuiAnimatedStat stat = clientHandler.getAnimatedStat();
                if (stat != null && !(layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout())).hidden()) {
                    stat.renderStat(matrixStack, -1, -1, partialTicks);
                }
                clientHandler.render2D(matrixStack, partialTicks, pressure > 0.0f);
            }
        }
    }

    private void handlePressureWarnings(Player player, EquipmentSlot slot, float pressure) {
        if (pressure <= 0.1f && !this.gaveCriticalWarning[slot.getIndex()]) {
            HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.outOfAir", player.getItemBySlot(slot).getHoverName()), 100, 0x70FF0000));
            this.gaveCriticalWarning[slot.getIndex()] = true;
            player.playSound((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 2.0f);
        } else if (pressure > 0.1f && pressure <= 0.5f && !this.gaveLowPressureWarning[slot.getIndex()]) {
            HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.almostOutOfAir", player.getItemBySlot(slot).getHoverName()), 60, 1895792640));
            this.gaveLowPressureWarning[slot.getIndex()] = true;
        }
        if (pressure > 0.6f) {
            this.gaveLowPressureWarning[slot.getIndex()] = false;
        }
        if (pressure > 0.2f) {
            this.gaveCriticalWarning[slot.getIndex()] = false;
        }
    }
}

