/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ClientHooks;

public class PneumaticArmorLayer<E extends LivingEntity, M extends HumanoidModel<E>>
extends RenderLayer<E, M> {
    private final HumanoidModel<E> modelLeggings;
    private final HumanoidModel<E> modelArmor;

    public PneumaticArmorLayer(RenderLayerParent<E, M> entityRendererIn, EntityModelSet models) {
        super(entityRendererIn);
        this.modelLeggings = new HumanoidModel(models.bakeLayer(PNCModelLayers.PNEUMATIC_LEGS));
        this.modelArmor = new HumanoidModel(models.bakeLayer(PNCModelLayers.PNEUMATIC_ARMOR));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.CHEST, packedLightIn, this.modelArmor, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.LEGS, packedLightIn, this.modelLeggings, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.FEET, packedLightIn, this.modelArmor, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.HEAD, packedLightIn, this.modelArmor, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void renderSlot(PoseStack matrixStack, MultiBufferSource buffer, E entity, EquipmentSlot slot, int light, HumanoidModel<E> model, float partialTicks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        PneumaticArmorItem armor;
        ItemStack stack = entity.getItemBySlot(slot);
        Item item = stack.getItem();
        if (item instanceof PneumaticArmorItem && (armor = (PneumaticArmorItem)item).getType().getSlot() == slot) {
            ((HumanoidModel)this.getParentModel()).copyPropertiesTo(model);
            model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
            model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.setModelSlotVisible(model, slot);
            Model model1 = ClientHooks.getArmorModel(entity, (ItemStack)stack, (EquipmentSlot)slot, model);
            boolean glint = stack.hasFoil();
            float[] secondary = RenderUtils.decomposeColorF(armor.getSecondaryColor(stack));
            this.doRender(matrixStack, buffer, light, glint, model1, secondary[1], secondary[2], secondary[3], slot, ExtraLayer.SECONDARY_COLOR);
            if (slot == EquipmentSlot.CHEST) {
                this.doRender(matrixStack, buffer, 0xF000F0, glint, model1, 1.0f, 1.0f, 1.0f, slot, ExtraLayer.TRANSLUCENT);
            }
            if (slot == EquipmentSlot.HEAD) {
                float[] eyepiece = RenderUtils.decomposeColorF(armor.getEyepieceColor(stack));
                this.doRender(matrixStack, buffer, 0xF000F0, false, model1, eyepiece[1], eyepiece[2], eyepiece[3], slot, ExtraLayer.EYEPIECE);
            }
        }
    }

    private void doRender(PoseStack matrixStack, MultiBufferSource buffer, int light, boolean glint, Model model, float r, float g, float b, EquipmentSlot slot, ExtraLayer extraLayer) {
        ResourceLocation armorResource = extraLayer.getArmorResource(slot);
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)extraLayer.getRenderType(armorResource), (boolean)false, (boolean)glint);
        model.renderToBuffer(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, r, g, b, 1.0f);
    }

    protected void setModelSlotVisible(HumanoidModel<E> model, EquipmentSlot slotIn) {
        model.setAllVisible(false);
        switch (slotIn) {
            case HEAD: {
                model.head.visible = true;
                model.hat.visible = true;
                break;
            }
            case CHEST: {
                model.body.visible = true;
                model.rightArm.visible = true;
                model.leftArm.visible = true;
                break;
            }
            case LEGS: {
                model.body.visible = true;
                model.rightLeg.visible = true;
                model.leftLeg.visible = true;
                break;
            }
            case FEET: {
                model.rightLeg.visible = true;
                model.leftLeg.visible = true;
            }
        }
    }

    static enum ExtraLayer {
        SECONDARY_COLOR("overlay", false),
        TRANSLUCENT("translucent", true),
        EYEPIECE("eyepiece", true);

        private final ResourceLocation rl1;
        private final ResourceLocation rl2;
        private final boolean translucent;

        private ExtraLayer(String name, boolean translucent) {
            this.translucent = translucent;
            this.rl1 = PneumaticRegistry.RL("textures/armor/pneumatic_1_" + name + ".png");
            this.rl2 = PneumaticRegistry.RL("textures/armor/pneumatic_2_" + name + ".png");
        }

        RenderType getRenderType(ResourceLocation rl) {
            return this.translucent ? ModRenderTypes.getArmorTranslucentNoCull(rl) : RenderType.armorCutoutNoCull((ResourceLocation)rl);
        }

        ResourceLocation getArmorResource(EquipmentSlot slot) {
            return slot == EquipmentSlot.LEGS ? this.rl2 : this.rl1;
        }
    }
}

