/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.DroneDebuggerOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackEntryDrone;
import me.desht.pneumaticcraft.client.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.InputEvent;
import org.joml.Matrix3f;

public class RenderEntityTarget {
    private static final float STAT_SCALE = 0.02f;
    public final Entity entity;
    private final RenderTargetCircle circle1;
    private final RenderTargetCircle circle2;
    public int ticksExisted = 0;
    private float oldSize;
    private final IGuiAnimatedStat stat;
    private boolean didMakeLockSound;
    public boolean isLookingAtTarget;
    private List<Component> textList = new ArrayList<Component>();
    private final List<IEntityTrackEntry> trackEntries;
    private int hackTime;
    private double distToEntity;

    public RenderEntityTarget(Entity entity) {
        this.entity = entity;
        this.trackEntries = EntityTrackHandler.getInstance().getTrackersForEntity(entity);
        this.circle1 = new RenderTargetCircle(entity);
        this.circle2 = new RenderTargetCircle(entity);
        this.stat = new WidgetAnimatedStat(null, entity.getDisplayName(), WidgetAnimatedStat.StatIcon.NONE, 20, -20, HUDHandler.getInstance().getStatOverlayColor(), null, false);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setAutoLineWrap(false);
    }

    public RenderDroneAI getDroneAIRenderer(AbstractDroneEntity drone) {
        for (IEntityTrackEntry tracker : this.trackEntries) {
            if (!(tracker instanceof EntityTrackEntryDrone)) continue;
            EntityTrackEntryDrone td = (EntityTrackEntryDrone)tracker;
            return td.getDroneAIRenderer(drone);
        }
        throw new IllegalStateException("[RenderTarget] Drone entity, but no drone AI Renderer?");
    }

    public void tick() {
        AbstractDroneEntity drone;
        Entity entity;
        this.stat.tickWidget();
        this.stat.setTitle(this.entity.getDisplayName());
        Player player = ClientUtils.getClientPlayer();
        this.distToEntity = this.entity.distanceTo((Entity)ClientUtils.getClientPlayer());
        if (this.ticksExisted >= 30 && !this.didMakeLockSound) {
            this.didMakeLockSound = true;
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundSource.PLAYERS, 0.1f, 1.0f, true);
        }
        boolean tagged = (entity = this.entity) instanceof AbstractDroneEntity && PneumaticArmorItem.isPlayerDebuggingDrone(player, drone = (AbstractDroneEntity)entity);
        this.circle1.setRenderingAsTagged(tagged);
        this.circle1.tick();
        this.circle2.setRenderingAsTagged(tagged);
        this.circle2.tick();
        this.trackEntries.forEach(tracker -> tracker.tick(this.entity));
        this.isLookingAtTarget = this.isPlayerLookingAtTarget();
        if (this.hackTime > 0) {
            this.hackTime = HackManager.getHackableForEntity(this.entity, ClientUtils.getClientPlayer()) != null ? ++this.hackTime : 0;
        }
    }

    public boolean isInitialized() {
        return this.ticksExisted > 120;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, boolean justRenderWhenHovering) {
        this.trackEntries.forEach(tracker -> tracker.render(matrixStack, buffer, this.entity, partialTicks));
        double x = Mth.lerp((double)partialTicks, (double)this.entity.xo, (double)this.entity.getX());
        double y = Mth.lerp((double)partialTicks, (double)this.entity.yo, (double)this.entity.getY()) + (double)this.entity.getBbHeight() / 2.0;
        double z = Mth.lerp((double)partialTicks, (double)this.entity.zo, (double)this.entity.getZ());
        matrixStack.pushPose();
        matrixStack.translate(x, y, z);
        RenderUtils.rotateToPlayerFacing(matrixStack);
        float size = this.entity.getBbHeight() * 0.5f;
        float alpha = 0.5f;
        if (this.ticksExisted < 60) {
            size += 5.0f - (float)Math.abs(this.ticksExisted) * 0.083f;
            alpha = (float)Math.abs(this.ticksExisted) * 0.005f;
        }
        float renderSize = Mth.lerp((float)partialTicks, (float)this.oldSize, (float)size);
        this.circle1.render(matrixStack, buffer, renderSize, partialTicks, alpha);
        this.circle2.render(matrixStack, buffer, renderSize + 0.2f, partialTicks, alpha);
        float targetAcquireProgress = ((float)this.ticksExisted + partialTicks - 50.0f) / 0.7f;
        if (this.ticksExisted > 50 && this.ticksExisted <= 120) {
            ProgressBarRenderer.render3d(matrixStack, buffer, 0.0f, 0.4f, 1.8f, 0.7f, 0.0f, targetAcquireProgress, -788529408, -805241088);
        }
        matrixStack.scale(0.02f, 0.02f, 0.02f);
        if (this.ticksExisted > 120) {
            if (justRenderWhenHovering && !this.isLookingAtTarget) {
                this.stat.closeStat();
            } else {
                this.stat.openStat();
            }
            this.textList = new ArrayList<Component>();
            for (IEntityTrackEntry tracker2 : this.trackEntries) {
                tracker2.addInfo(this.entity, this.textList, this.isLookingAtTarget);
            }
            this.textList.add((Component)Component.literal((String)String.format("Dist: %.1fm", this.distToEntity)));
            this.stat.setText(this.textList);
            float mul = this.getStatSizeMultiplier(this.distToEntity);
            matrixStack.scale(mul, mul, mul);
            this.stat.renderStat(matrixStack, buffer, partialTicks);
        } else if (this.ticksExisted > 50) {
            RenderUtils.renderString3d((Component)Component.translatable((String)"pneumaticcraft.entityTracker.info.acquiring"), 0.0f, 0.0f, -8421505, matrixStack, buffer, false, true);
            RenderUtils.renderString3d((Component)Component.literal((String)((int)targetAcquireProgress + "%")), 37.0f, 24.0f, -16765184, matrixStack, buffer, false, true);
        } else if (this.ticksExisted < -30) {
            this.stat.closeStat();
            this.stat.renderStat(matrixStack, buffer, partialTicks);
            RenderUtils.renderString3d((Component)Component.translatable((String)"pneumaticcraft.blockTracker.info.lostTarget"), 0.0f, 0.0f, -8421505, matrixStack, buffer, false, true);
        }
        matrixStack.popPose();
        this.oldSize = size;
    }

    private float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return (float)(dist / 4.0);
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    public List<Component> getEntityText() {
        return this.textList;
    }

    private boolean isPlayerLookingAtTarget() {
        Player player = ClientUtils.getClientPlayer();
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.entity.getX() - player.getX(), this.entity.getBoundingBox().minY + (double)(this.entity.getBbHeight() / 2.0f) - (player.getY() + (double)player.getEyeHeight()), this.entity.getZ() - player.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0;
    }

    public void hack() {
        Player player;
        IHackableEntity<?> hackable;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (hackable = HackManager.getHackableForEntity(this.entity, player = ClientUtils.getClientPlayer())) != null && (this.hackTime == 0 || this.hackTime > hackable._getHackTime(this.entity, player))) {
            NetworkHandler.sendToServer(new PacketHackingEntityStart(this.entity.getId()));
        }
    }

    public void selectAsDebuggingTarget() {
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && this.entity instanceof AbstractDroneEntity) {
            DroneDebuggerOptions.clearAreaShowWidgetId();
            Player player = ClientUtils.getClientPlayer();
            if (PneumaticArmorItem.isPlayerDebuggingDrone(player, (AbstractDroneEntity)this.entity)) {
                NetworkHandler.sendToServer(PacketUpdateDebuggingDrone.create(null));
                player.playSound((SoundEvent)ModSounds.SCI_FI.get(), 1.0f, 2.0f);
            } else {
                Entity entity = this.entity;
                if (entity instanceof DroneEntity) {
                    DroneEntity drone = (DroneEntity)entity;
                    NetworkHandler.sendToServer(PacketUpdateDebuggingDrone.create(drone));
                    player.playSound((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), 1.0f, 2.0f);
                } else {
                    entity = this.entity;
                    if (entity instanceof ProgrammableControllerEntity) {
                        ProgrammableControllerEntity pce = (ProgrammableControllerEntity)entity;
                        NetworkHandler.sendToServer(PacketUpdateDebuggingDrone.create(pce.getController()));
                        player.playSound((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), 1.0f, 2.0f);
                    }
                }
            }
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(InputEvent.MouseScrollingEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
        }
        return false;
    }

    public void updateColor(int color) {
        this.stat.setBackgroundColor(color);
    }

    private static class RenderTargetCircle {
        private static final float[] DRONE = new float[]{1.0f, 1.0f, 0.0f};
        private static final float[] HANGING = new float[]{0.0f, 1.0f, 1.0f};
        private static final float[] HOSTILE = new float[]{1.0f, 0.0f, 0.0f};
        private static final float[] DEFAULT = new float[]{0.0f, 1.0f, 0.0f};
        private static final double MAX_ROTATION = 8.0;
        private static final float QUARTER_CIRCLE = 1.5707964f;
        private static final float STEP = 0.10471976f;
        private double oldRotationAngle;
        private double rotationAngle = 0.0;
        private double rotationSpeed = 0.0;
        private double rotationAcceleration = 0.0;
        private final Random rand;
        private boolean renderAsTagged;
        private final float[] cols = new float[4];

        RenderTargetCircle(Entity entity) {
            this.rand = ThreadLocalRandom.current();
            System.arraycopy(this.getCircleColour(entity), 0, this.cols, 0, 3);
            this.cols[3] = 0.5f;
        }

        void setRenderingAsTagged(boolean tagged) {
            this.renderAsTagged = tagged;
        }

        public void tick() {
            this.oldRotationAngle = this.rotationAngle;
            if (this.rand.nextInt(15) == 0) {
                this.rotationAcceleration = (this.rand.nextDouble() - 0.5) / 2.5;
            }
            this.rotationSpeed = Mth.clamp((double)(this.rotationSpeed + this.rotationAcceleration), (double)-8.0, (double)8.0);
            this.rotationAngle += this.rotationSpeed;
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, float size, float partialTicks, float alpha) {
            double renderRotationAngle = Mth.lerp((double)partialTicks, (double)this.oldRotationAngle, (double)this.rotationAngle);
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.ZP.rotationDegrees((float)renderRotationAngle));
            for (int pass = 0; pass < 2; ++pass) {
                RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.TARGET_CIRCLE, (posMat, builder) -> {
                    for (float i = 0.0f; i < 1.5707964f; i += 0.10471976f) {
                        RenderUtils.posF(builder, posMat, Mth.cos((float)i) * size, Mth.sin((float)i) * size, 0.0).color(this.cols[0], this.cols[1], this.cols[2], alpha).uv2(0xF000F0).endVertex();
                        RenderUtils.posF(builder, posMat, Mth.cos((float)i) * (size + 0.1f), Mth.sin((float)i) * (size + 0.1f), 0.0).color(this.cols[0], this.cols[1], this.cols[2], alpha).uv2(0xF000F0).endVertex();
                    }
                });
                if (this.renderAsTagged) {
                    Matrix3f normal = matrixStack.last().normal();
                    RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoops(3.0), (posMat, builder) -> {
                        Vec3 v2;
                        Vec3 v1;
                        float i;
                        for (i = 0.0f; i < 1.5707964f; i += 0.10471976f) {
                            v1 = new Vec3((double)(Mth.cos((float)i) * size), (double)(Mth.sin((float)i) * size), 0.0);
                            v2 = new Vec3((double)(Mth.cos((float)(i + 0.10471976f)) * size), (double)(Mth.sin((float)(i + 0.10471976f)) * size), 0.0);
                            RenderUtils.posF(builder, posMat, v1.x(), v1.y(), 0.0).color(255, 0, 0, 255).normal(normal, (float)(v2.x() - v1.x()), (float)(v2.y() - v1.y()), 0.0f).endVertex();
                        }
                        for (i = 1.4660766f; i >= 0.0f; i -= 0.10471976f) {
                            v1 = new Vec3((double)(Mth.cos((float)i) * size), (double)(Mth.sin((float)i) * size), 0.0);
                            v2 = new Vec3((double)(Mth.cos((float)(i + 0.10471976f)) * size), (double)(Mth.sin((float)(i + 0.10471976f)) * size), 0.0);
                            RenderUtils.posF(builder, posMat, v1.x(), v1.y(), 0.0).color(255, 0, 0, 255).normal(normal, (float)(v2.x() - v1.x()), (float)(v2.y() - v1.y()), 0.0f).endVertex();
                        }
                    });
                }
                matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
            matrixStack.popPose();
        }

        private float[] getCircleColour(Entity entity) {
            if (entity instanceof AbstractDroneEntity) {
                return DRONE;
            }
            if (entity instanceof Enemy) {
                return HOSTILE;
            }
            if (entity instanceof HangingEntity || entity instanceof AbstractMinecart) {
                return HANGING;
            }
            return DEFAULT;
        }
    }
}

