/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderNavigator {
    private final BlockPos targetPos;
    private Path path;
    private boolean increaseAlpha;
    private float alphaValue = 0.2f;

    public RenderNavigator(BlockPos targetPos) {
        this.targetPos = targetPos;
        this.updatePath();
    }

    public void updatePath() {
        LocalPlayer player = Minecraft.getInstance().player;
        Mob e = PneumaticCraftUtils.createDummyEntity((Player)player);
        e.setOnGround(player.onGround());
        this.path = e.getNavigation().createPath(this.targetPos, 1);
        if (!this.tracedToDestination()) {
            this.path = CoordTrackClientHandler.getDronePath((Player)player, this.targetPos);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, boolean wirePath, boolean xRayEnabled, float partialTicks) {
        if (this.path == null) {
            return;
        }
        boolean hasDestinationPath = this.tracedToDestination();
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.01, 0.0);
        Matrix4f posMat = matrixStack.last().pose();
        if (wirePath) {
            VertexConsumer builder = buffer.getBuffer(ModRenderTypes.getLineLoops(5.0));
            Matrix3f normal = matrixStack.last().normal();
            for (int i = 1; i < this.path.getNodeCount(); ++i) {
                float red = 1.0f;
                if (this.path.getNodeCount() - i < 200) {
                    red = (float)(this.path.getNodeCount() - i) * 0.005f;
                }
                Node lastPoint = this.path.getNode(i - 1);
                Node pathPoint = this.path.getNode(i);
                builder.vertex(posMat, (float)lastPoint.x + 0.5f, (float)lastPoint.y, (float)lastPoint.z + 0.5f).color(red, 1.0f - red, 0.0f, 0.5f).normal(normal, (float)(pathPoint.x - lastPoint.x), (float)(pathPoint.y - lastPoint.y), (float)(pathPoint.z - lastPoint.z)).endVertex();
                builder.vertex(posMat, (float)(lastPoint.x + pathPoint.x) / 2.0f + 0.5f, (float)Math.max(lastPoint.y, pathPoint.y), (float)(lastPoint.z + pathPoint.z) / 2.0f + 0.5f).color(red, 1.0f - red, 0.0f, 0.5f).normal(normal, (float)(pathPoint.x - lastPoint.x), (float)(pathPoint.y - lastPoint.y), (float)(pathPoint.z - lastPoint.z)).endVertex();
                builder.vertex(posMat, (float)pathPoint.x + 0.5f, (float)pathPoint.y, (float)pathPoint.z + 0.5f).color(red, 1.0f - red, 0.0f, 0.5f).normal(normal, (float)(pathPoint.x - lastPoint.x), (float)(pathPoint.y - lastPoint.y), (float)(pathPoint.z - lastPoint.z)).endVertex();
            }
        } else {
            VertexConsumer builder = buffer.getBuffer(xRayEnabled ? ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH : ModRenderTypes.UNTEXTURED_QUAD);
            if (hasDestinationPath) {
                if (this.alphaValue > 0.2f) {
                    this.alphaValue -= 0.005f;
                }
            } else if (this.increaseAlpha) {
                this.alphaValue += 0.005f;
                if (this.alphaValue > 0.3f) {
                    this.increaseAlpha = false;
                }
            } else {
                this.alphaValue -= 0.005f;
                if (this.alphaValue < 0.2f) {
                    this.increaseAlpha = true;
                }
            }
            for (int i = 0; i < this.path.getNodeCount(); ++i) {
                float red = 1.0f;
                if (this.path.getNodeCount() - i < 200) {
                    red = (float)(this.path.getNodeCount() - i) * 0.005f;
                }
                Node pathPoint = this.path.getNode(i);
                builder.vertex(posMat, (float)pathPoint.x, (float)pathPoint.y, (float)pathPoint.z).color(red, 1.0f - red, 0.0f, this.alphaValue).uv2(0xF000F0).endVertex();
                builder.vertex(posMat, (float)pathPoint.x, (float)pathPoint.y, (float)(pathPoint.z + 1)).color(red, 1.0f - red, 0.0f, this.alphaValue).uv2(0xF000F0).endVertex();
                builder.vertex(posMat, (float)(pathPoint.x + 1), (float)pathPoint.y, (float)(pathPoint.z + 1)).color(red, 1.0f - red, 0.0f, this.alphaValue).uv2(0xF000F0).endVertex();
                builder.vertex(posMat, (float)(pathPoint.x + 1), (float)pathPoint.y, (float)pathPoint.z).color(red, 1.0f - red, 0.0f, this.alphaValue).uv2(0xF000F0).endVertex();
            }
        }
        matrixStack.popPose();
    }

    public boolean tracedToDestination() {
        if (this.path == null) {
            return false;
        }
        Node finalPoint = this.path.getEndNode();
        return finalPoint != null && this.targetPos.equals((Object)new BlockPos(finalPoint.x, finalPoint.y, finalPoint.z));
    }
}

