/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class PressureGaugeRenderer2D {
    static final int CIRCLE_POINTS = 500;
    static final float RADIUS = 20.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    static final float STOP_ANGLE = -1.0471976f;
    static final int GAUGE_POINTS = 416;
    static final float[] RED = new float[]{0.722f, 0.255f, 0.255f, 1.0f};
    static final float[] GREEN = new float[]{0.475f, 0.678f, 0.224f, 1.0f};
    static final float[] YELLOW = new float[]{0.922f, 0.635f, 0.239f, 1.0f};

    public static void drawPressureGauge(GuiGraphics graphics, Font fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer2D.drawPressureGauge(graphics, fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(GuiGraphics graphics, Font fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        RenderSystem.lineWidth((float)1.0f);
        BufferBuilder wr = Tesselator.getInstance().getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        wr.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        PressureGaugeRenderer2D.drawGaugeBackground(graphics, (VertexConsumer)wr, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos);
        Tesselator.getInstance().end();
        wr.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        PressureGaugeRenderer2D.drawGaugeSurround(graphics, (VertexConsumer)wr, xPos, yPos, fgColor);
        Tesselator.getInstance().end();
        int currentScale = (int)maxPressure;
        ArrayList<TextScaler> textScalers = new ArrayList<TextScaler>();
        wr.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        PressureGaugeRenderer2D.drawScale(graphics, (VertexConsumer)wr, minPressure, maxPressure, xPos, yPos, currentScale, textScalers);
        Tesselator.getInstance().end();
        float angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        angleIndicator = -angleIndicator / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
        wr.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        PressureGaugeRenderer2D.drawNeedle(graphics, (VertexConsumer)wr, xPos, yPos, angleIndicator, fgColor);
        Tesselator.getInstance().end();
        PressureGaugeRenderer2D.drawText(graphics, fontRenderer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawNeedle(GuiGraphics graphics, VertexConsumer builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = graphics.pose().last().pose();
        builder.vertex(posMat, Mth.cos((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)xPos, Mth.sin((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)yPos, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        builder.vertex(posMat, Mth.cos((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)xPos, Mth.sin((float)(angle + 3.487168f)) * 20.0f * 0.3f + (float)yPos, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        builder.vertex(posMat, Mth.cos((float)angle) * 20.0f * 0.8f + (float)xPos, Mth.sin((float)angle) * 20.0f * 0.8f + (float)yPos, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        builder.vertex(posMat, Mth.cos((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)xPos, Mth.sin((float)(angle + 2.7960174f)) * 20.0f * 0.3f + (float)yPos, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
    }

    private static void drawScale(GuiGraphics graphics, VertexConsumer builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<TextScaler> textScalers) {
        Matrix4f posMat = graphics.pose().last().pose();
        for (int i = 0; i <= 416; ++i) {
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            float x = Mth.cos((float)angle);
            float y = Mth.sin((float)angle);
            textScalers.add(new TextScaler(currentScale, (int)((double)(x * 20.0f) * 1.25), (int)((double)(y * 20.0f) * 1.25)));
            --currentScale;
            float r1 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            builder.vertex(posMat, x * 20.0f * r1 + (float)xPos, y * 20.0f * r1 + (float)yPos, 0.0f).color(0, 0, 0, 1).endVertex();
            builder.vertex(posMat, x * 20.0f * r2 + (float)xPos, y * 20.0f * r2 + (float)yPos, 0.0f).color(0, 0, 0, 1).endVertex();
        }
    }

    private static void drawText(GuiGraphics graphics, Font fontRenderer, int xPos, int yPos, int fgColor, List<TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 14 && i % 5 != 0) continue;
            TextScaler scaler = textScalers.get(i);
            graphics.pose().pushPose();
            graphics.pose().translate((double)(xPos + scaler.x()) - 1.5, (double)(yPos + scaler.y()) - 1.5, 0.0);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            graphics.drawString(fontRenderer, Integer.toString(scaler.pressure()), 0, 0, fgColor, false);
            graphics.pose().popPose();
        }
    }

    private static void drawGaugeBackground(GuiGraphics graphics, VertexConsumer builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = RED;
        Matrix4f posMat = graphics.pose().last().pose();
        builder.vertex(posMat, (float)xPos, (float)yPos, 0.0f).color(0.5f, 0.5f, 0.1f, 1.0f).endVertex();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? YELLOW : GREEN;
                builder.vertex(posMat, (float)xPos, (float)yPos, 0.0f).color(color[0], color[1], color[2], color[3]).endVertex();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? GREEN : YELLOW;
                builder.vertex(posMat, (float)xPos, (float)yPos, 0.0f).color(color[0], color[1], color[2], color[3]).endVertex();
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 500.0f * 2.0f * (float)Math.PI - -1.0471976f;
            builder.vertex(posMat, Mth.cos((float)angle) * 20.0f + (float)xPos, Mth.sin((float)angle) * 20.0f + (float)yPos, 0.0f).color(color[0], color[1], color[2], color[3]).endVertex();
        }
    }

    private static void drawGaugeSurround(GuiGraphics graphics, VertexConsumer builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        Matrix4f posMat = graphics.pose().last().pose();
        for (int i = 0; i < 500; ++i) {
            float angle = (float)i / 500.0f * 2.0f * (float)Math.PI;
            builder.vertex(posMat, Mth.cos((float)angle) * 20.0f + (float)xPos, Mth.sin((float)angle) * 20.0f + (float)yPos, 0.0f).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        }
    }

    record TextScaler(int pressure, int x, int y) {
    }
}

