/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.common.tubemodules.LogisticsModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class LogisticsRenderer
extends AbstractTubeModuleRenderer<LogisticsModule> {
    private final ModelPart base2;
    private final ModelPart shape1;
    private final ModelPart shape2;
    private final ModelPart shape3;
    private final ModelPart shape4;
    private final ModelPart notPowered;
    private final ModelPart powered;
    private final ModelPart action;
    private final ModelPart notEnoughAir;
    private static final String BASE2 = "base2";
    private static final String SHAPE1 = "shape1";
    private static final String SHAPE2 = "shape2";
    private static final String SHAPE3 = "shape3";
    private static final String SHAPE4 = "shape4";
    private static final String NOTPOWERED = "notPowered";
    private static final String POWERED = "powered";
    private static final String ACTION = "action";
    private static final String NOTENOUGHAIR = "notEnoughAir";

    public LogisticsRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.LOGISTICS_MODULE);
        this.base2 = root.getChild(BASE2);
        this.shape1 = root.getChild(SHAPE1);
        this.shape2 = root.getChild(SHAPE2);
        this.shape3 = root.getChild(SHAPE3);
        this.shape4 = root.getChild(SHAPE4);
        this.notPowered = root.getChild(NOTPOWERED);
        this.powered = root.getChild(POWERED);
        this.action = root.getChild(ACTION);
        this.notEnoughAir = root.getChild(NOTENOUGHAIR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(BASE2, CubeListBuilder.create().texOffs(0, 25).addBox("base2_0", 0.0f, 0.0f, 0.0f, 12.0f, 2.0f, 12.0f), PartPose.offsetAndRotation((float)-6.0f, (float)10.0f, (float)6.0f, (float)-1.570796f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(SHAPE1, CubeListBuilder.create().texOffs(0, 39).addBox("shape1_0", 0.0f, 0.0f, 0.0f, 1.0f, 13.0f, 1.0f), PartPose.offset((float)5.5f, (float)9.5f, (float)5.5f));
        partdefinition.addOrReplaceChild(SHAPE2, CubeListBuilder.create().texOffs(4, 39).addBox("shape2_0", 0.0f, 0.0f, 0.0f, 1.0f, 13.0f, 1.0f), PartPose.offset((float)-6.5f, (float)9.5f, (float)5.5f));
        partdefinition.addOrReplaceChild(SHAPE3, CubeListBuilder.create().texOffs(8, 39).addBox("shape3_0", 0.0f, 0.0f, 0.0f, 11.0f, 1.0f, 1.0f), PartPose.offset((float)-5.5f, (float)9.5f, (float)5.5f));
        partdefinition.addOrReplaceChild(SHAPE4, CubeListBuilder.create().texOffs(8, 41).addBox("shape4_0", 0.0f, 0.0f, 0.0f, 11.0f, 1.0f, 1.0f), PartPose.offset((float)-5.5f, (float)21.5f, (float)5.5f));
        partdefinition.addOrReplaceChild(NOTPOWERED, CubeListBuilder.create().texOffs(24, 8).addBox("notPowered_0", 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)13.0f, (float)4.0f, (float)-1.570796f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(POWERED, CubeListBuilder.create().texOffs(0, 8).addBox("powered_0", 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)13.0f, (float)4.0f, (float)-1.570796f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(ACTION, CubeListBuilder.create().texOffs(24, 0).addBox("action_0", 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)13.0f, (float)4.0f, (float)-1.570796f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild(NOTENOUGHAIR, CubeListBuilder.create().texOffs(0, 0).addBox("notEnoughAir_0", 0.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)13.0f, (float)4.0f, (float)-1.570796f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void render(LogisticsModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, float alpha) {
        ModelPart base = module.getTicksSinceAction() >= 0 ? this.action : (module.getTicksSinceNotEnoughAir() >= 0 ? this.notEnoughAir : (module.hasPower() ? this.powered : this.notPowered));
        base.render(matrixStack, builder, 0xF000F0, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.base2.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        float[] cols = DyeColor.byId((int)module.getColorChannel()).getTextureDiffuseColors();
        this.shape1.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.shape2.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.shape3.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.shape4.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return Textures.MODEL_LOGISTICS_MODULE;
    }
}

