/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer3D;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.PressureGaugeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PressureGaugeRenderer
extends AbstractTubeModuleRenderer<PressureGaugeModule> {
    private static final float GAUGE_SCALE = 0.007f;
    private static final Component BAR = Component.literal((String)"bar");
    private final Font font;
    private final ModelPart tubeConnector1;
    private final ModelPart tubeConnector2;
    private final ModelPart faceplate;
    private final ModelPart gauge1;
    private final ModelPart gauge2;
    private final ModelPart gauge3;
    private final ModelPart gauge4;
    private final ModelPart gauge5;
    private final ModelPart gauge6;
    private final ModelPart gauge7;
    private final ModelPart gauge8;
    private static final String TUBECONNECTOR1 = "tubeConnector1";
    private static final String TUBECONNECTOR2 = "tubeConnector2";
    private static final String FACEPLATE = "faceplate";
    private static final String GAUGE1 = "gauge1";
    private static final String GAUGE2 = "gauge2";
    private static final String GAUGE3 = "gauge3";
    private static final String GAUGE4 = "gauge4";
    private static final String GAUGE5 = "gauge5";
    private static final String GAUGE6 = "gauge6";
    private static final String GAUGE7 = "gauge7";
    private static final String GAUGE8 = "gauge8";

    public PressureGaugeRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.getFont();
        ModelPart root = ctx.bakeLayer(PNCModelLayers.PRESSURE_GAUGE_MODULE);
        this.tubeConnector1 = root.getChild(TUBECONNECTOR1);
        this.tubeConnector2 = root.getChild(TUBECONNECTOR2);
        this.faceplate = root.getChild(FACEPLATE);
        this.gauge1 = root.getChild(GAUGE1);
        this.gauge2 = root.getChild(GAUGE2);
        this.gauge3 = root.getChild(GAUGE3);
        this.gauge4 = root.getChild(GAUGE4);
        this.gauge5 = root.getChild(GAUGE5);
        this.gauge6 = root.getChild(GAUGE6);
        this.gauge7 = root.getChild(GAUGE7);
        this.gauge8 = root.getChild(GAUGE8);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(TUBECONNECTOR1, CubeListBuilder.create().texOffs(0, 0).addBox("tubeConnector1_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR2, CubeListBuilder.create().texOffs(22, 6).addBox("tubeConnector2_0", -2.0f, -2.0f, 2.0f, 7.0f, 7.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(FACEPLATE, CubeListBuilder.create().texOffs(0, 6).addBox("faceplate_0", -1.0f, -1.0f, 0.0f, 10.0f, 10.0f, 1.0f), PartPose.offset((float)-4.0f, (float)12.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(GAUGE1, CubeListBuilder.create().texOffs(0, 17).addBox("gauge1_0", -3.0f, -2.0f, 0.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE2, CubeListBuilder.create().texOffs(4, 17).addBox("gauge2_0", 4.0f, -2.0f, 0.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE3, CubeListBuilder.create().texOffs(8, 17).addBox("gauge3_0", 3.0f, -3.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE4, CubeListBuilder.create().texOffs(12, 17).addBox("gauge4_0", 3.0f, 2.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE5, CubeListBuilder.create().texOffs(8, 19).addBox("gauge5_0", -2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE6, CubeListBuilder.create().texOffs(12, 19).addBox("gauge6_0", -2.0f, 2.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE7, CubeListBuilder.create().texOffs(0, 24).addBox("gauge7_0", -1.0f, 3.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        partdefinition.addOrReplaceChild(GAUGE8, CubeListBuilder.create().texOffs(0, 22).addBox("gauge8_0", -1.0f, -4.0f, 0.0f, 4.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)5.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    protected void render(PressureGaugeModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, float alpha) {
        this.tubeConnector1.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector2.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.faceplate.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge1.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge2.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge3.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge4.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge5.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge6.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge7.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.gauge8.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public void renderExtras(PressureGaugeModule module, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, int combinedLight, int combinedOverlay) {
        if (module.isFake()) {
            return;
        }
        BlockPos pos = module.getTube().getBlockPos();
        if (ClientUtils.getClientPlayer().distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 256.0) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        RenderUtils.rotateMatrixForDirection(matrixStack, module.getDirection());
        PressureTubeBlockEntity te = module.getTube();
        matrixStack.translate(0.0, 1.01, 0.378);
        matrixStack.scale(0.007f, 0.007f, 0.007f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        if (module.shouldShowGauge()) {
            PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, -1.0f, te.getCriticalPressure(), te.getDangerPressure(), 0.0f, te.getPressure(), 0, 0, -16777216);
        } else {
            MutableComponent s = Component.literal((String)PneumaticCraftUtils.roundNumberTo(te.getPressure(), 1));
            RenderUtils.renderString3d((Component)s, (float)(-this.font.width((FormattedText)s)) / 2.0f, -10.0f, 0, matrixStack, buffer, false, false);
            RenderUtils.renderString3d(BAR, (float)(-this.font.width((FormattedText)BAR)) / 2.0f, 0.0f, 0, matrixStack, buffer, false, false);
        }
        matrixStack.popPose();
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_GAUGE_UPGRADED : Textures.MODEL_GAUGE;
    }
}

