/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tube_module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.tube_module.AbstractTubeModuleRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public class RedstoneRenderer
extends AbstractTubeModuleRenderer<RedstoneModule> {
    private final ModelPart redstoneConnector;
    private final ModelPart faceplate;
    private final ModelPart tubeConnector1;
    private final ModelPart tubeConnector2;
    private final ModelPart tubeConnector3;
    private final ModelPart tubeConnector4;
    private final ModelPart tubeConnector5;
    private final ModelPart tubeConnector6;
    private final ModelPart frame1;
    private final ModelPart frame2;
    private final ModelPart frame3;
    private final ModelPart frame4;
    private static final String REDSTONECONNECTOR = "redstoneConnector";
    private static final String FACEPLATE = "faceplate";
    private static final String TUBECONNECTOR1 = "tubeConnector1";
    private static final String TUBECONNECTOR2 = "tubeConnector2";
    private static final String TUBECONNECTOR3 = "tubeConnector3";
    private static final String TUBECONNECTOR4 = "tubeConnector4";
    private static final String TUBECONNECTOR5 = "tubeConnector5";
    private static final String TUBECONNECTOR6 = "tubeConnector6";
    private static final String FRAME1 = "frame1";
    private static final String FRAME2 = "frame2";
    private static final String FRAME3 = "frame3";
    private static final String FRAME4 = "frame4";

    public RedstoneRenderer(BlockEntityRendererProvider.Context ctx) {
        ModelPart root = ctx.bakeLayer(PNCModelLayers.REDSTONE_MODULE);
        this.redstoneConnector = root.getChild(REDSTONECONNECTOR);
        this.faceplate = root.getChild(FACEPLATE);
        this.tubeConnector1 = root.getChild(TUBECONNECTOR1);
        this.tubeConnector2 = root.getChild(TUBECONNECTOR2);
        this.tubeConnector3 = root.getChild(TUBECONNECTOR3);
        this.tubeConnector4 = root.getChild(TUBECONNECTOR4);
        this.tubeConnector5 = root.getChild(TUBECONNECTOR5);
        this.tubeConnector6 = root.getChild(TUBECONNECTOR6);
        this.frame1 = root.getChild(FRAME1);
        this.frame2 = root.getChild(FRAME2);
        this.frame3 = root.getChild(FRAME3);
        this.frame4 = root.getChild(FRAME4);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(REDSTONECONNECTOR, CubeListBuilder.create().texOffs(0, 0).addBox("redstoneConnector_0", 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)6.05f));
        partdefinition.addOrReplaceChild(FACEPLATE, CubeListBuilder.create().texOffs(12, 0).addBox("faceplate_0", 0.0f, 0.0f, -1.0f, 8.0f, 8.0f, 2.0f), PartPose.offset((float)-4.0f, (float)12.0f, (float)5.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR1, CubeListBuilder.create().texOffs(12, 10).addBox("tubeConnector1_0", -2.0f, -2.0f, 1.0f, 7.0f, 7.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR2, CubeListBuilder.create().texOffs(12, 18).addBox("tubeConnector2_0", -1.0f, -1.0f, 0.0f, 5.0f, 5.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR3, CubeListBuilder.create().texOffs(28, 12).addBox("tubeConnector3_0", 4.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR4, CubeListBuilder.create().texOffs(28, 16).addBox("tubeConnector4_0", 0.0f, 4.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR5, CubeListBuilder.create().texOffs(32, 12).addBox("tubeConnector5_0", -2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(TUBECONNECTOR6, CubeListBuilder.create().texOffs(28, 10).addBox("tubeConnector6_0", 0.0f, -2.0f, 0.0f, 3.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)14.5f, (float)2.0f));
        partdefinition.addOrReplaceChild(FRAME1, CubeListBuilder.create().texOffs(32, 0).addBox("frame1_0", 2.0f, 1.5f, -3.75f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-4.0f, (float)11.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME2, CubeListBuilder.create().texOffs(32, 5).addBox("frame2_0", 2.0f, -1.5f, -3.75f, 4.0f, 1.0f, 4.0f), PartPose.offset((float)-4.0f, (float)19.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME3, CubeListBuilder.create().texOffs(0, 6).addBox("frame3_0", -1.5f, 0.5f, -3.75f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)3.5f, (float)12.5f, (float)6.0f));
        partdefinition.addOrReplaceChild(FRAME4, CubeListBuilder.create().texOffs(0, 16).addBox("frame4_0", 1.5f, 0.5f, -3.75f, 1.0f, 6.0f, 4.0f), PartPose.offset((float)-4.5f, (float)12.5f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    protected void render(RedstoneModule module, PoseStack matrixStack, VertexConsumer builder, float partialTicks, int combinedLight, int combinedOverlay, float alpha) {
        this.tubeConnector1.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector2.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector3.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector4.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector5.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.tubeConnector6.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        this.faceplate.render(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        float[] cols = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (!module.isFake()) {
            int l = module.getRedstoneDirection() == RedstoneModule.EnumRedstoneDirection.INPUT ? module.getInputLevel() : module.getRedstoneLevel();
            cols = RenderUtils.decomposeColorF(0xFF300000 | l * 13 << 16);
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.0, 0.325);
            matrixStack.scale(1.0f, 1.0f, 0.25f + 0.72f * Mth.lerp((float)partialTicks, (float)module.lastExtension, (float)module.extension));
            matrixStack.translate(0.0, 0.0, -0.325);
        }
        this.redstoneConnector.render(matrixStack, builder, combinedLight, combinedOverlay, cols[1], cols[2], cols[3], cols[0]);
        if (!module.isFake()) {
            matrixStack.popPose();
        }
        cols = DyeColor.byId((int)module.getColorChannel()).getTextureDiffuseColors();
        this.frame1.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.frame2.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.frame3.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
        this.frame4.render(matrixStack, builder, combinedLight, combinedOverlay, cols[0], cols[1], cols[2], alpha);
    }

    @Override
    protected ResourceLocation getTexture(boolean isUpgraded) {
        return isUpgraded ? Textures.MODEL_REDSTONE_MODULE_UPGRADED : Textures.MODEL_REDSTONE_MODULE;
    }
}

