/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class MovingSoundJackhammer
extends AbstractTickableSoundInstance {
    private final Player player;
    private static final Map<UUID, Long> timers = new HashMap<UUID, Long>();

    public MovingSoundJackhammer(Player player) {
        super((SoundEvent)ModSounds.JACKHAMMER_LOOP.get(), SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = ((Double)ConfigHelper.client().sound.jackhammerVolume.get()).floatValue();
    }

    static MovingSoundJackhammer startOrContinue(Player player) {
        MovingSoundJackhammer res = MovingSoundJackhammer.lastJackHammerTime(player) > 15L ? new MovingSoundJackhammer(player) : null;
        timers.put(player.getUUID(), player.level().getGameTime());
        return res;
    }

    public void tick() {
        this.x = this.player.getX();
        this.y = this.player.getY();
        this.z = this.player.getZ();
        if (MovingSoundJackhammer.lastJackHammerTime(this.player) == 15L) {
            this.player.level().playSound(this.player, this.player.getX(), this.player.getY(), this.player.getZ(), (SoundEvent)ModSounds.JACKHAMMER_STOP.get(), SoundSource.PLAYERS, ((Double)ConfigHelper.client().sound.jackhammerVolume.get()).floatValue(), 1.0f);
        }
    }

    public boolean isStopped() {
        return MovingSoundJackhammer.lastJackHammerTime(this.player) > 15L;
    }

    public static long lastJackHammerTime(Player player) {
        return player.getCommandSenderWorld().getGameTime() - timers.getOrDefault(player.getUUID(), 0L);
    }
}

