/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.SentryTurretBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModParticleTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class MovingSoundMinigun
extends AbstractTickableSoundInstance {
    private final Entity entity;
    private final BlockEntity tileEntity;
    private boolean finished = false;

    MovingSoundMinigun(Entity entity) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.entity = entity;
        this.tileEntity = null;
        this.init(entity instanceof DroneEntity ? ((Double)ConfigHelper.client().sound.minigunVolumeDrone.get()).floatValue() : ((Double)ConfigHelper.client().sound.minigunVolumeHeld.get()).floatValue());
    }

    MovingSoundMinigun(BlockEntity te) {
        super((SoundEvent)ModSounds.MINIGUN.get(), SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.entity = null;
        this.tileEntity = te;
        this.x = this.tileEntity.getBlockPos().getX();
        this.y = this.tileEntity.getBlockPos().getY();
        this.z = this.tileEntity.getBlockPos().getZ();
        this.init(((Double)ConfigHelper.client().sound.minigunVolumeSentryTurret.get()).floatValue());
    }

    private void init(float volume) {
        this.looping = true;
        this.delay = 0;
        this.volume = volume;
    }

    public void tick() {
        Minigun minigun = null;
        boolean wasFinished = this.finished;
        if (this.entity != null) {
            if (!this.entity.isAlive()) {
                this.finished = true;
            } else {
                this.x = (float)this.entity.getX();
                this.y = (float)this.entity.getY();
                this.z = (float)this.entity.getZ();
                Entity entity = this.entity;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemStack curItem = player.getMainHandItem();
                    if (curItem.getItem() == ModItems.MINIGUN.get()) {
                        minigun = ((MinigunItem)ModItems.MINIGUN.get()).getMinigun(curItem, player);
                    }
                } else {
                    entity = this.entity;
                    if (entity instanceof DroneEntity) {
                        DroneEntity drone = (DroneEntity)entity;
                        minigun = drone.getMinigun();
                    }
                }
            }
        } else if (this.tileEntity != null) {
            if (this.tileEntity.isRemoved()) {
                this.finished = true;
            } else if (this.tileEntity instanceof SentryTurretBlockEntity) {
                minigun = ((SentryTurretBlockEntity)this.tileEntity).getMinigun();
            }
        }
        if (minigun != null) {
            this.playParticles(minigun);
        }
        boolean bl = this.finished = minigun == null || !minigun.isMinigunActivated() || (double)minigun.getMinigunSpeed() < 0.36000000536441806;
        if (this.finished && !wasFinished) {
            Vec3 startVec;
            ClientUtils.getClientLevel().playSound(ClientUtils.getClientPlayer(), this.x, this.y, this.z, (SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.NEUTRAL, this.volume, 1.0f);
            if (minigun != null && (startVec = minigun.getMuzzlePosition()) != null) {
                ClientUtils.getClientLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, startVec.x, startVec.y, startVec.z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void playParticles(Minigun minigun) {
        Vec3 muzzlePos = minigun.getMuzzlePosition();
        if (muzzlePos == null) {
            return;
        }
        Vec3 lookVec = minigun.getLookAngle();
        RandomSource r = ClientUtils.getClientLevel().random;
        for (int i = 0; i < 10; ++i) {
            Vec3 velVec = lookVec.scale((double)(3.0f + (float)i * 0.2f));
            Particle bullet = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ModParticleTypes.BULLET_PARTICLE.get(), muzzlePos.x + (double)(r.nextFloat() * 0.1f) - (double)0.05f, muzzlePos.y + (double)(r.nextFloat() * 0.1f) - (double)0.05f, muzzlePos.z + (double)(r.nextFloat() * 0.1f) - (double)0.05f, velVec.x, velVec.y, velVec.z);
            if (bullet == null) continue;
            switch (r.nextInt(8)) {
                case 0: {
                    bullet.setColor(0.1f, 0.1f, 0.1f);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    bullet.setColor(1.0f, 0.25f + r.nextFloat() * 0.75f, 0.0f);
                    break;
                }
                default: {
                    float[] rgb = RenderUtils.decomposeColorF(minigun.getAmmoColor());
                    bullet.setColor(rgb[1], rgb[2], rgb[3]);
                }
            }
            bullet.scale(minigun.getParticleScale());
        }
        if (r.nextInt(10) == 0) {
            ClientUtils.getClientLevel().addParticle((ParticleOptions)ParticleTypes.FLAME, muzzlePos.x, muzzlePos.y, muzzlePos.z, lookVec.x * (double)0.01f, lookVec.y * (double)0.01f, lookVec.z * (double)0.01f);
        }
    }

    public boolean isStopped() {
        return this.finished;
    }
}

