/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.sound;

import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.sound.MovingSoundAirLeak;
import me.desht.pneumaticcraft.client.sound.MovingSoundElevator;
import me.desht.pneumaticcraft.client.sound.MovingSoundJackhammer;
import me.desht.pneumaticcraft.client.sound.MovingSoundJetBoots;
import me.desht.pneumaticcraft.client.sound.MovingSoundMinigun;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class MovingSounds {
    private static final Map<BlockPos, AbstractTickableSoundInstance> posToTickableSound = new HashMap<BlockPos, AbstractTickableSoundInstance>();

    private static AbstractTickableSoundInstance createMovingSound(Sound s, Object focus, Object ... extraData) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return null;
        }
        switch (s) {
            case JET_BOOTS: {
                if (!(focus instanceof Player)) break;
                Player player = (Player)focus;
                return new MovingSoundJetBoots(player);
            }
            case MINIGUN: {
                if (focus instanceof Player || focus instanceof DroneEntity) {
                    return new MovingSoundMinigun((Entity)focus);
                }
                if (!(focus instanceof BlockPos)) break;
                BlockPos pos = (BlockPos)focus;
                BlockEntity te = world.getBlockEntity(pos);
                return te == null ? null : new MovingSoundMinigun(te);
            }
            case ELEVATOR: {
                if (!(focus instanceof BlockPos)) break;
                BlockPos pos = (BlockPos)focus;
                BlockEntity te = world.getBlockEntity(pos);
                return te instanceof ElevatorBaseBlockEntity ? new MovingSoundElevator((ElevatorBaseBlockEntity)te) : null;
            }
            case AIR_LEAK: {
                if (focus instanceof BlockPos) {
                    BlockPos pos = (BlockPos)focus;
                    AbstractTickableSoundInstance sound = posToTickableSound.get(pos);
                    if (sound != null && !sound.isStopped()) {
                        return null;
                    }
                    BlockEntity te = world.getBlockEntity(pos);
                    if (te != null && PNCCapabilities.getAirHandler(te).isPresent()) {
                        sound = new MovingSoundAirLeak(te, (Direction)extraData[0]);
                        posToTickableSound.put(pos, sound);
                        return sound;
                    }
                }
                return null;
            }
            case JACKHAMMER: {
                if (!(focus instanceof Player)) break;
                Player player = (Player)focus;
                return MovingSoundJackhammer.startOrContinue(player);
            }
        }
        throw new IllegalArgumentException("Invalid moving sound " + s + " for focus object " + focus);
    }

    public static void playMovingSound(Sound s, Object focus, Object ... extraData) {
        AbstractTickableSoundInstance movingSound = MovingSounds.createMovingSound(s, focus, extraData);
        if (movingSound != null) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)movingSound);
        }
    }

    public static enum Sound {
        JET_BOOTS,
        MINIGUN,
        ELEVATOR,
        AIR_LEAK,
        JACKHAMMER;

    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static class Listener {
        private Listener() {
        }

        @SubscribeEvent
        public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
            if (event.getLevel().isClientSide && event.getEntity() instanceof LocalPlayer) {
                posToTickableSound.clear();
            }
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            posToTickableSound.values().removeIf(AbstractTickableSoundInstance::isStopped);
        }
    }
}

