/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EntityTrackerClientHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ClientUtils {
    public static void emitParticles(Level world, BlockPos pos, ParticleOptions particle, double yOffset) {
        float xOff = world.random.nextFloat() * 0.6f + 0.2f;
        float zOff = world.random.nextFloat() * 0.6f + 0.2f;
        ClientUtils.getClientLevel().addParticle(particle, (double)((float)pos.getX() + xOff), (double)pos.getY() + yOffset, (double)((float)pos.getZ() + zOff), 0.0, 0.0, 0.0);
    }

    public static void emitParticles(Level world, BlockPos pos, ParticleOptions particle) {
        ClientUtils.emitParticles(world, pos, particle, 1.2);
    }

    @Nonnull
    public static ItemStack getWornArmor(EquipmentSlot slot) {
        return ClientUtils.getClientPlayer().getItemBySlot(slot);
    }

    public static void addDroneToHudHandler(DroneEntity drone, BlockPos pos) {
        ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.entityTrackerHandler, EntityTrackerClientHandler.class).getTargetsStream().filter(target -> target.entity == drone).forEach(target -> target.getDroneAIRenderer(drone).addBlackListEntry(drone.level(), pos));
    }

    public static boolean isKeyDown(int keyCode) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyCode);
    }

    public static void openContainerGui(MenuType<? extends AbstractContainerMenu> type, Component displayString) {
        MenuScreens.create(type, (Minecraft)Minecraft.getInstance(), (int)-1, (Component)displayString);
    }

    public static void closeContainerGui(Screen parentScreen) {
        Minecraft.getInstance().setScreen(parentScreen);
        if (parentScreen instanceof AbstractContainerScreen) {
            ClientUtils.getClientPlayer().containerMenu = ((AbstractContainerScreen)parentScreen).getMenu();
        } else if (parentScreen instanceof AbstractProgWidgetScreen) {
            ClientUtils.getClientPlayer().containerMenu = ((AbstractProgWidgetScreen)parentScreen).getProgrammerContainer();
        }
    }

    @Nonnull
    public static Level getClientLevel() {
        return (Level)Objects.requireNonNull(Minecraft.getInstance().level);
    }

    public static Optional<Level> getOptionalClientLevel() {
        return Optional.ofNullable(Minecraft.getInstance().level);
    }

    @Nonnull
    public static Player getClientPlayer() {
        return (Player)Objects.requireNonNull(Minecraft.getInstance().player);
    }

    public static Optional<Player> getOptionalClientPlayer() {
        return Optional.ofNullable(Minecraft.getInstance().player);
    }

    public static boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    public static BlockEntity getBlockEntity(BlockPos pos) {
        return ClientUtils.getClientLevel().getBlockEntity(pos);
    }

    public static boolean intersects(Rect2i rect, double x, double y, double w, double h) {
        if (rect.getWidth() <= 0 || rect.getHeight() <= 0 || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = rect.getX();
        double y0 = rect.getY();
        return x + w > x0 && y + h > y0 && x < x0 + (double)rect.getWidth() && y < y0 + (double)rect.getHeight();
    }

    public static boolean isScreenHiRes() {
        Window mw = Minecraft.getInstance().getWindow();
        return mw.getGuiScaledWidth() > 700 && mw.getGuiScaledHeight() > 512;
    }

    public static int getLightAt(BlockPos pos) {
        return LevelRenderer.getLightColor((BlockAndTintGetter)ClientUtils.getClientLevel(), (BlockPos)pos);
    }

    public static int getStringWidth(String line) {
        return Minecraft.getInstance().font.width(line);
    }

    public static boolean isGuiOpen(BlockEntity te) {
        if (Minecraft.getInstance().screen instanceof AbstractPneumaticCraftContainerScreen) {
            return ((AbstractPneumaticCraftContainerScreen)Minecraft.getInstance().screen).te == te;
        }
        return false;
    }

    public static float[] getTextureUV(BlockState state, Direction face) {
        if (state == null) {
            return null;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        List quads = model.getQuads(state, face, ClientUtils.getClientLevel().random, ModelData.EMPTY, null);
        if (!quads.isEmpty()) {
            TextureAtlasSprite sprite = ((BakedQuad)quads.get(0)).getSprite();
            return new float[]{sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1()};
        }
        return null;
    }

    public static void spawnEntityClientside(Entity e) {
        ((ClientLevel)ClientUtils.getClientLevel()).addEntity(e);
    }

    public static String translateDirection(Direction d) {
        return I18n.get((String)("pneumaticcraft.gui.tooltip.direction." + d.toString()), (Object[])new Object[0]);
    }

    public static Component translateDirectionComponent(Direction d) {
        return Component.translatable((String)("pneumaticcraft.gui.tooltip.direction." + d.toString()));
    }

    public static Component translateKeyBind(KeyMapping keyBinding) {
        return keyBinding.getKeyModifier().getCombinedName(keyBinding.getKey(), () -> keyBinding.getKey().getDisplayName()).copy().withStyle(ChatFormatting.YELLOW);
    }

    public static void addGuiContextSensitiveTooltip(ItemStack stack, List<Component> tooltip) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null) {
            ResourceLocation regName;
            String subKey = screen.getClass().getSimpleName().toLowerCase(Locale.ROOT);
            Item item = stack.getItem();
            String base = item instanceof BlockItem ? "gui.tooltip.block" : "gui.tooltip.item";
            String k = String.join((CharSequence)".", base, (regName = PneumaticCraftUtils.getRegistryName(item).orElseThrow()).getNamespace(), regName.getPath(), subKey);
            if (I18n.exists((String)k)) {
                tooltip.addAll(GuiUtils.xlateAndSplit(k, new Object[0]).stream().map(s -> s.copy().withStyle(ChatFormatting.GRAY)).toList());
            }
        }
    }

    public static int getRenderDistanceThresholdSq() {
        int d = (Integer)Minecraft.getInstance().options.renderDistance().get() * 16;
        return d * d;
    }

    public static boolean isFirstPersonCamera() {
        return Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    public static float calculateViewScaling(Vec3 targetPos) {
        Player player = ClientUtils.getClientPlayer();
        Vec3 vec1 = targetPos.subtract(player.position());
        double angle = player.getLookAngle().dot(vec1.normalize());
        float size = 1.0f;
        if (angle >= 0.8) {
            double dist = Math.max(1.0E-4, Math.sqrt(player.distanceToSqr(targetPos)));
            double s = 0.8 - 1.0 / dist;
            size *= (float)((angle - s) * dist);
        }
        return size;
    }

    public static float getStatSizeMultiplier(double dist) {
        if (dist < 4.0) {
            return Math.max(0.3f, (float)(dist / 4.0));
        }
        if (dist < 10.0) {
            return 1.0f;
        }
        return (float)(dist / 10.0);
    }

    public static void syncViaOpenContainerScreen(int syncId, Object value) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu container = screen2.getMenu();
            if (container instanceof AbstractPneumaticCraftMenu) {
                AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)container;
                pncMenu.updateField(syncId, value);
            }
            if (screen2 instanceof AbstractPneumaticCraftContainerScreen) {
                AbstractPneumaticCraftContainerScreen pncScreen = (AbstractPneumaticCraftContainerScreen)screen2;
                pncScreen.onGuiUpdate();
            }
        }
    }

    public static Pair<Integer, List<Component>> formatFuelList(Component header, int suggestedWidth, ToIntFunction<Fluid> fluidFunc, boolean includeBurnRate) {
        Font font = Minecraft.getInstance().font;
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        text.add(header.copy().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA}));
        int maxWidth = font.width((FormattedText)header);
        FuelRegistry fuelRegistry = FuelRegistry.getInstance();
        fuelRegistry.clearCachedFuelFluids();
        Level world = ClientUtils.getClientLevel();
        ArrayList<Fluid> fluids = new ArrayList<Fluid>(fuelRegistry.registeredFuels(world));
        Object2IntOpenHashMap valueMap = new Object2IntOpenHashMap();
        fluids.forEach(arg_0 -> ClientUtils.lambda$formatFuelList$4((Object2IntMap)valueMap, fluidFunc, arg_0));
        fluids.sort((arg_0, arg_1) -> ClientUtils.lambda$formatFuelList$5((Object2IntMap)valueMap, arg_0, arg_1));
        Map<String, Integer> counted = fluids.stream().collect(Collectors.toMap(fluid -> new FluidStack(fluid, 1).getDisplayName().getString(), fluid -> 1, Integer::sum));
        int dotWidth = font.width(".");
        MutableComponent prevLine = Component.empty();
        for (Fluid fluid2 : fluids) {
            MutableComponent line;
            int val = valueMap.getInt((Object)fluid2);
            if (val <= 0) continue;
            Object valStr = String.format("%4d", valueMap.getInt((Object)fluid2));
            int nSpc = (32 - font.width((String)valStr)) / dotWidth;
            valStr = (String)valStr + StringUtils.repeat((char)'.', (int)nSpc);
            String fluidName = new FluidStack(fluid2, 1).getDisplayName().getString();
            float mul = fuelRegistry.getBurnRateMultiplier(world, fluid2);
            MutableComponent mutableComponent = line = mul == 1.0f || !includeBurnRate ? Component.literal((String)((String)valStr + "| " + StringUtils.abbreviate((String)fluidName, (int)25))) : Component.literal((String)((String)valStr + "| " + StringUtils.abbreviate((String)fluidName, (int)20) + " (x" + PneumaticCraftUtils.roundNumberTo(mul, 2) + ")"));
            if (!line.equals(prevLine)) {
                maxWidth = Math.max(maxWidth, font.width((FormattedText)line));
                text.add(line);
            }
            prevLine = line;
            if (counted.getOrDefault(fluidName, 0) <= 1) continue;
            MutableComponent line2 = Component.literal((String)("  \u25b2 " + ModNameCache.getModName(fluid2))).withStyle(ChatFormatting.GOLD);
            text.add(line2);
            maxWidth = Math.max(maxWidth, font.width((FormattedText)line2));
        }
        return Pair.of((Object)Math.min(maxWidth, suggestedWidth), text);
    }

    public static void setArmorUpgradeEnabled(EquipmentSlot slot, byte idx, boolean state) {
        WidgetKeybindCheckBox cb;
        List<IArmorUpgradeHandler<?>> l = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
        if (idx >= 0 && idx < l.size() && CommonArmorHandler.getHandlerForPlayer().isUpgradeInserted(slot, idx) && (cb = WidgetKeybindCheckBox.forUpgrade(l.get(idx))) != null && cb.checked != state) {
            cb.handleClick();
        }
    }

    private static /* synthetic */ int lambda$formatFuelList$5(Object2IntMap valueMap, Fluid f1, Fluid f2) {
        return Integer.compare(valueMap.getInt((Object)f2), valueMap.getInt((Object)f1));
    }

    private static /* synthetic */ void lambda$formatFuelList$4(Object2IntMap valueMap, ToIntFunction fluidFunc, Fluid f) {
        valueMap.put((Object)f, fluidFunc.applyAsInt(f));
    }
}

