/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;

public class GuiUtils {
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    public static final String TRANSLATION_LINE_BREAK = "\\n";

    public static void renderBlockInGui(GuiGraphics graphics, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(-scale, -scale, -scale);
        poseStack.mulPose(Axis.XP.rotationDegrees(-30.0f));
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        poseStack.translate(0.5f, 0.0f, -0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotate));
        poseStack.translate(-0.5f, 0.0f, 0.5f);
        poseStack.translate(0.0f, 0.0f, -1.0f);
        mc.getBlockRenderer().renderSingleBlock(block, poseStack, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        poseStack.popPose();
    }

    public static void drawFluid(GuiGraphics graphics, Rect2i bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == Fluids.EMPTY) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProps = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProps.getStillTexture(fluidStack);
        if (fluidStill == null) {
            fluidStill = MissingTextureAtlasSprite.getLocation();
        }
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(fluidStill);
        int n = scaledAmount = tank == null ? bounds.getHeight() : fluidStack.getAmount() * bounds.getHeight() / tank.getCapacity();
        if (fluidStack.getAmount() > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.getHeight());
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int xTileCount = bounds.getWidth() / 16;
        int xRemainder = bounds.getWidth() - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.getY() + bounds.getHeight();
        if (fluid.getFluidType().getDensity() < 0) {
            yStart -= bounds.getHeight() - scaledAmount;
        }
        int[] cols = RenderUtils.decomposeColor(renderProps.getTintColor(fluidStack));
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.getX() + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.getWidth() <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(graphics, x, y, fluidStillSprite, maskTop, maskRight, 100.0f, cols);
            }
        }
        RenderSystem.disableBlend();
    }

    private static void drawFluidTexture(GuiGraphics graphics, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int[] cols) {
        float uMin = textureSprite.getU0();
        float uMax = textureSprite.getU1();
        float vMin = textureSprite.getV0();
        float vMax = textureSprite.getV1();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Matrix4f posMat = graphics.pose().last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder worldrenderer = tessellator.getBuilder();
        worldrenderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        worldrenderer.vertex(posMat, xCoord, yCoord + 16.0f, zLevel).color(cols[1], cols[2], cols[3], cols[0]).uv(uMin, vMax).endVertex();
        worldrenderer.vertex(posMat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).color(cols[1], cols[2], cols[3], cols[0]).uv(uMax, vMax).endVertex();
        worldrenderer.vertex(posMat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).color(cols[1], cols[2], cols[3], cols[0]).uv(uMax, vMin).endVertex();
        worldrenderer.vertex(posMat, xCoord, yCoord + (float)maskTop, zLevel).color(cols[1], cols[2], cols[3], cols[0]).uv(uMin, vMin).endVertex();
        tessellator.end();
    }

    public static Rect2i showPopupHelpScreen(GuiGraphics graphics, Screen screen, Font fontRenderer, List<Component> helpText) {
        int y;
        int x;
        List<FormattedCharSequence> l = GuiUtils.wrapTextComponentList(helpText, screen.width / 2, fontRenderer);
        Objects.requireNonNull(fontRenderer);
        int lineSpacing = 9 + 1;
        int boxHeight = l.size() * lineSpacing;
        int maxLines = boxHeight / lineSpacing;
        int boxWidth = l.stream().max(Comparator.comparingInt(arg_0 -> ((Font)fontRenderer).width(arg_0))).map(arg_0 -> ((Font)fontRenderer).width(arg_0)).orElse(0);
        float fontScale = 1.0f;
        while (boxHeight > screen.height - 5) {
            boxHeight /= 2;
            boxWidth /= 2;
            fontScale /= 2.0f;
        }
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen a = (AbstractContainerScreen)screen;
            x = (a.getXSize() - boxWidth) / 2;
            y = (a.getYSize() - boxHeight) / 2;
        } else {
            x = (screen.width - boxWidth) / 2;
            y = (screen.height - boxHeight) / 2;
        }
        Rect2i bounds = new Rect2i(x, y, boxWidth, boxHeight);
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 400.0f);
        GuiUtils.drawPanel(graphics, 0, 0, boxHeight, boxWidth);
        int dy = 0;
        graphics.pose().scale(fontScale, fontScale, fontScale);
        for (FormattedCharSequence line : l) {
            graphics.drawString(fontRenderer, line, 0, dy, -2039584, false);
            dy += lineSpacing;
            if (maxLines-- != 0) continue;
            break;
        }
        graphics.pose().popPose();
        return bounds;
    }

    public static void drawPanel(GuiGraphics graphics, int x, int y, int panelHeight, int panelWidth) {
        graphics.fill(x - 4, y - 4, x + panelWidth + 8, y + panelHeight + 8, -1073741824);
        graphics.fill(x - 4, y - 4, x + panelWidth + 8, y - 3, -8355712);
        graphics.fill(x - 4, y + panelHeight + 8, x + panelWidth + 8, y + panelHeight + 9, -8355712);
        graphics.fill(x - 4, y - 4, x - 3, y + panelHeight + 8, -8355712);
        graphics.fill(x + panelWidth + 8, y - 4, x + panelWidth + 9, y + panelHeight + 8, -8355712);
    }

    public static void drawScaledText(GuiGraphics graphics, Font fr, Component text, int x, int y, int color, float scale, boolean dropShadow) {
        if (scale != 1.0f) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)x, (float)y, 0.0f);
            poseStack.scale(scale, scale, scale);
            graphics.drawString(fr, text, 0, 0, color, dropShadow);
            poseStack.popPose();
        } else {
            graphics.drawString(fr, text, x, y, color, dropShadow);
        }
    }

    public static List<FormattedCharSequence> wrapTextComponentList(List<Component> text, int maxWidth, Font font) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Component line : text) {
            builder.addAll((Iterable)ComponentRenderUtils.wrapComponents((FormattedText)line, (int)maxWidth, (Font)font));
        }
        return builder.build();
    }

    public static List<Component> xlateAndSplit(String key, Object ... params) {
        return Arrays.stream(StringUtils.splitByWholeSeparator((String)I18n.get((String)key, (Object[])params), (String)TRANSLATION_LINE_BREAK)).map(Component::literal).collect(Collectors.toList());
    }

    public static void renderProgressingLine2d(GuiGraphics graphics, ProgressingLine line, int color, float lineWidth) {
        int[] cols = RenderUtils.decomposeColor(color);
        float progress = line.getProgress();
        Matrix4f posMat = graphics.pose().last().pose();
        BufferBuilder wr = Tesselator.getInstance().getBuilder();
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        wr.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        wr.vertex(posMat, line.startX, line.startY, line.startZ).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        wr.vertex(posMat, Mth.lerp((float)progress, (float)line.startX, (float)line.endX), Mth.lerp((float)progress, (float)line.startY, (float)line.endY), Mth.lerp((float)progress, (float)line.startZ, (float)line.endZ)).color(cols[1], cols[2], cols[3], cols[0]).endVertex();
        Tesselator.getInstance().end();
    }
}

