/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.BitSet;
import java.util.function.BiConsumer;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final int FULL_BRIGHT = 0xF000F0;
    private static final float FULL_CIRCLE = (float)Math.PI * 2;
    private static final float STEP = 0.25132743f;

    public static int[] decomposeColor(int color) {
        int[] res = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public static float[] decomposeColorF(int color) {
        float[] res = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return res;
    }

    private static boolean drawSide(BitSet mask, Direction d1, Direction d2) {
        return mask.get(d1.get3DDataValue()) || mask.get(d2.get3DDataValue());
    }

    public static RenderType renderFrame(PoseStack matrixStack, MultiBufferSource buffer, AABB aabb, float fw, float r, float g, float b, float a, int packedLightIn, Direction ... sides) {
        RenderType type = ModRenderTypes.BLOCK_FRAME;
        VertexConsumer builder = buffer.getBuffer(type);
        Matrix4f posMat = matrixStack.last().pose();
        BitSet mask = new BitSet(6);
        if (sides.length == 0) {
            mask.set(0, 6);
        } else {
            for (Direction d : sides) {
                mask.set(d.get3DDataValue());
            }
        }
        float x1 = (float)aabb.minX;
        float y1 = (float)aabb.minY;
        float z1 = (float)aabb.minZ;
        float x2 = (float)aabb.maxX;
        float y2 = (float)aabb.maxY;
        float z2 = (float)aabb.maxZ;
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z1 - fw, x2 - fw, y1 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z1 - fw, x2 - fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y1 - fw, z2 - fw, x2 - fw, y1 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 + fw, y2 - fw, z2 - fw, x2 - fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 + fw, x1 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.WEST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y2 - fw, z1 + fw, x1 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.DOWN, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 + fw, x2 + fw, y1 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.UP, Direction.EAST)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y2 - fw, z1 + fw, x2 + fw, y2 + fw, z2 - fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z1 - fw, x1 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.NORTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z1 - fw, x2 + fw, y2 + fw, z1 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.WEST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x1 - fw, y1 - fw, z2 - fw, x1 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        if (RenderUtils.drawSide(mask, Direction.EAST, Direction.SOUTH)) {
            RenderUtils.renderOffsetAABB(posMat, builder, x2 - fw, y1 - fw, z2 - fw, x2 + fw, y2 + fw, z2 + fw, r, g, b, a, packedLightIn);
        }
        return type;
    }

    private static void renderOffsetAABB(Matrix4f posMat, VertexConsumer builder, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a, int packedLightIn) {
        builder.vertex(posMat, x1, y2, z1).color(r, g, b, a).normal(0.0f, 0.0f, -1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z1).color(r, g, b, a).normal(0.0f, 0.0f, -1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z1).color(r, g, b, a).normal(0.0f, 0.0f, -1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z1).color(r, g, b, a).normal(0.0f, 0.0f, -1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z2).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z2).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z2).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y2, z2).color(r, g, b, a).normal(0.0f, 0.0f, 1.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z1).color(r, g, b, a).normal(0.0f, -1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z1).color(r, g, b, a).normal(0.0f, -1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z2).color(r, g, b, a).normal(0.0f, -1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z2).color(r, g, b, a).normal(0.0f, -1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y2, z2).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z2).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z1).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y2, z1).color(r, g, b, a).normal(0.0f, 1.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z2).color(r, g, b, a).normal(-1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y2, z2).color(r, g, b, a).normal(-1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y2, z1).color(r, g, b, a).normal(-1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x1, y1, z1).color(r, g, b, a).normal(-1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z1).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z1).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y2, z2).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, x2, y1, z2).color(r, g, b, a).normal(1.0f, 0.0f, 0.0f).uv2(packedLightIn).endVertex();
    }

    public static float rotateMatrixForDirection(PoseStack matrixStack, Direction facing) {
        float yRotation;
        switch (facing) {
            case UP: {
                yRotation = 0.0f;
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStack.translate(0.0f, -1.0f, -1.0f);
                break;
            }
            case DOWN: {
                yRotation = 0.0f;
                matrixStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                matrixStack.translate(0.0f, -1.0f, 1.0f);
                break;
            }
            case NORTH: {
                yRotation = 0.0f;
                break;
            }
            case EAST: {
                yRotation = 90.0f;
                break;
            }
            case SOUTH: {
                yRotation = 180.0f;
                break;
            }
            default: {
                yRotation = 270.0f;
            }
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees(yRotation));
        return yRotation;
    }

    public static void renderProgressingLine3d(ProgressingLine prev, ProgressingLine line, float partialTick, PoseStack matrixStack, VertexConsumer builder, int color) {
        float[] cols = RenderUtils.decomposeColorF(color);
        Matrix4f posMat = matrixStack.last().pose();
        float progress = line.getProgress();
        float lx1 = Mth.lerp((float)partialTick, (float)line.startX, (float)prev.startX);
        float ly1 = Mth.lerp((float)partialTick, (float)line.startY, (float)prev.startY);
        float lz1 = Mth.lerp((float)partialTick, (float)line.startZ, (float)prev.startZ);
        float lx2 = Mth.lerp((float)progress, (float)lx1, (float)Mth.lerp((float)partialTick, (float)line.endX, (float)prev.endX));
        float ly2 = Mth.lerp((float)progress, (float)ly1, (float)Mth.lerp((float)partialTick, (float)line.endY, (float)prev.endY));
        float lz2 = Mth.lerp((float)progress, (float)lz1, (float)Mth.lerp((float)partialTick, (float)line.endZ, (float)prev.endZ));
        RenderUtils.normalLine(builder, posMat, matrixStack.last().normal(), lx1, ly1, lz1, lx2, ly2, lz2, cols[0], cols[1], cols[2], cols[3], false);
    }

    public static void renderRing(ProgressingLine line, ProgressingLine lastLine, PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTick, float rotationYaw, float rotationPitch, int color) {
        matrixStackIn.pushPose();
        double renderProgress = Mth.lerp((float)partialTick, (float)lastLine.progress, (float)line.progress);
        matrixStackIn.translate((double)(line.endX - line.startX) * renderProgress, (double)(line.endY - line.startY) * renderProgress, (double)(line.endZ - line.startZ) * renderProgress);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(rotationYaw - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(rotationPitch));
        VertexConsumer builder = bufferIn.getBuffer(ModRenderTypes.getLineLoops(1.0));
        int[] cols = RenderUtils.decomposeColor(0xFF000000 | color);
        double size = (1.0 + 4.0 * renderProgress) / 16.0;
        Matrix4f posMat = matrixStackIn.last().pose();
        for (float i = 0.0f; i < (float)Math.PI * 2; i += 0.25132743f) {
            Vec3 v1 = new Vec3(0.0, (double)Mth.sin((float)i) * size, (double)Mth.cos((float)i) * size);
            Vec3 v2 = new Vec3(0.0, (double)Mth.sin((float)(i + 0.25132743f)) * size, (double)Mth.cos((float)(i + 0.25132743f)) * size);
            RenderUtils.posF(builder, posMat, 0.0, v1.y(), v1.z()).color(cols[1], cols[2], cols[3], cols[0]).normal(matrixStackIn.last().normal(), 0.0f, (float)(v2.y() - v1.y()), (float)(v2.z() - v1.z())).endVertex();
        }
        matrixStackIn.popPose();
    }

    public static void rotateToPlayerFacing(PoseStack matrixStack) {
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - Minecraft.getInstance().gameRenderer.getMainCamera().getYRot()));
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f - Minecraft.getInstance().gameRenderer.getMainCamera().getXRot()));
    }

    public static void drawTexture(PoseStack matrixStack, VertexConsumer builder, int x, int y, int packedLightIn) {
        RenderUtils.drawTexture(matrixStack, builder, x, y, 0.0f, 0.0f, 1.0f, 1.0f, packedLightIn);
    }

    public static void drawTexture(PoseStack matrixStack, VertexConsumer builder, int x, int y, float u1, float v1, float u2, float v2, int packedLightIn) {
        Matrix4f posMat = matrixStack.last().pose();
        builder.vertex(posMat, (float)x, (float)(y + 16), 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(u1, v2).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, (float)(x + 16), (float)(y + 16), 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(u2, v2).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, (float)(x + 16), (float)y, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(u2, v1).uv2(packedLightIn).endVertex();
        builder.vertex(posMat, (float)x, (float)y, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).uv(u1, v1).uv2(packedLightIn).endVertex();
    }

    public static VertexConsumer posF(VertexConsumer builder, Matrix4f posMat, double x, double y, double z) {
        return builder.vertex(posMat, (float)x, (float)y, (float)z);
    }

    public static void finishBuffer(MultiBufferSource buffer, RenderType type) {
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource mbs = (MultiBufferSource.BufferSource)buffer;
            RenderSystem.disableDepthTest();
            mbs.endBatch(type);
        }
    }

    public static void renderWithTypeAndFinish(PoseStack matrixStack, MultiBufferSource buffer, RenderType type, BiConsumer<Matrix4f, VertexConsumer> consumer) {
        consumer.accept(matrixStack.last().pose(), buffer.getBuffer(type));
        RenderUtils.finishBuffer(buffer, type);
    }

    public static void renderWithType(PoseStack matrixStack, MultiBufferSource buffer, RenderType type, BiConsumer<Matrix4f, VertexConsumer> consumer) {
        consumer.accept(matrixStack.last().pose(), buffer.getBuffer(type));
    }

    public static void renderString3d(Component str, float x, float y, int color, PoseStack matrixStack, MultiBufferSource buffer, boolean dropShadow, boolean disableDepthTest) {
        Font fr = Minecraft.getInstance().font;
        fr.drawInBatch(str, x, y, color, dropShadow, matrixStack.last().pose(), buffer, disableDepthTest ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderString3d(FormattedCharSequence str, float x, float y, int color, PoseStack matrixStack, MultiBufferSource buffer, boolean dropShadow, boolean disableDepthTest) {
        Font fr = Minecraft.getInstance().font;
        fr.drawInBatch(str, x, y, color, dropShadow, matrixStack.last().pose(), buffer, disableDepthTest ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void normalLine(VertexConsumer builder, Matrix4f posMat, Matrix3f normal, float x1, float y1, float z1, float x2, float y2, float z2, float a, float r, float g, float b, boolean isStrip) {
        float nx = x2 - x1;
        float ny = y2 - y1;
        float nz = z2 - z1;
        float d = Mth.sqrt((float)(nx * nx + ny * ny + nz * nz));
        builder.vertex(posMat, x1, y1, z1).color(r, g, b, a).normal(normal, nx / d, ny / d, nz / d).endVertex();
        if (!isStrip) {
            builder.vertex(posMat, x2, y2, z2).color(r, g, b, a).normal(normal, nx / d, ny / d, nz / d).endVertex();
        }
    }
}

