/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import java.util.ArrayList;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.api.drone.AmadronRetrievalEvent;
import me.desht.pneumaticcraft.api.drone.DroneSuicideEvent;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class AmadronEventListener {
    private static long reshuffleCounter = 0L;

    @SubscribeEvent
    public void onDroneSuicide(DroneSuicideEvent event) {
        IDrone iDrone = event.drone;
        if (iDrone instanceof AmadroneEntity) {
            AmadroneEntity amadrone = (AmadroneEntity)iDrone;
            AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(amadrone.getHandlingOffer());
            if (offer != null) {
                offer.getInput().accept(itemStack -> {
                    int i;
                    int requiredCount = offer.getInput().getAmount() * amadrone.getOfferTimes();
                    for (i = 0; i < amadrone.getInv().getSlots(); ++i) {
                        requiredCount -= amadrone.getInv().getStackInSlot(i).getCount();
                    }
                    if (requiredCount <= 0) {
                        for (i = 0; i < amadrone.getInv().getSlots(); ++i) {
                            amadrone.getInv().setStackInSlot(i, ItemStack.EMPTY);
                        }
                        NeoForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(amadrone, offer);
                    }
                }, fluidStack -> {
                    int requiredCount = offer.getInput().getAmount() * amadrone.getOfferTimes();
                    if (amadrone.getFluidTank().getFluidAmount() >= requiredCount) {
                        NeoForge.EVENT_BUS.post((Event)new AmadronRetrievalEvent(event.drone));
                    } else {
                        this.onAmadronFailure(amadrone, offer);
                    }
                });
            }
        }
    }

    private void onAmadronFailure(AmadroneEntity drone, AmadronOffer offer) {
        if (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0) {
            offer.setStock(offer.getStock() + drone.getOfferTimes());
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.getOfferId(), offer.getStock()));
        }
    }

    @SubscribeEvent
    public void onAmadronSuccess(AmadronRetrievalEvent event) {
        AmadroneEntity drone = (AmadroneEntity)event.drone;
        AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(drone.getHandlingOffer());
        AmadronPlayerOffer playerOffer = this.getPlayerOffer(offer);
        if (playerOffer == null) {
            this.doDelivery(drone, offer);
        } else {
            if (drone.getAmadronAction() == AmadroneEntity.AmadronAction.TAKING_PAYMENT) {
                if (offer instanceof AmadronPlayerOffer) {
                    ((AmadronPlayerOffer)offer).addPayment(drone.getOfferTimes());
                }
                playerOffer.onTrade(drone.getOfferTimes(), drone.getBuyingPlayer());
                this.doDelivery(drone, offer);
            } else if (drone.getAmadronAction() == AmadroneEntity.AmadronAction.RESTOCKING) {
                playerOffer.setStock(playerOffer.getStock() + drone.getOfferTimes());
                NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(playerOffer.getOfferId(), playerOffer.getStock()));
                playerOffer.notifyRestock();
            }
            AmadronPlayerOffers.save();
        }
    }

    private void doDelivery(AmadroneEntity drone, AmadronRecipe offer) {
        ItemStack usedTablet = drone.getUsedTablet();
        offer.getOutput().accept(itemStack -> {
            GlobalPos itemPos = AmadronTabletItem.getItemProvidingLocation(usedTablet);
            if (itemPos != null) {
                ItemStack stack;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int toDeliver = itemStack.getCount() * drone.getOfferTimes(); toDeliver > 0; toDeliver -= stack.getCount()) {
                    stack = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)Math.min(toDeliver, itemStack.getMaxStackSize()));
                    stacks.add(stack);
                }
                DroneRegistry.getInstance().deliverItemsAmazonStyle(itemPos, stacks.toArray(new ItemStack[0]));
            }
        }, fluidStack -> {
            GlobalPos fluidPos = AmadronTabletItem.getFluidProvidingLocation(usedTablet);
            if (fluidPos != null) {
                FluidStack offeringFluid = fluidStack.copy();
                offeringFluid.setAmount(offeringFluid.getAmount() * drone.getOfferTimes());
                DroneRegistry.getInstance().deliverFluidAmazonStyle(fluidPos, offeringFluid);
            }
        });
    }

    @SubscribeEvent
    public void amadronHousekeeping(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerLevel overWorld;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (reshuffleCounter++ >= (long)((Integer)ConfigHelper.common().amadron.reshuffleInterval.get()).intValue() && !this.anyPlayerUsingAmadron(server)) {
                AmadronOfferManager.getInstance().compileActiveOffersList();
                reshuffleCounter = 0L;
            }
            if (server.getTickCount() % 600 == 0) {
                AmadronOfferManager.getInstance().tryRestockPlayerOffers();
            }
            if ((overWorld = server.getLevel(Level.OVERWORLD)) != null) {
                AmadronOfferManager.getInstance().checkForFullRebuild((Level)overWorld);
            }
        }
    }

    private boolean anyPlayerUsingAmadron(MinecraftServer server) {
        return server.getPlayerList().getPlayers().stream().anyMatch(player -> player.containerMenu instanceof AmadronMenu);
    }

    private AmadronPlayerOffer getPlayerOffer(AmadronOffer offer) {
        AmadronOffer o = AmadronOfferManager.getInstance().getOffer(AmadronPlayerOffer.getReversedId(offer.getOfferId()));
        return o instanceof AmadronPlayerOffer ? (AmadronPlayerOffer)o : null;
    }
}

