/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public enum AmadronOfferManager {
    INSTANCE;

    private final List<AmadronOffer> staticOffers = new ArrayList<AmadronOffer>();
    private final Int2ObjectMap<List<AmadronOffer>> periodicOffers = new Int2ObjectOpenHashMap();
    private final Map<String, List<AmadronOffer>> villagerTrades = new HashMap<String, List<AmadronOffer>>();
    private final List<VillagerProfession> validProfessions = new ArrayList<VillagerProfession>();
    private final Map<ResourceLocation, AmadronOffer> allOffers = new HashMap<ResourceLocation, AmadronOffer>();
    private final Map<ResourceLocation, AmadronOffer> activeOffers = new LinkedHashMap<ResourceLocation, AmadronOffer>();
    private boolean rebuildRequired = true;

    public static AmadronOfferManager getInstance() {
        return INSTANCE;
    }

    public AmadronOffer getOffer(ResourceLocation offerId) {
        return this.allOffers.get(offerId);
    }

    public Collection<AmadronOffer> getActiveOffers() {
        return this.activeOffers.values();
    }

    public boolean addPlayerOffer(AmadronPlayerOffer offer) {
        if (this.hasSimilarPlayerOffer(offer)) {
            return false;
        }
        if (offer.getInput().isEmpty() || offer.getOutput().isEmpty()) {
            return false;
        }
        this.getPlayerOffers().put(offer.getOfferId(), offer);
        this.addOffer(this.activeOffers, offer);
        this.addOffer(this.allOffers, offer);
        this.addOffer(this.allOffers, offer.getReversedOffer());
        NetworkHandler.sendNonLocal(PacketSyncAmadronOffers.create(true));
        this.saveAll();
        return true;
    }

    public boolean removePlayerOffer(AmadronPlayerOffer offer) {
        if (this.getPlayerOffers().remove(offer.getOfferId()) != null) {
            this.activeOffers.remove(offer.getOfferId());
            this.allOffers.remove(offer.getOfferId());
            this.allOffers.remove(AmadronPlayerOffer.getReversedId(offer.getOfferId()));
            NetworkHandler.sendNonLocal(PacketSyncAmadronOffers.create(true));
            this.saveAll();
            return true;
        }
        return false;
    }

    public boolean hasSimilarPlayerOffer(AmadronPlayerOffer offer) {
        return this.getPlayerOffers().values().stream().anyMatch(existing -> existing.equivalentTo(offer));
    }

    private Map<ResourceLocation, AmadronPlayerOffer> getPlayerOffers() {
        return AmadronPlayerOffers.INSTANCE.getPlayerOffers();
    }

    public void syncOffers(Collection<AmadronOffer> newOffers, boolean notifyPlayer) {
        this.activeOffers.clear();
        newOffers.forEach(offer -> this.addOffer(this.activeOffers, offer));
        Log.debug("Received {} active Amadron offers from server", this.activeOffers.size());
        if (notifyPlayer && ((Boolean)ConfigHelper.client().general.notifyAmadronOfferUpdates.get()).booleanValue()) {
            this.maybeNotifyPlayerOfUpdates(ClientUtils.getClientPlayer());
        }
    }

    private void maybeNotifyPlayerOfUpdates(Player player) {
        CombinedInvWrapper inv = new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerMainInvWrapper(player.getInventory()), new PlayerOffhandInvWrapper(player.getInventory())});
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!(inv.getStackInSlot(i).getItem() instanceof AmadronTabletItem)) continue;
            player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.offersUpdated", new Object[0]), false);
            break;
        }
    }

    void maybeNotifyLocalPlayerOfUpdates() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && !server.isDedicatedServer()) {
            for (Player player : server.getPlayerList().getPlayers()) {
                if (!server.isSingleplayerOwner(player.getGameProfile())) continue;
                this.maybeNotifyPlayerOfUpdates(player);
                break;
            }
        }
    }

    public void updateStock(ResourceLocation id, int stock) {
        AmadronRecipe offer = this.activeOffers.get(id);
        if (offer != null) {
            offer.setStock(stock);
        } else {
            Log.warning("Received stock update for offer id {} ({}) but it's not in the active list!", new Object[0]);
        }
    }

    public int countPlayerOffers(UUID playerId) {
        return (int)this.activeOffers.values().stream().filter(offer -> {
            AmadronPlayerOffer po;
            return offer instanceof AmadronPlayerOffer && (po = (AmadronPlayerOffer)offer).getPlayerId().equals(playerId);
        }).count();
    }

    public void tryRestockPlayerOffers() {
        boolean needSave = false;
        for (AmadronPlayerOffer offer : this.getPlayerOffers().values()) {
            AmadroneEntity drone;
            AmadronPlayerOffer reversed = offer.getReversedOffer();
            BlockEntity provider = offer.getProvidingTileEntity();
            int possiblePickups = offer.getOutput().apply(itemStack -> IOHelper.getInventoryForBlock(provider).map(h -> offer.getOutput().countTradesInInventory((IItemHandler)h)).orElse(0), fluidStack -> IOHelper.getFluidHandlerForBlock(provider).map(h -> offer.getOutput().countTradesInTank((IFluidHandler)h)).orElse(0));
            if (possiblePickups > 0 && (drone = AmadronMenu.retrieveOrder(null, offer.getReversedOffer(), possiblePickups, offer.getProvidingPos(), offer.getProvidingPos())) != null) {
                drone.setHandlingOffer(reversed.getOfferId(), possiblePickups, ItemStack.EMPTY, "Restock", AmadroneEntity.AmadronAction.RESTOCKING);
            }
            if (!offer.payout()) continue;
            needSave = true;
        }
        if (needSave) {
            this.saveAll();
        }
    }

    public void saveAll() {
        AmadronPlayerOffers.save();
    }

    private <T extends AmadronOffer> void addOffer(Map<ResourceLocation, T> map, T offer) {
        map.put(offer.getOfferId(), offer);
    }

    public void compileActiveOffersList() {
        this.activeOffers.clear();
        this.allOffers.clear();
        this.staticOffers.forEach(offer -> {
            this.addOffer(this.activeOffers, offer);
            this.addOffer(this.allOffers, offer);
        });
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int s1 = this.allOffers.size();
        this.periodicOffers.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        int nPeriodics = this.allOffers.size() - s1;
        for (int i = 0; i < Math.min(nPeriodics, (Integer)ConfigHelper.common().amadron.numPeriodicOffers.get()); ++i) {
            AmadronOffer offer2 = this.pickRandomPeriodicTrade(rand);
            if (offer2 == null) continue;
            this.addOffer(this.activeOffers, offer2);
        }
        int s2 = this.allOffers.size();
        this.villagerTrades.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        int nVillager = this.allOffers.size() - s2;
        if (!this.validProfessions.isEmpty()) {
            for (int i = 0; i < Math.min(nVillager, (Integer)ConfigHelper.common().amadron.numVillagerOffers.get()); ++i) {
                this.pickRandomVillagerTrade(this.validProfessions.get(((Random)rand).nextInt(this.validProfessions.size())), rand).ifPresent(offer -> this.addOffer(this.activeOffers, offer));
            }
        }
        this.addPlayerOffers();
        for (AmadronRecipe amadronRecipe : this.activeOffers.values()) {
            if (amadronRecipe.getMaxStock() <= 0) continue;
            amadronRecipe.setStock(amadronRecipe.getMaxStock());
        }
        NetworkHandler.sendNonLocal(PacketSyncAmadronOffers.create(true));
        this.maybeNotifyLocalPlayerOfUpdates();
        Log.debug("{} active Amadron offers to sync to clients", this.activeOffers.size());
    }

    public void addPlayerOffers() {
        this.getPlayerOffers().forEach((id, playerOffer) -> {
            this.addOffer(this.activeOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer.getReversedOffer());
        });
    }

    private AmadronOffer pickRandomPeriodicTrade(Random rand) {
        int level = this.getWeightedTradeLevel(rand);
        do {
            List offers;
            if ((offers = (List)this.periodicOffers.get(level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return (AmadronOffer)offers.get(idx);
        } while (--level > 0);
        Log.debug("Amadron: no periodic offers of level {} or lower", level);
        return null;
    }

    private Optional<AmadronOffer> pickRandomVillagerTrade(VillagerProfession profession, Random rand) {
        int level = this.getWeightedTradeLevel(rand);
        do {
            String key;
            List<AmadronOffer> offers;
            if ((offers = this.villagerTrades.get(key = profession.toString() + "_" + level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return Optional.ofNullable(offers.get(idx));
        } while (--level > 0);
        return Optional.empty();
    }

    private int getWeightedTradeLevel(Random rand) {
        int n = rand.nextInt(100);
        if (n < 50) {
            return 1;
        }
        if (n < 75) {
            return 2;
        }
        if (n < 90) {
            return 3;
        }
        if (n < 97) {
            return 4;
        }
        return 5;
    }

    private void setupVillagerTrades() {
        if (this.villagerTrades.isEmpty()) {
            HashSet validSet = new HashSet();
            RandomSource rand = RandomSource.createNewThreadLocalInstance();
            VillagerTrades.TRADES.forEach((profession, tradeMap) -> tradeMap.forEach((level, trades) -> IntStream.range(0, ((VillagerTrades.ItemListing[])trades).length).forEach(i -> {
                MerchantOffer offer = this.getOfferForNullVillager(trades[i], rand);
                if (offer != null && !offer.getBaseCostA().isEmpty() && !offer.getResult().isEmpty()) {
                    ResourceLocation offerId = new ResourceLocation(profession + "_" + level + "_" + i);
                    String key = profession.toString() + "_" + level;
                    this.villagerTrades.computeIfAbsent(key, k -> new ArrayList()).add(AmadronOffer.villagerTrade(offerId, offer, level));
                    validSet.add(profession);
                }
            })));
            this.validProfessions.addAll(validSet);
        }
    }

    private MerchantOffer getOfferForNullVillager(VillagerTrades.ItemListing trade, RandomSource rand) {
        try {
            return trade.getOffer(null, rand);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public void rebuildRequired() {
        this.rebuildRequired = true;
    }

    public void checkForFullRebuild(Level level) {
        if (this.rebuildRequired) {
            Log.debug("Rebuilding Amadron offer list", new Object[0]);
            this.staticOffers.clear();
            this.periodicOffers.clear();
            ModRecipeTypes.AMADRON.get().allRecipeHolders(level).forEach(recipe -> {
                Recipe patt15949$temp = recipe.value();
                if (patt15949$temp instanceof AmadronOffer) {
                    AmadronOffer offer = (AmadronOffer)patt15949$temp;
                    if (offer.isStaticOffer()) {
                        this.staticOffers.add(offer);
                    } else {
                        ((List)this.periodicOffers.computeIfAbsent(offer.getTradeLevel(), l -> new ArrayList())).add(offer);
                    }
                }
            });
            this.setupVillagerTrades();
            this.compileActiveOffersList();
            this.rebuildRequired = false;
        }
    }

    public boolean isActive(ResourceLocation offerId) {
        return this.activeOffers.containsKey(offerId);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class EventListener {
        @SubscribeEvent
        public static void onRecipesAvailable(RecipesUpdatedEvent event) {
            NetworkHandler.sendToServer(PacketSyncAmadronOffers.createRequest());
        }
    }
}

