/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.amadron;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.api.crafting.recipe.AmadronRecipe;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class ShoppingBasket
implements Iterable<ResourceLocation> {
    private final Map<ResourceLocation, Integer> basket = new Object2IntLinkedOpenHashMap();

    public static ShoppingBasket fromNBT(CompoundTag subTag) {
        ShoppingBasket res = new ShoppingBasket();
        if (subTag != null) {
            for (String key : subTag.getAllKeys()) {
                int count = subTag.getInt(key);
                if (count <= 0) continue;
                res.setUnits(new ResourceLocation(key), count);
            }
        }
        return res;
    }

    public CompoundTag toNBT() {
        CompoundTag subTag = new CompoundTag();
        this.basket.forEach((? super K key, ? super V value) -> {
            if (value > 0) {
                subTag.putInt(key.toString(), value.intValue());
            }
        });
        return subTag;
    }

    public int getUnits(ResourceLocation offerId) {
        return this.basket.getOrDefault(offerId, 0);
    }

    public void setUnits(ResourceLocation offerId, int units) {
        this.basket.put(offerId, units);
    }

    public void addUnitsToOffer(ResourceLocation offerId, int toAdd) {
        this.basket.put(offerId, Math.max(0, this.getUnits(offerId) + toAdd));
        this.removeIfEmpty(offerId);
    }

    public void remove(ResourceLocation offerId) {
        this.basket.remove(offerId);
    }

    public void halve(ResourceLocation offerId) {
        this.basket.put(offerId, this.getUnits(offerId) / 2);
        this.removeIfEmpty(offerId);
    }

    private void removeIfEmpty(ResourceLocation offerId) {
        if (this.getUnits(offerId) == 0) {
            this.basket.remove(offerId);
        }
    }

    public void clear() {
        this.basket.clear();
    }

    @Override
    public Iterator<ResourceLocation> iterator() {
        return this.basket.keySet().iterator();
    }

    public AmadronMenu.EnumProblemState validate(ItemStack tablet, boolean allOffers) {
        if (this.basket.isEmpty()) {
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }
        Optional<IItemHandler> itemCap = AmadronTabletItem.getItemCapability(tablet);
        Optional<IFluidHandler> fluidCap = AmadronTabletItem.getFluidCapability(tablet);
        if (this.basket.keySet().removeIf(offerId -> {
            AmadronOffer offer = AmadronOfferManager.getInstance().getOffer((ResourceLocation)offerId);
            boolean inputOk = ((AmadronRecipe)offer).getInput().apply(itemStack -> itemCap.isPresent(), fluidStack -> fluidCap.isPresent());
            boolean outputOk = ((AmadronRecipe)offer).getOutput().apply(itemStack -> itemCap.isPresent(), fluidStack -> fluidCap.isPresent());
            return !inputOk || !outputOk;
        })) {
            return AmadronMenu.EnumProblemState.NO_INVENTORY;
        }
        CountedItemStacks itemAmounts = itemCap.map(CountedItemStacks::new).orElse(new CountedItemStacks());
        Map fluidAmounts = fluidCap.map(handler -> ShoppingBasket.countFluids(handler)).orElse(Map.of());
        AmadronMenu.EnumProblemState problem = AmadronMenu.EnumProblemState.NO_PROBLEMS;
        for (ResourceLocation offerId2 : this.basket.keySet()) {
            int units;
            AmadronOffer offer = AmadronOfferManager.getInstance().getOffer(offerId2);
            int units0 = this.getUnits(offerId2);
            if (((AmadronRecipe)offer).getMaxStock() >= 0 && units0 > ((AmadronRecipe)offer).getStock()) {
                units = ((AmadronRecipe)offer).getStock();
                this.setUnits(offerId2, units);
                problem = ((AmadronRecipe)offer).getStock() == 0 ? AmadronMenu.EnumProblemState.OUT_OF_STOCK : AmadronMenu.EnumProblemState.NOT_ENOUGH_STOCK;
            } else {
                units = units0;
            }
            problem = problem.addProblem(((AmadronRecipe)offer).getInput().apply(itemStack -> {
                int available = itemAmounts.getOrDefault(itemStack, 0);
                int needed = itemStack.getCount() * units;
                if (allOffers) {
                    itemAmounts.put(itemStack, available - needed);
                }
                if (available < needed) {
                    this.setUnits(offerId2, available / itemStack.getCount());
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_ITEMS;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }, fluidStack -> {
                int available = fluidAmounts.getOrDefault(fluidStack.getFluid(), 0);
                int needed = fluidStack.getAmount() * units;
                if (allOffers) {
                    fluidAmounts.put(fluidStack.getFluid(), available / fluidStack.getAmount());
                }
                if (available < needed) {
                    this.setUnits(offerId2, available / fluidStack.getAmount());
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_FLUID;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }));
            problem = this.verifyDroneSpace(problem, offerId2, ((AmadronRecipe)offer).getInput());
            if (problem == AmadronMenu.EnumProblemState.NO_PROBLEMS) {
                problem = this.verifyDroneSpace(problem, offerId2, ((AmadronRecipe)offer).getOutput());
            }
            problem = problem.addProblem(((AmadronRecipe)offer).getOutput().apply(itemStack -> {
                int availableSpace = itemCap.map(h -> offer.getOutput().findSpaceInItemOutput((IItemHandler)h, units)).orElse(0);
                if (availableSpace < units) {
                    this.setUnits(offerId2, availableSpace);
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_ITEM_SPACE;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }, fluidStack -> {
                int space = fluidCap.map(h -> offer.getOutput().findSpaceInFluidOutput((IFluidHandler)h, units)).orElse(0);
                int availableTrades = Math.min(576000 / fluidStack.getAmount(), space);
                if (availableTrades < units) {
                    this.setUnits(offerId2, availableTrades);
                    return AmadronMenu.EnumProblemState.NOT_ENOUGH_FLUID_SPACE;
                }
                return AmadronMenu.EnumProblemState.NO_PROBLEMS;
            }));
        }
        this.basket.keySet().removeIf(offerId -> this.basket.get(offerId) == 0);
        return problem;
    }

    private AmadronMenu.EnumProblemState verifyDroneSpace(AmadronMenu.EnumProblemState curProb, ResourceLocation offerId, AmadronTradeResource resource) {
        return curProb.addProblem(resource.apply(itemStack -> {
            int stacks = resource.totalSpaceRequired(this.getUnits(offerId));
            if (stacks > 36) {
                int maxItems = 36 * itemStack.getMaxStackSize();
                this.setUnits(offerId, maxItems / itemStack.getCount());
                return AmadronMenu.EnumProblemState.TOO_MANY_ITEMS;
            }
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }, fluidStack -> {
            int space = resource.totalSpaceRequired(this.getUnits(offerId));
            if (space > 576000) {
                this.setUnits(offerId, 576000 / fluidStack.getAmount());
                return AmadronMenu.EnumProblemState.TOO_MUCH_FLUID;
            }
            return AmadronMenu.EnumProblemState.NO_PROBLEMS;
        }));
    }

    public void syncToPlayer(ServerPlayer player) {
        this.basket.forEach((? super K offerId, ? super V units) -> NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse((ResourceLocation)offerId, (int)units), player));
    }

    public boolean isEmpty() {
        return this.basket.values().stream().noneMatch(amount -> amount > 0);
    }

    private static Map<Fluid, Integer> countFluids(IFluidHandler handler) {
        HashMap<Fluid, Integer> result = new HashMap<Fluid, Integer>();
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack stack = handler.getFluidInTank(i);
            result.merge(stack.getFluid(), stack.getAmount(), Integer::sum);
        }
        return result;
    }
}

