/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.block.PressureChamberWallState;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberWallBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPressureWallBlock
extends AbstractPneumaticCraftBlock
implements IBlockPressureChamber,
PneumaticCraftEntityBlock {
    AbstractPressureWallBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PressureChamberWallBlockEntity(pPos, pState);
    }

    @Override
    public void setPlacedBy(Level par1World, BlockPos pos, BlockState state, LivingEntity par5EntityLiving, ItemStack iStack) {
        super.setPlacedBy(par1World, pos, state, par5EntityLiving, iStack);
        if (!par1World.isClientSide && PressureChamberValveBlockEntity.checkIfProperlyFormed(par1World, pos)) {
            ModCriterionTriggers.PRESSURE_CHAMBER.get().trigger((ServerPlayer)par5EntityLiving);
        }
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, PressureChamberWallBlockEntity.class).map(te -> {
                PressureChamberValveBlockEntity valve = te.getPrimaryValve();
                if (valve != null) {
                    sp.openMenu((MenuProvider)valve, valve.getBlockPos());
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.FAIL;
            }).orElse(InteractionResult.FAIL);
        }
        return this.isFormed(state) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private boolean isFormed(BlockState state) {
        if (state.hasProperty(PNCBlockStateProperties.WALL_STATE)) {
            return state.getValue(PNCBlockStateProperties.WALL_STATE) != PressureChamberWallState.NONE;
        }
        if (state.hasProperty((Property)PNCBlockStateProperties.FORMED)) {
            return (Boolean)state.getValue((Property)PNCBlockStateProperties.FORMED);
        }
        return false;
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock() && !world.isClientSide) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, PressureChamberWallBlockEntity.class).ifPresent(PressureChamberWallBlockEntity::onBlockBreak);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }
}

