/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.gui.AphorismTileScreen;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class AphorismTileBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
PneumaticCraftEntityBlock {
    public static final float APHORISM_TILE_THICKNESS = 0.0625f;
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public AphorismTileBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).strength(1.5f, 4.0f).noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{INVISIBLE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        if (state.getBlock() == ModBlocks.APHORISM_TILE.get() && ((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            return selectionContext.isDescending() ? SHAPES[this.getRotation(state).get3DDataValue()] : Shapes.empty();
        }
        return SHAPES[this.getRotation(state).get3DDataValue()];
    }

    @Override
    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)this.directionProperty(), (Comparable)ctx.getClickedFace().getOpposite());
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return state.getBlock() == ModBlocks.APHORISM_TILE.get() && (Boolean)state.getValue((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    @Override
    public void appendHoverText(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        CompoundTag subTag;
        super.appendHoverText(stack, world, curInfo, flag);
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null && tag.contains("ExtraData") && ((subTag = tag.getCompound("ExtraData")).contains("borderColor") || subTag.contains("backgroundColor"))) {
            ListTag l = subTag.getList("lines", 8);
            if (!l.isEmpty()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.text", new Object[0]).withStyle(ChatFormatting.YELLOW));
                l.forEach(el -> curInfo.add((Component)Component.literal((String)("  " + el.getAsString())).withStyle(ChatFormatting.ITALIC)));
            }
            curInfo.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.block.pneumaticcraft.aphorism_tile.reset", new Object[0]).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        super.setPlacedBy(world, pos, state, entityLiving, iStack);
        if (world.isClientSide) {
            PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).ifPresent(teAT -> {
                CompoundTag tag = iStack.getTagElement("BlockEntityTag");
                if (tag != null) {
                    teAT.readFromPacket(tag);
                }
                AphorismTileScreen.openGui(teAT, true);
                if (entityLiving instanceof Player) {
                    this.sendEditorMessage((Player)entityLiving);
                }
            });
        }
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof AphorismTileBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AphorismTileBlockEntity teAT = (AphorismTileBlockEntity)te;
        if (!world.isClientSide && player.getItemInHand(hand).is(Tags.Items.DYES) && !teAT.isInvisible()) {
            return this.tryDyeTile(state, player, hand, brtr, teAT);
        }
        if (world.isClientSide && hand == InteractionHand.MAIN_HAND && player.getItemInHand(hand).isEmpty()) {
            return this.openEditorGui(player, teAT);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryDyeTile(BlockState state, Player player, InteractionHand hand, BlockHitResult brtr, AphorismTileBlockEntity teAT) {
        DyeColor color = DyeColor.getColor((ItemStack)player.getItemInHand(hand));
        if (color != null) {
            if (this.clickedBorder(state, brtr.getLocation())) {
                if (teAT.getBorderColor() != color.getId()) {
                    teAT.setBorderColor(color.getId());
                    if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                }
            } else if (teAT.getBackgroundColor() != color.getId()) {
                teAT.setBackgroundColor(color.getId());
                if (((Boolean)ConfigHelper.common().general.useUpDyesWhenColoring.get()).booleanValue()) {
                    player.getItemInHand(hand).shrink(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult openEditorGui(Player player, AphorismTileBlockEntity teAT) {
        AphorismTileScreen.openGui(teAT, false);
        this.sendEditorMessage(player);
        return InteractionResult.SUCCESS;
    }

    private boolean clickedBorder(BlockState state, Vec3 hitVec) {
        double x = Math.abs(hitVec.x - (double)((int)hitVec.x));
        double y = Math.abs(hitVec.y - (double)((int)hitVec.y));
        double z = Math.abs(hitVec.z - (double)((int)hitVec.z));
        return switch (this.getRotation(state)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST, Direction.WEST -> {
                if (y < 0.1 || y > 0.9 || z < 0.1 || z > 0.9) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if (y < 0.1 || y > 0.9 || x < 0.1 || x > 0.9) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP, Direction.DOWN -> x < 0.1 || x > 0.9 || z < 0.1 || z > 0.9;
        };
    }

    private void sendEditorMessage(Player player) {
        MutableComponent msg = Component.literal((String)ChatFormatting.WHITE.toString()).append((Component)Component.translatable((String)"pneumaticcraft.gui.aphorismTileEditor")).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"pneumaticcraft.gui.holdF1forHelp"));
        player.displayClientMessage((Component)msg, true);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction face, InteractionHand hand) {
        if (player != null && player.isShiftKeyDown()) {
            return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).map(teAt -> {
                teAt.setTextRotation((teAt.getTextRotation() + 1) % 4);
                teAt.sendDescriptionPacket();
                return true;
            }).orElse(false);
        }
        return super.onWrenched(world, player, pos, face, hand);
    }

    @Override
    protected boolean rotateForgeWay() {
        return false;
    }

    @Override
    public int getTintColor(BlockState state, @javax.annotation.Nullable BlockAndTintGetter world, @javax.annotation.Nullable BlockPos pos, int tintIndex) {
        if (world != null && pos != null) {
            return PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AphorismTileBlockEntity.class).map(teAt -> switch (tintIndex) {
                case 0 -> PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.byId((int)teAt.getBorderColor()));
                case 1 -> ColorHandlers.desaturate(PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.byId((int)teAt.getBackgroundColor())));
                default -> -1;
            }).orElse(-1);
        }
        return -1;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AphorismTileBlockEntity(pPos, pState);
    }

    public static class ItemBlockAphorismTile
    extends BlockItem
    implements ColorHandlers.ITintableItem {
        public ItemBlockAphorismTile(AphorismTileBlock blockAphorismTile) {
            super((Block)blockAphorismTile, ModItems.defaultProps());
        }

        private static int getColor(ItemStack stack, String key, DyeColor fallback) {
            CompoundTag tag = stack.getTagElement("BlockEntityTag");
            if (tag != null && tag.contains("ExtraData")) {
                return tag.getCompound("ExtraData").getInt(key);
            }
            return fallback.getId();
        }

        @Override
        public int getTintColor(ItemStack stack, int tintIndex) {
            return switch (tintIndex) {
                case 0 -> PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.byId((int)ItemBlockAphorismTile.getColor(stack, "borderColor", DyeColor.BLUE)));
                case 1 -> ColorHandlers.desaturate(PneumaticCraftUtils.getDyeColorAsRGB(DyeColor.byId((int)ItemBlockAphorismTile.getColor(stack, "backgroundColor", DyeColor.WHITE))));
                default -> 0xFFFFFF;
            };
        }
    }
}

