/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ElevatorBaseBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape BASE = ElevatorBaseBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape TOP = ElevatorBaseBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape CORE = ElevatorBaseBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{CORE, TOP});

    public ElevatorBaseBlock() {
        super(ModBlocks.defaultProps().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AbstractPneumaticCraftBlock.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractPneumaticCraftBlock.EAST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public void onPlace(BlockState newState, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(newState, world, pos, oldState, isMoving);
        ElevatorBaseBlockEntity elevatorBase = ElevatorBaseBlock.getCoreTileEntity(world, pos);
        if (elevatorBase != null) {
            elevatorBase.updateMaxElevatorHeight();
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AbstractPneumaticCraftBlock.NORTH, AbstractPneumaticCraftBlock.SOUTH, AbstractPneumaticCraftBlock.WEST, AbstractPneumaticCraftBlock.EAST});
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        return super.use(state, world, ElevatorBaseBlock.getCoreElevatorPos(world, pos), player, hand, brtr);
    }

    private static BlockPos getCoreElevatorPos(Level world, BlockPos pos) {
        if (world.getBlockState(pos.relative(Direction.UP)).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
            return ElevatorBaseBlock.getCoreElevatorPos(world, pos.relative(Direction.UP));
        }
        return pos;
    }

    public static ElevatorBaseBlockEntity getCoreTileEntity(Level world, BlockPos pos) {
        return (ElevatorBaseBlockEntity)world.getBlockEntity(ElevatorBaseBlock.getCoreElevatorPos(world, pos));
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            ElevatorBaseBlockEntity elevatorBase;
            if (world.getBlockState(pos.relative(Direction.DOWN)).getBlock() == ModBlocks.ELEVATOR_BASE.get()) {
                BlockEntity te = world.getBlockEntity(pos.relative(Direction.DOWN));
                ((ElevatorBaseBlockEntity)te).moveUpgradesFromAbove();
            }
            if ((elevatorBase = ElevatorBaseBlock.getCoreTileEntity(world, pos)) != null) {
                elevatorBase.updateMaxElevatorHeight();
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ElevatorBaseBlockEntity(pPos, pState);
    }
}

