/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.elevator.ElevatorFrameBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorFrameBlock
extends AbstractPneumaticCraftBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final VoxelShape MOSTLY_FULL = Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    private static final BooleanProperty NE = BooleanProperty.create((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.create((String)"se");
    private static final BooleanProperty SW = BooleanProperty.create((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.create((String)"nw");

    public ElevatorFrameBlock() {
        super(ModBlocks.defaultProps());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NE, (Comparable)Boolean.valueOf(false))).setValue((Property)SE, (Comparable)Boolean.valueOf(false))).setValue((Property)SW, (Comparable)Boolean.valueOf(false))).setValue((Property)NW, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        ElevatorFrameBlock.getElevatorBase((BlockGetter)pLevel, pPos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NE, SW, SE, NW});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state != null) {
            boolean[] connected = this.getConnections((BlockGetter)ctx.getLevel(), ctx.getClickedPos());
            ((BlockState)((BlockState)((BlockState)state.setValue((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).setValue((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).setValue((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).setValue((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
        }
        return state;
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        boolean[] connected = this.getConnections((BlockGetter)worldIn, currentPos);
        for (Corner corner : Corner.values()) {
            stateIn = (BlockState)stateIn.setValue((Property)corner.prop, (Comparable)Boolean.valueOf(connected[corner.ordinal()]));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return selectionContext.isHoldingItem(this.asItem()) ? MOSTLY_FULL : this.getCachedShape(state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        double blockHeight = this.getElevatorBlockHeight(worldIn, pos);
        if (blockHeight > 1.0) {
            return Shapes.block();
        }
        if (blockHeight > 0.0) {
            double minY = Math.max(0.0, blockHeight - 0.06125) * 16.0;
            double maxY = blockHeight * 16.0;
            return Shapes.or((VoxelShape)this.getCachedShape(state), (VoxelShape)Block.box((double)0.001, (double)minY, (double)0.001, (double)15.999, (double)maxY, (double)15.999));
        }
        return this.getCachedShape(state);
    }

    @Override
    public RenderShape getRenderShape(BlockState state) {
        return this.getCachedShape(state).isEmpty() ? RenderShape.INVISIBLE : super.getRenderShape(state);
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.getValue((Property)NE) != false ? 1 : 0) | ((Boolean)state.getValue((Property)SE) != false ? 2 : 0) | ((Boolean)state.getValue((Property)SW) != false ? 4 : 0) | ((Boolean)state.getValue((Property)NW) != false ? 8 : 0);
        if (SHAPE_CACHE[shapeIdx] == null) {
            VoxelShape shape = Shapes.empty();
            for (Corner corner : Corner.values()) {
                if (((Boolean)state.getValue((Property)corner.prop)).booleanValue()) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)corner.shape);
            }
            ElevatorFrameBlock.SHAPE_CACHE[shapeIdx] = shape;
        }
        return SHAPE_CACHE[shapeIdx];
    }

    private boolean[] getConnections(BlockGetter world, BlockPos pos) {
        boolean[] res = new boolean[4];
        boolean frameXPos = world.getBlockState(pos.east()).getBlock() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameXNeg = world.getBlockState(pos.west()).getBlock() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZPos = world.getBlockState(pos.south()).getBlock() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZNeg = world.getBlockState(pos.north()).getBlock() == ModBlocks.ELEVATOR_FRAME.get();
        res[Corner.SE.ordinal()] = frameXPos || frameZPos;
        res[Corner.NE.ordinal()] = frameXPos || frameZNeg;
        res[Corner.SW.ordinal()] = frameXNeg || frameZPos;
        res[Corner.NW.ordinal()] = frameXNeg || frameZNeg;
        return res;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        ElevatorFrameBlock.getElevatorBase((BlockGetter)world, pos).ifPresent(teBase -> {
            if (!teBase.isStopped()) {
                int baseY = teBase.getBlockPos().getY();
                if (entity.getY() >= (double)baseY && entity.getY() < (double)baseY + teBase.extension + 10.0) {
                    double eX = entity.getX();
                    double eZ = entity.getZ();
                    if (teBase.ticksRunning < 10) {
                        int x = pos.getX();
                        int z = pos.getZ();
                        AABB box = entity.getBoundingBox();
                        if (box.minX < (double)x && !(teBase.getCachedNeighbor(Direction.WEST) instanceof ElevatorBaseBlockEntity) || box.maxX > (double)(x + 1) && !(teBase.getCachedNeighbor(Direction.EAST) instanceof ElevatorBaseBlockEntity)) {
                            eX = (double)x + 0.5;
                        }
                        if (box.minZ < (double)z && !(teBase.getCachedNeighbor(Direction.NORTH) instanceof ElevatorBaseBlockEntity) || box.maxZ > (double)(z + 1) && !(teBase.getCachedNeighbor(Direction.SOUTH) instanceof ElevatorBaseBlockEntity)) {
                            eZ = (double)z + 0.5;
                        }
                    }
                    entity.setPos(eX, (double)baseY + teBase.extension + 1.2, eZ);
                    if (entity instanceof ServerPlayer && teBase.getUpgrades(ModUpgrades.SPEED.get()) >= 6) {
                        ((ServerPlayer)entity).connection.resetPosition();
                    }
                    entity.fallDistance = 0.0f;
                }
            }
        });
    }

    static Optional<ElevatorBaseBlockEntity> getElevatorBase(BlockGetter world, BlockPos pos) {
        return world.getBlockEntity(pos, ModBlockEntityTypes.ELEVATOR_FRAME.get()).map(ElevatorFrameBlockEntity::getElevatorBase);
    }

    private double getElevatorBlockHeight(BlockGetter world, BlockPos pos) {
        return ElevatorFrameBlock.getElevatorBase(world, pos).map(te -> Math.max(te.extension - (double)(pos.getY() - te.getBlockPos().getY()) + 1.0, 0.0)).orElse(0.0);
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        ElevatorFrameBlock.getElevatorBase((BlockGetter)world, pos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState below = worldIn.getBlockState(pos.below());
        return below.getBlock() == this || below.getBlock() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return this.getElevatorBlockHeight(worldIn, pos) == 0.0;
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (!player.isCrouching() && player.getItemInHand(hand).getItem() == this.asItem()) {
            if (!world.isClientSide) {
                BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
                int worldHeight = world.dimensionType().logicalHeight();
                while (mPos.getY() < worldHeight && world.getBlockState((BlockPos)mPos).getBlock() == this) {
                    mPos.move(Direction.UP);
                }
                if (mPos.getY() < worldHeight && world.getBlockState((BlockPos)mPos).isAir()) {
                    world.setBlockAndUpdate((BlockPos)mPos, this.defaultBlockState());
                    float pitch = Math.min(1.5f, (float)(mPos.getY() - pos.getY()) * 0.05f + 1.0f);
                    world.playSound(null, (BlockPos)mPos, SoundEvents.METAL_PLACE, SoundSource.BLOCKS, 1.0f, pitch);
                    if (!player.isCreative()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, brtr);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ElevatorFrameBlockEntity(pPos, pState);
    }

    private static enum Corner {
        NE(1, -1, NE, Block.box((double)14.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)1.5)),
        SE(1, 1, SE, Block.box((double)14.5, (double)0.0, (double)14.5, (double)15.5, (double)16.0, (double)15.5)),
        SW(-1, 1, SW, Block.box((double)0.5, (double)0.0, (double)14.5, (double)1.5, (double)16.0, (double)15.5)),
        NW(-1, -1, NW, Block.box((double)0.5, (double)0.0, (double)0.5, (double)1.5, (double)16.0, (double)1.5));

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Corner(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }
}

