/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.RenderFluidTank;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractFluidTankBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.FluidHandlerSavedItemStack;
import me.desht.pneumaticcraft.common.item.IFluidCapProvider;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidTankBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0), Block.box((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0), Block.box((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)14.0), Block.box((double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0), Block.box((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0), Block.box((double)15.0, (double)14.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)14.0), Block.box((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)13.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private final Size size;

    public FluidTankBlock(Size size) {
        super(ModBlocks.defaultProps());
        this.size = size;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP, DOWN});
    }

    public Size getSize() {
        return this.size;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return state == null ? null : (BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState up = worldIn.getBlockState(currentPos.above());
        if (((Boolean)stateIn.getValue((Property)UP)).booleanValue() && !(up.getBlock() instanceof FluidTankBlock)) {
            stateIn = (BlockState)stateIn.setValue((Property)UP, (Comparable)Boolean.valueOf(false));
        }
        BlockState down = worldIn.getBlockState(currentPos.below());
        if (((Boolean)stateIn.getValue((Property)DOWN)).booleanValue() && !(down.getBlock() instanceof FluidTankBlock)) {
            stateIn = (BlockState)stateIn.setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return stateIn;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (!player.isShiftKeyDown()) {
            AbstractFluidTankBlockEntity te;
            BlockHitResult brtr;
            HitResult rtr = RayTraceUtils.getMouseOverServer((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
            if (rtr.getType() == HitResult.Type.BLOCK && (brtr = (BlockHitResult)rtr).getBlockPos().equals((Object)pos) && (te = this.getTankAt(world, pos)) != null) {
                double y = brtr.getLocation().y - (double)((int)brtr.getLocation().y);
                return this.tryToggleConnection(te, y >= 0.5 ? Direction.UP : Direction.DOWN);
            }
            return false;
        }
        return super.onWrenched(world, player, pos, side, hand);
    }

    private boolean tryToggleConnection(AbstractFluidTankBlockEntity thisTank, Direction dir) {
        BlockState state = thisTank.getBlockState();
        Level level = thisTank.nonNullLevel();
        AbstractFluidTankBlockEntity neighbourTank = this.getTankAt(level, thisTank.getBlockPos().relative(dir));
        if (neighbourTank == null) {
            return false;
        }
        BlockState stateOther = neighbourTank.getBlockState();
        boolean isConnected = (Boolean)state.getValue((Property)FluidTankBlock.connectionProperty(dir));
        if (isConnected) {
            level.setBlockAndUpdate(thisTank.getBlockPos(), (BlockState)state.setValue((Property)FluidTankBlock.connectionProperty(dir), (Comparable)Boolean.valueOf(false)));
            level.setBlockAndUpdate(neighbourTank.getBlockPos(), (BlockState)stateOther.setValue((Property)FluidTankBlock.connectionProperty(dir.getOpposite()), (Comparable)Boolean.valueOf(false)));
            return true;
        }
        FluidStack stack = thisTank.getTank().getFluid();
        if (neighbourTank.isFluidCompatible(stack, neighbourTank.getTank()) && neighbourTank.isNeighbourCompatible(stack, dir)) {
            level.setBlockAndUpdate(thisTank.getBlockPos(), (BlockState)state.setValue((Property)FluidTankBlock.connectionProperty(dir), (Comparable)Boolean.valueOf(true)));
            level.setBlockAndUpdate(neighbourTank.getBlockPos(), (BlockState)stateOther.setValue((Property)FluidTankBlock.connectionProperty(dir.getOpposite()), (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    private AbstractFluidTankBlockEntity getTankAt(Level world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof AbstractFluidTankBlockEntity ? (AbstractFluidTankBlockEntity)te : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return this.size.beFactory.apply(pPos, pState);
    }

    public static enum Size {
        SMALL(32000, AbstractFluidTankBlockEntity.Small::new),
        MEDIUM(64000, AbstractFluidTankBlockEntity.Medium::new),
        LARGE(128000, AbstractFluidTankBlockEntity.Large::new),
        HUGE(512000, AbstractFluidTankBlockEntity.Huge::new);

        private final int capacity;
        private final BiFunction<BlockPos, BlockState, BlockEntity> beFactory;

        private Size(int capacity, BiFunction<BlockPos, BlockState, BlockEntity> beFactory) {
            this.capacity = capacity;
            this.beFactory = beFactory;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    public static class ItemBlockFluidTank
    extends BlockItem
    implements IFluidRendered,
    IFluidCapProvider {
        public static final String TANK_NAME = "Tank";
        private final int capacity;
        private RenderFluidTank.ItemRenderInfoProvider renderInfoProvider;

        public ItemBlockFluidTank(Block block) {
            super(block, ModItems.defaultProps());
            this.capacity = ((FluidTankBlock)block).size.capacity;
        }

        public boolean hasCraftingRemainingItem(ItemStack stack) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(f -> !f.isEmpty()).orElse(false);
        }

        public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
            boolean creative = UpgradableItemUtils.hasCreativeUpgrade(itemStack);
            return FluidUtil.getFluidHandler((ItemStack)itemStack.copy()).map(handler -> {
                handler.drain(1000, creative ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }).orElseThrow(RuntimeException::new);
        }

        @Override
        public IFluidItemRenderInfoProvider getFluidItemRenderer() {
            if (this.renderInfoProvider == null) {
                this.renderInfoProvider = new RenderFluidTank.ItemRenderInfoProvider();
            }
            return this.renderInfoProvider;
        }

        public int getMaxStackSize(ItemStack stack) {
            return stack.hasTag() && Objects.requireNonNull(stack.getTag()).contains("BlockEntityTag") ? 1 : 64;
        }

        @Override
        public IFluidHandlerItem provideFluidCapability(ItemStack stack) {
            return new FluidHandlerSavedItemStack(stack, TANK_NAME, this.capacity);
        }
    }
}

