/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlasticBrickBlock
extends Block
implements ColorHandlers.ITintableBlock {
    private static final VoxelShape COLLISION_SHAPE = PlasticBrickBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final EnumProperty<PartType> X_PART = EnumProperty.create((String)"x_part", PartType.class);
    private static final EnumProperty<PartType> Z_PART = EnumProperty.create((String)"z_part", PartType.class);
    private final DyeColor dyeColor;
    private final int tintColor;

    public PlasticBrickBlock(DyeColor dyeColor) {
        this(ModBlocks.defaultProps().sound(SoundType.WOOD).strength(2.0f), dyeColor);
    }

    PlasticBrickBlock(BlockBehaviour.Properties props, DyeColor dyeColor) {
        super(props);
        this.dyeColor = dyeColor;
        this.tintColor = PneumaticCraftUtils.getDyeColorAsRGB(dyeColor);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(X_PART, (Comparable)((Object)PartType.NONE))).setValue(Z_PART, (Comparable)((Object)PartType.NONE)));
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{X_PART, Z_PART});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.block();
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        return this.calcParts((LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), state);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.calcParts(worldIn, currentPos, stateIn);
    }

    protected boolean hurtsToStepOn() {
        return true;
    }

    private BlockState calcParts(LevelAccessor world, BlockPos pos, BlockState stateIn) {
        boolean zRight;
        boolean xRight;
        Block w = world.getBlockState(pos.west()).getBlock();
        Block e = world.getBlockState(pos.east()).getBlock();
        PartType xType = PartType.NONE;
        boolean bl = xRight = (pos.getX() + pos.getY() & 1) == 0;
        if (xRight && w == this) {
            xType = PartType.RIGHT;
        } else if (!xRight && e == this) {
            xType = PartType.LEFT;
        }
        Block n = world.getBlockState(pos.north()).getBlock();
        Block s = world.getBlockState(pos.south()).getBlock();
        PartType zType = PartType.NONE;
        boolean bl2 = zRight = (pos.getZ() + pos.getY() & 1) == 0;
        if (zRight && s == this) {
            zType = PartType.RIGHT;
        } else if (!zRight && n == this) {
            zType = PartType.LEFT;
        }
        return (BlockState)((BlockState)stateIn.setValue(X_PART, (Comparable)((Object)xType))).setValue(Z_PART, (Comparable)((Object)zType));
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity livingEntity;
        ItemStack stack;
        if (this.hurtsToStepOn() && entityIn instanceof LivingEntity && (stack = (livingEntity = (LivingEntity)entityIn).getItemBySlot(EquipmentSlot.FEET)).isEmpty()) {
            entityIn.hurt(PNCDamageSource.plasticBlock(worldIn), 3.0f);
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
        }
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        return this.tintColor;
    }

    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    static enum PartType implements StringRepresentable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private PartType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static class ItemPlasticBrick
    extends BlockItem
    implements ICustomTooltipName {
        public ItemPlasticBrick(PlasticBrickBlock blockPlasticBrick) {
            super((Block)blockPlasticBrick, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            return "block.pneumaticcraft.plastic_brick";
        }
    }
}

