/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.ITubeNetworkConnector;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.block.PressureTubeConnection;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.tube.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.item.TubeModuleItem;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractNetworkedRedstoneModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.tubemodules.INetworkedModule;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class PressureTubeBlock
extends AbstractCamouflageBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock,
ITubeNetworkConnector {
    private static final int TUBE_WIDTH = 2;
    public static final int CORE_MIN = 6;
    public static final int CORE_MAX = 10;
    private static final double PLUG_SIZE = 2.5;
    private static final VoxelShape CORE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] ARM_CONNECTED = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private static final VoxelShape[] ARM_CLOSED = new VoxelShape[]{Block.box((double)6.0, (double)3.5, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.5, (double)10.0), Block.box((double)6.0, (double)6.0, (double)3.5, (double)10.0, (double)10.0, (double)6.0), Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)12.5), Block.box((double)3.5, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Block.box((double)10.0, (double)6.0, (double)6.0, (double)12.5, (double)10.0, (double)10.0)};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[729];
    private static final EnumProperty<PressureTubeConnection>[] CONNECTION_PROPERTIES_3 = new EnumProperty[]{PNCBlockStateProperties.PressureTubes.DOWN, PNCBlockStateProperties.PressureTubes.UP, PNCBlockStateProperties.PressureTubes.NORTH, PNCBlockStateProperties.PressureTubes.SOUTH, PNCBlockStateProperties.PressureTubes.WEST, PNCBlockStateProperties.PressureTubes.EAST};
    private final BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> teFactory;

    public PressureTubeBlock(BiFunction<BlockPos, BlockState, ? extends PressureTubeBlockEntity> teFactory) {
        super(ModBlocks.defaultProps().noOcclusion());
        this.teFactory = teFactory;
        BlockState state = this.defaultBlockState();
        for (EnumProperty<PressureTubeConnection> p : CONNECTION_PROPERTIES_3) {
            state = (BlockState)state.setValue(p, (Comparable)((Object)PressureTubeConnection.OPEN));
        }
        this.registerDefaultState(state);
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return this.teFactory.apply(pPos, pState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(CONNECTION_PROPERTIES_3);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        ArrayList<Direction> l = new ArrayList<Direction>();
        for (Direction dir : DirectionUtil.VALUES) {
            BlockEntity te = ctx.getLevel().getBlockEntity(ctx.getClickedPos().relative(dir));
            if (te == null || !PNCCapabilities.getAirHandler(te, dir.getOpposite()).isPresent()) continue;
            state = PressureTubeBlock.setSide(state, dir, PressureTubeConnection.CONNECTED);
            l.add(dir);
            if (l.size() > 1) break;
        }
        if (l.size() == 1) {
            state = PressureTubeBlock.setSide(state, ((Direction)l.get(0)).getOpposite(), PressureTubeConnection.CONNECTED);
        }
        return state;
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = PressureTubeBlock.recalculateState(worldIn, currentPos, stateIn);
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            ModuleNetworkManager.getInstance(level).invalidateCache();
            AbstractNetworkedRedstoneModule.onNetworkReform(level, currentPos);
        }
        return newState == null ? super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos) : newState;
    }

    public static BlockState recalculateState(LevelAccessor worldIn, BlockPos currentPos, BlockState stateIn) {
        PressureTubeBlockEntity tePT = PressureTubeBlock.getPressureTube((BlockGetter)worldIn, currentPos);
        if (tePT != null) {
            tePT.clearCachedShape();
            BlockState state = stateIn;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockEntity neighbourTE;
                PressureTubeConnection type = PressureTubeConnection.OPEN;
                if (tePT.isSideClosed(dir)) {
                    type = PressureTubeConnection.CLOSED;
                } else if (tePT.canConnectPneumatic(dir) && (neighbourTE = tePT.getCachedNeighbor(dir)) != null && PNCCapabilities.getAirHandler(neighbourTE, dir.getOpposite()).isPresent()) {
                    type = PressureTubeConnection.CONNECTED;
                }
                state = PressureTubeBlock.setSide(state, dir, type);
            }
            return PressureTubeBlock.checkForSingleConnection(tePT, state);
        }
        return stateIn;
    }

    private static BlockState checkForSingleConnection(PressureTubeBlockEntity te, BlockState state) {
        ArrayList<Direction> connected = new ArrayList<Direction>();
        int nUnconnected = 0;
        for (Direction dir : DirectionUtil.VALUES) {
            if (te.getModule(dir) != null) {
                return state;
            }
            switch ((PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()]))) {
                case CONNECTED: {
                    connected.add(dir);
                    break;
                }
                case OPEN: {
                    ++nUnconnected;
                    break;
                }
                case CLOSED: {
                    return state;
                }
            }
            if (connected.size() > 1) break;
        }
        if (nUnconnected == 5 && connected.size() == 1) {
            state = PressureTubeBlock.setSide(state, ((Direction)connected.get(0)).getOpposite(), PressureTubeConnection.CONNECTED);
        }
        return state;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        VoxelShape res = this.getCachedShape(state);
        PressureTubeBlockEntity te = PressureTubeBlock.getPressureTube(reader, pos);
        return te != null ? te.getCachedTubeShape(res) : res;
    }

    private VoxelShape getCachedShape(BlockState state) {
        int idx = 0;
        int mul = 1;
        for (Direction d : Direction.values()) {
            idx += ((PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[d.get3DDataValue()]))).getIndex() * mul;
            mul *= 3;
        }
        if (SHAPE_CACHE[idx] == null) {
            VoxelShape res = CORE;
            block5: for (Direction d : Direction.values()) {
                switch ((PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[d.get3DDataValue()]))) {
                    case CONNECTED: {
                        res = Shapes.join((VoxelShape)res, (VoxelShape)ARM_CONNECTED[d.get3DDataValue()], (BooleanOp)BooleanOp.OR);
                        continue block5;
                    }
                    case CLOSED: {
                        res = Shapes.join((VoxelShape)res, (VoxelShape)ARM_CLOSED[d.get3DDataValue()], (BooleanOp)BooleanOp.OR);
                    }
                }
            }
            PressureTubeBlock.SHAPE_CACHE[idx] = res;
        }
        return SHAPE_CACHE[idx];
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        AbstractTubeModule module;
        if (this.tryPlaceModule(player, world, pos, brtr.getDirection(), hand, false)) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown() && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null) {
            return module.onActivated(player, hand) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.use(state, world, pos, player, hand, brtr);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        PressureTubeBlockEntity te = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (!world.isClientSide() && te != null) {
            te.onNeighborTileUpdate(null);
        }
    }

    public boolean tryPlaceModule(Player player, Level world, BlockPos pos, Direction side, InteractionHand hand, boolean simulate) {
        AbstractTubeModule module;
        PressureTubeBlockEntity tePT = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tePT == null) {
            return false;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        Item item = heldStack.getItem();
        if (item instanceof TubeModuleItem) {
            TubeModuleItem tubeModuleItem = (TubeModuleItem)item;
            module = tubeModuleItem.createModule(side, tePT);
            if (tePT.mayPlaceModule(module)) {
                if (simulate) {
                    module.markFake();
                }
                tePT.setModule(side, module);
                if (!simulate && !world.isClientSide) {
                    this.neighborChanged(world.getBlockState(pos), world, pos, this, pos.relative(side), false);
                    world.updateNeighborsAt(pos, (Block)this);
                    if (!player.isCreative()) {
                        heldStack.shrink(1);
                    }
                    world.playSound(null, pos, SoundType.GLASS.getStepSound(), SoundSource.BLOCKS, SoundType.GLASS.getVolume() * 5.0f, SoundType.GLASS.getPitch() * 0.9f);
                    if (module instanceof INetworkedModule) {
                        ModuleNetworkManager.getInstance(world).invalidateCache();
                    }
                }
                if (!simulate) {
                    module.onPlaced();
                }
                return true;
            }
        } else if (heldStack.getItem() == ModItems.MODULE_EXPANSION_CARD.get() && !simulate && (module = PressureTubeBlock.getFocusedModule(world, pos, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
            if (!world.isClientSide) {
                module.upgrade();
                tePT.setChanged();
                tePT.sendDescriptionPacket();
                if (!player.isCreative()) {
                    heldStack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    public static AbstractTubeModule getFocusedModule(Level world, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.getBlockState(pos);
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace(state, (BlockGetter)world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE) {
            PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
            return tube == null ? null : tube.getModule(tubeHitInfo.dir);
        }
        return null;
    }

    private static BlockState setSide(BlockState state, Direction side, PressureTubeConnection type) {
        return (BlockState)state.setValue(CONNECTION_PROPERTIES_3[side.get3DDataValue()], (Comparable)((Object)type));
    }

    private static PressureTubeBlockEntity getPressureTube(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        return te instanceof PressureTubeBlockEntity ? (PressureTubeBlockEntity)te : null;
    }

    private static Pair<Boolean, Direction> getLookedTube(BlockGetter world, BlockPos pos, Player player) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockState state = world.getBlockState(pos);
        BlockHitInfo blockHitInfo = PressureTubeBlock.doTrace(state, world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = blockHitInfo.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return tubeHitInfo.dir == null ? Pair.of((Object)true, (Object)Objects.requireNonNull(blockHitInfo.res()).getDirection()) : Pair.of((Object)false, (Object)tubeHitInfo.dir);
        }
        return null;
    }

    @Nonnull
    private static BlockHitInfo doTrace(BlockState state, BlockGetter world, BlockPos pos, Vec3 origin, Vec3 direction) {
        PressureTubeBlockEntity tube;
        BlockHitResult bestRTR = null;
        TubeHitInfo hitInfo = TubeHitInfo.NO_HIT;
        BlockHitResult brtr = AABB.clip(Collections.singletonList(CORE.bounds()), (Vec3)origin, (Vec3)direction, (BlockPos)pos);
        if (brtr != null) {
            hitInfo = TubeHitInfo.CENTER;
            bestRTR = brtr;
        }
        if ((tube = PressureTubeBlock.getPressureTube(world, pos)) == null) {
            return new BlockHitInfo(BlockHitResult.miss((Vec3)origin, (Direction)Direction.UP, (BlockPos)pos), TubeHitInfo.NO_HIT);
        }
        for (int i = 0; i < 6; ++i) {
            AABB arm;
            switch ((PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[i]))) {
                case CLOSED: {
                    AABB aABB = ARM_CLOSED[i].bounds();
                    break;
                }
                case CONNECTED: {
                    AABB aABB = ARM_CONNECTED[i].bounds();
                    break;
                }
                default: {
                    AABB aABB = arm = null;
                }
            }
            if (arm == null || (brtr = AABB.clip(Collections.singletonList(arm), (Vec3)origin, (Vec3)direction, (BlockPos)pos)) == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)brtr)) continue;
            hitInfo = new TubeHitInfo(Direction.from3DDataValue((int)i), TubeHitInfo.PartType.TUBE);
            bestRTR = brtr;
        }
        for (Direction dir : DirectionUtil.VALUES) {
            AABB tubeAABB;
            AbstractTubeModule tm = tube.getModule(dir);
            if (tm == null || !PressureTubeBlock.isCloserIntersection(origin, (HitResult)bestRTR, (HitResult)(brtr = AABB.clip(Collections.singletonList(tubeAABB = tm.getShape().bounds()), (Vec3)origin, (Vec3)direction, (BlockPos)pos))) && !tm.isInlineAndFocused(hitInfo)) continue;
            hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.MODULE);
            bestRTR = brtr;
        }
        return new BlockHitInfo(bestRTR, hitInfo);
    }

    private static boolean isCloserIntersection(Vec3 origin, HitResult oldRTR, HitResult newRTR) {
        return newRTR != null && (oldRTR == null || origin.distanceToSqr(newRTR.getLocation()) <= origin.distanceToSqr(oldRTR.getLocation()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        AbstractTubeModule tm;
        PressureTubeBlockEntity tube;
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
        BlockHitInfo rayTraceResult = PressureTubeBlock.doTrace(state, (BlockGetter)world, pos, (Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        TubeHitInfo tubeHitInfo = rayTraceResult.tubeHitInfo();
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return super.getCloneItemStack(state, target, world, pos, player);
        }
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE && (tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos)) != null && (tm = tube.getModule(tubeHitInfo.dir)) != null) {
            return new ItemStack((ItemLike)tm.getItem());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (player == null) {
            return false;
        }
        PressureTubeBlockEntity tube = PressureTubeBlock.getPressureTube((BlockGetter)world, pos);
        if (tube == null) {
            return false;
        }
        AbstractTubeModule module = PressureTubeBlock.getFocusedModule(world, pos, player);
        if (player.isShiftKeyDown()) {
            if (module != null) {
                if (!player.isCreative()) {
                    for (ItemStack drop : module.getDrops()) {
                        ItemEntity entity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                        world.addFreshEntity((Entity)entity);
                        entity.playerTouch(player);
                    }
                }
                tube.setModule(module.getDirection(), null);
                this.neighborChanged(world.getBlockState(pos), world, pos, this, pos.relative(side), false);
                world.updateNeighborsAt(pos, (Block)this);
            } else {
                if (!player.isCreative()) {
                    PressureTubeBlock.dropResources((BlockState)world.getBlockState(pos), (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tube);
                }
                PressureTubeBlock.removeBlockSneakWrenched(world, pos);
            }
        } else if (module != null) {
            module.onActivated(player, hand);
        } else {
            Pair<Boolean, Direction> lookData = PressureTubeBlock.getLookedTube((BlockGetter)world, pos, player);
            if (lookData != null) {
                Direction sideHit;
                this.setTubeSideClosed(tube, sideHit, !tube.isSideClosed(sideHit = (Direction)lookData.getRight()));
                if (tube.isSideClosed(sideHit)) {
                    PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos.relative(sideHit), PressureTubeBlockEntity.class).ifPresent(tube2 -> {
                        if (this.shouldCloseNeighbor((PressureTubeBlockEntity)tube2, sideHit)) {
                            this.setTubeSideClosed((PressureTubeBlockEntity)tube2, sideHit.getOpposite(), true);
                        }
                    });
                }
            }
        }
        return true;
    }

    private boolean shouldCloseNeighbor(PressureTubeBlockEntity tube2, Direction offset) {
        boolean doClose = false;
        for (Direction d : DirectionUtil.VALUES) {
            if (tube2.getConnectedNeighbor(d) == null) continue;
            if (d.getAxis() == offset.getAxis()) {
                doClose = true;
                continue;
            }
            return false;
        }
        return doClose;
    }

    private void setTubeSideClosed(PressureTubeBlockEntity tube, Direction side, boolean closed) {
        tube.setSideClosed(side, closed);
        Level world = tube.nonNullLevel();
        BlockPos pos = tube.getBlockPos();
        world.setBlockAndUpdate(pos, PressureTubeBlock.recalculateState((LevelAccessor)world, pos, world.getBlockState(pos)));
        PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(world, pos);
    }

    @Override
    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != state.getBlock()) {
            PressureTubeBlock.getModuleDrops(PressureTubeBlock.getPressureTube((BlockGetter)world, pos)).forEach(drop -> world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop)));
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    private static NonNullList<ItemStack> getModuleDrops(PressureTubeBlockEntity tube) {
        NonNullList drops = NonNullList.create();
        if (tube != null) {
            tube.tubeModules().map(AbstractTubeModule::getDrops).forEach(arg_0 -> drops.addAll(arg_0));
        }
        return drops;
    }

    public int getSignal(BlockState state, BlockGetter par1IBlockAccess, BlockPos pos, Direction side) {
        PressureTubeBlockEntity tePt = PressureTubeBlock.getPressureTube(par1IBlockAccess, pos);
        if (tePt != null) {
            int redstoneLevel = 0;
            for (Direction face : DirectionUtil.VALUES) {
                AbstractTubeModule tm = tePt.getModule(face);
                if (tm == null || side.getOpposite() != face && (face == side || !tm.isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tm.getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        PressureTubeConnection[] conns = new PressureTubeConnection[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            conns[rotation.rotate((Direction)dir).get2DDataValue()] = (PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.setValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()], (Comparable)((Object)conns[dir.get2DDataValue()]));
        }
        return super.rotate(state, rotation);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        PressureTubeConnection[] conns = new PressureTubeConnection[DirectionUtil.HORIZONTALS.length];
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            Rotation r = mirrorIn.getRotation(dir);
            conns[r.rotate((Direction)dir).get2DDataValue()] = (PressureTubeConnection)((Object)state.getValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()]));
        }
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            state = (BlockState)state.setValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()], (Comparable)((Object)conns[dir.get2DDataValue()]));
        }
        return super.mirror(state, mirrorIn);
    }

    @Override
    public boolean canConnectToNetwork(Level level, BlockPos pos, Direction dir, BlockState state) {
        return state.hasProperty(CONNECTION_PROPERTIES_3[dir.get3DDataValue()]) && state.getValue(CONNECTION_PROPERTIES_3[dir.get3DDataValue()]) == PressureTubeConnection.CONNECTED;
    }

    private record BlockHitInfo(BlockHitResult res, @Nonnull TubeHitInfo tubeHitInfo) {
    }

    public record TubeHitInfo(Direction dir, PartType type) {
        static final TubeHitInfo NO_HIT = new TubeHitInfo(null, null);
        public static final TubeHitInfo CENTER = new TubeHitInfo(null, PartType.TUBE);

        static enum PartType {
            TUBE,
            MODULE;

        }
    }
}

