/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryOutputBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class RefineryOutputBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)13.0, (double)11.0, (double)14.5, (double)14.5, (double)12.0, (double)15.5), Block.box((double)12.0, (double)1.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0), Block.box((double)3.0, (double)1.0, (double)14.0, (double)4.0, (double)13.0, (double)16.0), Block.box((double)1.5, (double)11.0, (double)14.5, (double)3.0, (double)12.0, (double)15.5), Block.box((double)0.0, (double)10.0, (double)14.0, (double)2.0, (double)13.0, (double)16.0), Block.box((double)14.0, (double)10.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)14.5, (double)1.0, (double)14.5, (double)15.5, (double)15.0, (double)15.5), Block.box((double)14.5, (double)1.0, (double)0.5, (double)15.5, (double)15.0, (double)1.5), Block.box((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.box((double)1.5, (double)11.0, (double)0.5, (double)14.5, (double)12.0, (double)1.5), Block.box((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)16.0, (double)13.0), Block.box((double)4.0, (double)1.0, (double)13.0, (double)12.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)15.0, (double)6.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)15.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0, (double)7.0), Block.box((double)15.0, (double)15.0, (double)11.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.5, (double)11.0, (double)1.5, (double)1.5, (double)12.0, (double)14.5), Block.box((double)0.5, (double)1.0, (double)0.5, (double)1.5, (double)15.0, (double)1.5), Block.box((double)0.5, (double)1.0, (double)14.5, (double)1.5, (double)15.0, (double)15.5), Block.box((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0), Block.box((double)14.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)11.0), Block.box((double)13.25, (double)7.5, (double)9.25, (double)14.25, (double)9.5, (double)11.25), Block.box((double)13.25, (double)7.5, (double)6.75, (double)14.25, (double)9.5, (double)8.75), Block.box((double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)6.0), Block.box((double)0.0, (double)3.5, (double)3.0, (double)2.0, (double)5.5, (double)6.0), Block.box((double)13.5, (double)8.0, (double)7.25, (double)15.5, (double)9.0, (double)8.25), Block.box((double)13.5, (double)8.0, (double)9.75, (double)15.5, (double)9.0, (double)10.75), Block.box((double)14.5, (double)1.0, (double)7.25, (double)15.5, (double)8.0, (double)8.25), Block.box((double)14.5, (double)1.0, (double)9.75, (double)15.5, (double)8.0, (double)10.75), Block.box((double)0.5, (double)1.0, (double)3.5, (double)2.5, (double)4.0, (double)5.5), Block.box((double)14.5, (double)11.0, (double)1.5, (double)15.5, (double)12.0, (double)14.5));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public RefineryOutputBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        return world.getBlockEntity(pos, ModBlockEntityTypes.REFINERY_OUTPUT.get()).map(te -> {
            boolean canTransferFluid = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.getItemInHand(hand), (int)1)).map(heldHandler -> FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)brtr.getDirection()).map(refineryHandler -> this.couldTransferFluidOut((IFluidHandler)heldHandler, (IFluidHandler)refineryHandler)).orElse(false)).orElse(false);
            if (canTransferFluid) {
                return super.use(state, world, pos, player, hand, brtr);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                RefineryControllerBlockEntity master = te.getRefineryController();
                if (master != null) {
                    sp.openMenu((MenuProvider)master, master.getBlockPos());
                }
            }
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    private boolean couldTransferFluidOut(IFluidHandler h1, IFluidHandler h2) {
        FluidStack f = FluidUtil.tryFluidTransfer((IFluidHandler)h1, (IFluidHandler)h2, (int)1000, (boolean)false);
        return !f.isEmpty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        int nOutputs = 0;
        int up = 1;
        int down = 1;
        while (worldIn.getBlockState(pos.above(up++)).getBlock() instanceof RefineryOutputBlock) {
            ++nOutputs;
        }
        while (worldIn.getBlockState(pos.below(down++)).getBlock() instanceof RefineryOutputBlock) {
            ++nOutputs;
        }
        return nOutputs < 4 && super.canSurvive(state, worldIn, pos);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!worldIn.isClientSide() && facingState.getBlock() == ModBlocks.REFINERY_OUTPUT.get()) {
            this.recache(worldIn, currentPos);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private void recache(LevelAccessor world, BlockPos pos) {
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, RefineryOutputBlockEntity.class).ifPresent(te -> {
            RefineryControllerBlockEntity teC = te.getRefineryController();
            if (teC != null) {
                teC.clearOutputCache();
            }
        });
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RefineryOutputBlockEntity(pPos, pState);
    }
}

