/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SecurityStationBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N = VoxelShapeUtils.or(Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)10.0, (double)9.0, (double)11.0, (double)11.0, (double)15.0), Block.box((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)11.0, (double)7.0), Block.box((double)12.0, (double)10.0, (double)11.0, (double)15.0, (double)11.0, (double)15.0), Block.box((double)12.25, (double)10.0, (double)7.0, (double)12.75, (double)10.5, (double)11.0), Block.box((double)9.25, (double)10.0, (double)7.0, (double)9.75, (double)10.5, (double)9.0), Block.box((double)3.0, (double)10.5, (double)2.0, (double)13.0, (double)14.5, (double)4.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), Block.box((double)13.25, (double)10.0, (double)7.0, (double)13.75, (double)10.5, (double)11.0));
    private static final VoxelShape SHAPE_E = VoxelShapeUtils.rotateY(SHAPE_N, 90);
    private static final VoxelShape SHAPE_S = VoxelShapeUtils.rotateY(SHAPE_E, 90);
    private static final VoxelShape SHAPE_W = VoxelShapeUtils.rotateY(SHAPE_S, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_S, SHAPE_W, SHAPE_N, SHAPE_E};

    public SecurityStationBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return SHAPES[d.get2DDataValue()];
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entityLiving, ItemStack iStack) {
        if (entityLiving instanceof Player) {
            Player p = (Player)entityLiving;
            world.getBlockEntity(pos, ModBlockEntityTypes.SECURITY_STATION.get()).ifPresent(teSS -> teSS.sharedUsers.add(p.getGameProfile()));
        }
        super.setPlacedBy(world, pos, state, entityLiving, iStack);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SecurityStationBlockEntity) {
                SecurityStationBlockEntity secStation = (SecurityStationBlockEntity)blockEntity;
                if (secStation.isPlayerOnWhiteList(player)) {
                    return super.use(state, world, pos, player, hand, brtr);
                }
                if (!secStation.hasValidNetwork()) {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.outOfOrder", new Object[0]).withStyle(ChatFormatting.RED), false);
                } else if (secStation.hasPlayerHacked(player)) {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.alreadyHacked", new Object[0]).withStyle(ChatFormatting.GOLD), false);
                } else if (this.getPlayerHackLevel(player) < secStation.getSecurityLevel()) {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.cantHack", new Object[0]).withStyle(ChatFormatting.GOLD), false);
                    player.hurt(player.damageSources().fellOutOfWorld(), 1.0f);
                } else if (((Boolean)ConfigHelper.common().machines.securityStationAllowHacking.get()).booleanValue()) {
                    secStation.initiateHacking(sp);
                } else {
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackDisabled", new Object[0]).withStyle(ChatFormatting.GOLD), false);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getPlayerHackLevel(Player player) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.isArmorReady(EquipmentSlot.HEAD) && handler.getArmorPressure(EquipmentSlot.HEAD) > 0.0f ? handler.getUpgradeCount(EquipmentSlot.HEAD, ModUpgrades.SECURITY.get()) : 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntityTypes.SECURITY_STATION.get()).map(teSS -> teSS.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SecurityStationBlockEntity(pPos, pState);
    }
}

