/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.SentryTurretBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SentryTurretBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock {
    private final VoxelShape BOUNDS = Stream.of(Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)0.0, (double)3.5, (double)14.0, (double)2.0, (double)4.5, (double)16.0), Block.box((double)0.5, (double)3.0, (double)14.5, (double)1.5, (double)4.0, (double)15.5), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)3.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)14.5, (double)3.0, (double)14.5, (double)15.5, (double)4.0, (double)15.5), Block.box((double)14.0, (double)3.5, (double)14.0, (double)16.0, (double)4.5, (double)16.0), Block.box((double)0.5, (double)3.0, (double)0.5, (double)1.5, (double)4.0, (double)1.5), Block.box((double)0.0, (double)3.5, (double)0.0, (double)2.0, (double)4.5, (double)2.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.box((double)14.5, (double)3.0, (double)0.5, (double)15.5, (double)4.0, (double)1.5), Block.box((double)14.0, (double)3.5, (double)0.0, (double)16.0, (double)4.5, (double)2.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public SentryTurretBlock() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return this.BOUNDS;
    }

    @Override
    public void addExtraInformation(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null && tag.contains("entityFilter", 8)) {
            curInfo.add((Component)Component.translatable((String)"pneumaticcraft.gui.entityFilter").append(": " + tag.getString("entityFilter")).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(world, pos, state, entity, stack);
        world.getBlockEntity(pos, ModBlockEntityTypes.SENTRY_TURRET.get()).ifPresent(te -> te.setIdleYaw(entity.getViewYRot(0.0f)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SentryTurretBlockEntity(pPos, pState);
    }
}

