/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.spawning.VacuumTrapBlockEntity;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class VacuumTrapBlock
extends AbstractPneumaticCraftBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock {
    private static final VoxelShape SHAPE_N_OPEN = VoxelShapeUtils.or(Block.box((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)11.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)1.0, (double)15.0), Block.box((double)7.0, (double)12.0, (double)14.0, (double)9.0, (double)14.0, (double)16.0), Block.box((double)6.0, (double)11.0, (double)14.0, (double)10.0, (double)12.0, (double)16.0), Block.box((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)12.0, (double)2.0), Block.box((double)7.0, (double)14.0, (double)8.0, (double)9.0, (double)16.0, (double)16.0), Block.box((double)11.0, (double)11.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0), Block.box((double)0.0, (double)11.0, (double)2.0, (double)5.0, (double)12.0, (double)14.0));
    private static final VoxelShape SHAPE_E_OPEN = VoxelShapeUtils.rotateY(SHAPE_N_OPEN, 90);
    private static final VoxelShape SHAPE_S_OPEN = VoxelShapeUtils.rotateY(SHAPE_E_OPEN, 90);
    private static final VoxelShape SHAPE_W_OPEN = VoxelShapeUtils.rotateY(SHAPE_S_OPEN, 90);
    private static final VoxelShape[] SHAPES_OPEN = new VoxelShape[]{SHAPE_S_OPEN, SHAPE_W_OPEN, SHAPE_N_OPEN, SHAPE_E_OPEN};
    private static final VoxelShape SHAPE_N_CLOSED = VoxelShapeUtils.or(Block.box((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)11.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)1.0, (double)15.0), Block.box((double)7.0, (double)12.0, (double)14.0, (double)9.0, (double)14.0, (double)16.0), Block.box((double)6.0, (double)11.0, (double)14.0, (double)10.0, (double)12.0, (double)16.0), Block.box((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)12.0, (double)2.0), Block.box((double)7.0, (double)14.0, (double)8.0, (double)9.0, (double)16.0, (double)16.0), Block.box((double)8.0, (double)11.0, (double)2.0, (double)13.0, (double)12.0, (double)14.0), Block.box((double)3.0, (double)11.0, (double)2.0, (double)8.0, (double)12.0, (double)14.0));
    private static final VoxelShape SHAPE_E_CLOSED = VoxelShapeUtils.rotateY(SHAPE_N_CLOSED, 90);
    private static final VoxelShape SHAPE_S_CLOSED = VoxelShapeUtils.rotateY(SHAPE_E_CLOSED, 90);
    private static final VoxelShape SHAPE_W_CLOSED = VoxelShapeUtils.rotateY(SHAPE_S_CLOSED, 90);
    private static final VoxelShape[] SHAPES_CLOSED = new VoxelShape[]{SHAPE_S_CLOSED, SHAPE_W_CLOSED, SHAPE_N_CLOSED, SHAPE_E_CLOSED};

    public VacuumTrapBlock() {
        super(ModBlocks.defaultProps());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.OPEN, BlockStateProperties.POWERED, NORTH, SOUTH, EAST, WEST, DOWN});
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            return SHAPES_OPEN[((Direction)state.getValue((Property)this.directionProperty())).get2DDataValue()];
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            return SHAPES_CLOSED[((Direction)state.getValue((Property)this.directionProperty())).get2DDataValue()];
        }
        return super.getShape(state, worldIn, pos, context);
    }

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (player.isShiftKeyDown()) {
            boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(!open)));
            world.playSound(player, pos, open ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 0.5f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.use(state, world, pos, player, hand, brtr);
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered = world.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)BlockStateProperties.POWERED)) {
            if ((Boolean)state.getValue((Property)BlockStateProperties.OPEN) != powered) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(powered));
                world.playSound(null, pos, powered ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 0.5f);
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new VacuumTrapBlockEntity(pPos, pState);
    }

    public static class ItemBlockVacuumTrap
    extends BlockItem {
        public ItemBlockVacuumTrap(VacuumTrapBlock blockVacuumTrap) {
            super((Block)blockVacuumTrap, ModItems.defaultProps());
        }

        public void appendHoverText(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            super.appendHoverText(stack, worldIn, tooltip, flagIn);
            CompoundTag tag = stack.getTagElement("BlockEntityTag");
            if (tag != null && tag.contains("Items")) {
                ItemStackHandler handler = new ItemStackHandler(1);
                handler.deserializeNBT(tag.getCompound("Items"));
                if (handler.getStackInSlot(0).getItem() instanceof SpawnerCoreItem) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.vacuum_trap.coreInstalled", new Object[0]).withStyle(ChatFormatting.YELLOW));
                }
            }
        }
    }
}

