/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallLampBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_UP = VoxelShapeUtils.or(Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.box((double)6.15, (double)2.25, (double)4.75, (double)6.65, (double)3.5, (double)11.25), Block.box((double)5.0, (double)2.25, (double)5.0, (double)11.0, (double)3.25, (double)11.0), Block.box((double)4.75, (double)1.25, (double)4.75, (double)11.25, (double)2.5, (double)11.25), Block.box((double)9.35, (double)2.25, (double)4.75, (double)9.85, (double)3.5, (double)11.25), Block.box((double)4.75, (double)2.25, (double)9.35, (double)11.25, (double)3.5, (double)9.85), Block.box((double)4.75, (double)2.25, (double)6.15, (double)11.25, (double)3.5, (double)6.65));
    private static final VoxelShape SHAPE_NORTH = VoxelShapeUtils.rotateX(SHAPE_UP, 270);
    private static final VoxelShape SHAPE_DOWN = VoxelShapeUtils.rotateX(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeUtils.rotateX(SHAPE_UP, 90);
    private static final VoxelShape SHAPE_WEST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_EAST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_DOWN, SHAPE_UP, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_WEST, SHAPE_EAST};
    private static final int[] COLORS_ON = new int[DyeColor.values().length];
    private static final int[] COLORS_OFF = new int[DyeColor.values().length];
    private final DyeColor color;
    private final boolean inverted;

    public WallLampBlock(DyeColor color, boolean inverted) {
        super(ModBlocks.defaultProps().lightLevel(WallLampBlock.getLightValue()));
        this.color = color;
        this.inverted = inverted;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(inverted)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)this.directionProperty())).get3DDataValue()];
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() && !this.shouldLight((Level)worldIn, pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)BlockStateProperties.LIT), 2);
        }
    }

    @Override
    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isLit;
        if (!worldIn.isClientSide && (isLit = ((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) != this.shouldLight(worldIn, pos)) {
            if (isLit) {
                worldIn.scheduleTick(pos, (Block)this, 4);
            } else {
                worldIn.setBlock(pos, (BlockState)state.cycle((Property)BlockStateProperties.LIT), 2);
            }
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.setValue((Property)this.directionProperty(), (Comparable)context.getClickedFace())).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.shouldLight(context.getLevel(), context.getClickedPos())));
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getRotation(stateIn).getOpposite() == facing && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)worldIn, (BlockPos)pos, (Direction)this.getRotation(state).getOpposite());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && state != null) {
            return (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? COLORS_ON[this.color.getId()] : COLORS_OFF[this.color.getId()];
        }
        return -1;
    }

    private boolean shouldLight(Level world, BlockPos pos) {
        return this.inverted != world.hasNeighborSignal(pos);
    }

    private static ToIntFunction<BlockState> getLightValue() {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0;
    }

    static {
        for (DyeColor c : DyeColor.values()) {
            float[] cols = c.getTextureDiffuseColors();
            TintColor tc = new TintColor(cols[0], cols[1], cols[2], 1.0f);
            WallLampBlock.COLORS_ON[c.getId()] = tc.getRGB();
            WallLampBlock.COLORS_OFF[c.getId()] = tc.darker().getRGB();
        }
    }

    public static class ItemWallLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemWallLamp(WallLampBlock blockWallLamp) {
            super((Block)blockWallLamp, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            Block block = this.getBlock();
            if (block instanceof WallLampBlock) {
                WallLampBlock bwl = (WallLampBlock)block;
                return bwl.inverted ? "block.pneumaticcraft.wall_lamp_inverted" : "block.pneumaticcraft.wall_lamp";
            }
            return "block.pneumaticcraft.wall_lamp";
        }
    }
}

