/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractAirHandlingBlockEntity
extends AbstractTickingBlockEntity {
    @GuiSynced
    protected final IAirHandlerMachine airHandler;
    private final Map<IAirHandlerMachine, EnumSet<Direction>> airHandlerMap = new IdentityHashMap<IAirHandlerMachine, EnumSet<Direction>>();

    public AbstractAirHandlingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier pressureTier, int volume, int upgradeSlots) {
        super(type, pos, state, upgradeSlots);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(pressureTier, volume);
    }

    @Nullable
    public IAirHandlerMachine getAirHandler(Direction side) {
        return side == null || this.canConnectPneumatic(side) ? this.airHandler : null;
    }

    public boolean canConnectPneumatic(Direction side) {
        return true;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.initializeHullAirHandlers();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.initializeHullAirHandlers();
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.airHandlerMap.keySet().forEach(handler -> handler.tick(this));
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.airHandlerMap.keySet().forEach(h -> {
            h.setVolumeUpgrades(this.getUpgrades(ModUpgrades.VOLUME.get()));
            this.handleSecurityUpgrade((IAirHandlerMachine)h);
        });
    }

    private void handleSecurityUpgrade(IAirHandlerMachine handler) {
        if (this.getUpgrades(ModUpgrades.SECURITY.get()) > 0) {
            handler.enableSafetyVenting(p -> p > this.getDangerPressure(), Direction.UP);
        } else {
            handler.disableSafetyVenting();
        }
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.initializeHullAirHandlers();
        this.airHandlerMap.keySet().forEach(h -> h.setSideLeaking(null));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.airHandler.deserializeNBT((Tag)tag.getCompound("AirHandler"));
        this.airHandler.setVolumeUpgrades(this.getUpgrades(ModUpgrades.VOLUME.get()));
        if (tag.contains("AirAmount")) {
            this.airHandler.addAir(tag.getInt("AirAmount"));
        }
    }

    public void initializeHullAirHandlers() {
        this.invalidateCapabilities();
        this.airHandlerMap.clear();
        for (Direction side : DirectionUtil.VALUES) {
            IAirHandlerMachine h = this.getAirHandler(side);
            if (h == null) continue;
            this.airHandlerMap.computeIfAbsent(h, k -> EnumSet.noneOf(Direction.class)).add(side);
        }
        this.airHandlerMap.forEach(IAirHandlerMachine::setConnectableFaces);
    }

    public void initializeHullAirHandlerClient(Direction dir, IAirHandlerMachine handler) {
        this.airHandlerMap.clear();
        EnumSet<Direction> l = EnumSet.of(dir);
        this.airHandlerMap.put(handler, l);
        handler.setConnectableFaces(l);
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.initializeHullAirHandlers();
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.put("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.airHandler.deserializeNBT((Tag)tag.getCompound("AirHandler"));
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("getPressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 0, 1, "face (down/up/north/south/west/east)");
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(AbstractAirHandlingBlockEntity.this.airHandler.getPressure())};
                }
                IAirHandlerMachine handler = (IAirHandlerMachine)AbstractAirHandlingBlockEntity.this.level.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE, AbstractAirHandlingBlockEntity.this.getBlockPos(), (Object)this.getDirForString((String)args[0]));
                return new Object[]{Float.valueOf(handler == null ? 0.0f : handler.getPressure())};
            }
        });
        AbstractAirHandlingBlockEntity abstractAirHandlingBlockEntity = this;
        if (abstractAirHandlingBlockEntity instanceof IMinWorkingPressure) {
            final IMinWorkingPressure mwp = (IMinWorkingPressure)((Object)abstractAirHandlingBlockEntity);
            registry.registerLuaMethod(new LuaMethod("getMinWorkingPressure"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireNoArgs(args);
                    return new Object[]{Float.valueOf(mwp.getMinWorkingPressure())};
                }
            });
        }
        registry.registerLuaMethod(new LuaConstant("getDangerPressure", this.getDangerPressure()));
        registry.registerLuaMethod(new LuaConstant("getCriticalPressure", this.getCriticalPressure()));
        registry.registerLuaMethod(new LuaConstant("getDefaultVolume", this.getDefaultVolume()));
    }

    public float getPressure() {
        return this.airHandler.getPressure();
    }

    public float getDangerPressure() {
        return this.airHandler.getDangerPressure();
    }

    public float getCriticalPressure() {
        return this.airHandler.getCriticalPressure();
    }

    public void addAir(int air) {
        this.airHandler.addAir(air);
    }

    public int getDefaultVolume() {
        return this.airHandler.getBaseVolume();
    }

    public boolean hasNoConnectedAirHandlers() {
        return this.airHandler.getConnectedAirHandlers(this).isEmpty();
    }
}

