/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.entity.CachedTileNeighbours;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradeCache;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class AbstractPneumaticCraftBlockEntity
extends BlockEntity
implements Nameable,
IGUIButtonSensitive,
IDescSynced,
IUpgradeHolder,
ILuaMethodProvider {
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private final UpgradeHandler upgradeHandler;
    private List<SyncedField<?>> descriptionFields;
    private final CachedTileNeighbours neighbourCache = new CachedTileNeighbours(this);
    private boolean preserveStateOnBreak = false;
    private float actualSpeedMult = 1.5f;
    private float actualUsageMult = 1.65f;
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private Component customName = null;
    private boolean forceFullSync;
    private BitSet fieldsToSync;

    public AbstractPneumaticCraftBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        this(type, pos, state, 0);
    }

    public AbstractPneumaticCraftBlockEntity(BlockEntityType type, BlockPos pos, BlockState state, int upgradeSize) {
        super(type, pos, state);
        this.upgradeHandler = new UpgradeHandler(upgradeSize);
    }

    @Nonnull
    public Level nonNullLevel() {
        return Objects.requireNonNull(super.getLevel());
    }

    private String getBlockTranslationKey() {
        String key = BuiltInRegistries.BLOCK_ENTITY_TYPE.getResourceKey((Object)this.getType()).map(rk -> rk.location().getPath()).orElse("unknown");
        return "block.pneumaticcraft." + key;
    }

    public Component getName() {
        return this.customName == null ? Component.translatable((String)this.getBlockTranslationKey()) : this.customName;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public CompoundTag getUpdateTag() {
        CompoundTag compound = super.getUpdateTag();
        return PacketDescription.create(this, true).writeNBT(compound);
    }

    public void handleUpdateTag(CompoundTag tag) {
        PacketDescription.fromNBT(tag).processPacket(this);
    }

    @Override
    public BlockPos getPosition() {
        return this.getBlockPos();
    }

    @Override
    public boolean shouldSyncField(int idx) {
        return this.fieldsToSync.get(idx);
    }

    @Override
    public List<SyncedField<?>> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            this.fieldsToSync = new BitSet(this.descriptionFields.size());
            for (int i = 0; i < this.descriptionFields.size(); ++i) {
                SyncedField<?> field = this.descriptionFields.get(i);
                if (!field.update()) continue;
                this.fieldsToSync.set(i);
            }
        }
        return this.descriptionFields;
    }

    public final void sendDescriptionPacket() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        PacketDescription descPacket = PacketDescription.create(this, this.forceFullSync);
        if (descPacket.hasData()) {
            NetworkHandler.sendToAllTracking((CustomPacketPayload)descPacket, this);
        }
        this.fieldsToSync.clear();
        this.forceFullSync = false;
    }

    protected void scheduleDescriptionPacket() {
        this.forceFullSync = true;
    }

    void defaultServerTick() {
        if (!this.nonNullLevel().isClientSide) {
            IHeatExchangingTE he;
            IHeatExchangerLogic logic;
            AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
            if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
                logic.tick();
            }
            if ((abstractPneumaticCraftBlockEntity = this) instanceof IAutoFluidEjecting) {
                IAutoFluidEjecting ejector = (IAutoFluidEjecting)((Object)abstractPneumaticCraftBlockEntity);
                if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
                    ejector.autoExportFluid(this);
                }
            }
            for (int i = 0; i < this.getDescriptionFields().size(); ++i) {
                if (!this.getDescriptionFields().get(i).update()) continue;
                this.fieldsToSync.set(i);
            }
            if (this.forceFullSync || !this.fieldsToSync.isEmpty()) {
                this.sendDescriptionPacket();
            }
        }
    }

    public void setChanged() {
        if (this.level != null) {
            if (this.level.isLoaded(this.worldPosition)) {
                this.level.getChunkAt(this.worldPosition).setUnsaved(true);
            }
            if (this instanceof IComparatorSupport && !this.getBlockState().isAir()) {
                this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
            }
        }
    }

    public void onLoad() {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity);
            he.initializeHullHeatExchangers(this.level, this.worldPosition);
        }
    }

    protected void updateNeighbours() {
        if (this.level != null) {
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public void onBlockRotated() {
        if (!this.nonNullLevel().isClientSide) {
            PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(this.level, this.worldPosition);
        }
        this.invalidateCapabilities();
    }

    protected void forceBlockEntityRerender() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return this instanceof CamouflageableBlockEntity;
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        if (this instanceof ISideConfigurable) {
            tag.put("SideConfiguration", (Tag)SideConfigurator.writeToNBT((ISideConfigurable)((Object)this)));
        }
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        if (this instanceof ISideConfigurable) {
            SideConfigurator.readFromNBT(tag.getCompound("SideConfiguration"), (ISideConfigurable)((Object)this));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        IHeatExchangingTE he;
        IHeatExchangerLogic logic;
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity;
        super.saveAdditional(tag);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
        if (this.getUpgradeHandler().getSlots() > 0) {
            tag.put("UpgradeInventory", (Tag)this.getUpgradeHandler().serializeNBT());
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
            tag.put("HeatExchanger", (Tag)logic.serializeNBT());
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().serialize(tag);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof ISerializableTanks) {
            ISerializableTanks st = (ISerializableTanks)((Object)abstractPneumaticCraftBlockEntity);
            tag.put("SavedTanks", (Tag)st.serializeTanks());
        }
        this.writeToPacket(tag);
    }

    public void load(CompoundTag tag) {
        IHeatExchangingTE he;
        IHeatExchangerLogic logic;
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity;
        super.load(tag);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
        if (tag.contains("UpgradeInventory") && this.getUpgradeHandler() != null) {
            this.getUpgradeHandler().deserializeNBT(tag.getCompound("UpgradeInventory"));
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
            logic.deserializeNBT(tag.getCompound("HeatExchanger"));
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().deserialize(tag);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof ISerializableTanks) {
            ISerializableTanks st = (ISerializableTanks)((Object)abstractPneumaticCraftBlockEntity);
            st.deserializeTanks(tag.getCompound("SavedTanks"));
        }
        this.readFromPacket(tag);
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.forceBlockEntityRerender();
            if (this instanceof CamouflageableBlockEntity) {
                this.requestModelDataUpdate();
            }
        }
    }

    @Nonnull
    public ModelData getModelData() {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof CamouflageableBlockEntity) {
            CamouflageableBlockEntity c = (CamouflageableBlockEntity)((Object)abstractPneumaticCraftBlockEntity);
            return ModelData.builder().with(AbstractCamouflageBlock.BLOCK_ACCESS, (Object)this.level).with(AbstractCamouflageBlock.BLOCK_POS, (Object)this.worldPosition).with(AbstractCamouflageBlock.CAMO_STATE, (Object)c.getCamouflage()).build();
        }
        return super.getModelData();
    }

    public void onGuiUpdate() {
    }

    public Direction getRotation() {
        Direction direction;
        BlockState state = this.getBlockState();
        Block block = state.getBlock();
        if (block instanceof AbstractPneumaticCraftBlock) {
            AbstractPneumaticCraftBlock b = (AbstractPneumaticCraftBlock)block;
            direction = b.getRotation(state);
        } else {
            direction = Direction.NORTH;
        }
        return direction;
    }

    public int getUpgrades(PNCUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    public float getSpeedMultiplierFromUpgrades() {
        return this.actualSpeedMult;
    }

    public float getSpeedUsageMultiplierFromUpgrades() {
        return this.actualUsageMult;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
    }

    public boolean isGuiUseableByPlayer(Player player) {
        return this.level != null && this.level.getBlockEntity(this.getBlockPos()) == this && player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.getBlockPos())) <= 64.0;
    }

    public BlockEntity getCachedNeighbor(Direction dir) {
        if (this.level == null) {
            return null;
        }
        return this.level.isClientSide ? this.level.getBlockEntity(this.worldPosition.relative(dir)) : this.neighbourCache.getCachedNeighbour(dir);
    }

    public void onNeighborTileUpdate(BlockPos tilePos) {
    }

    public void onNeighborBlockUpdate(BlockPos fromPos) {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity);
            he.initializeHullHeatExchangers(this.level, this.worldPosition);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().updateRedstonePower();
        }
        this.neighbourCache.purge();
    }

    protected void processFluidItem(int inputSlot, int outputSlot) {
        IOHelper.getInventoryForBlock(this).ifPresent(itemHandler -> {
            ItemStack inputStack = itemHandler.getStackInSlot(inputSlot);
            ItemStack outputStack = itemHandler.getStackInSlot(outputSlot);
            FluidUtil.getFluidHandler((ItemStack)inputStack).ifPresent(fluidHandlerItem -> {
                FluidStack itemContents = fluidHandlerItem.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                IOHelper.getFluidHandlerForBlock(this).ifPresent(fluidHandler -> {
                    if (!itemContents.isEmpty() && (outputStack.isEmpty() || ItemHandlerHelper.canItemStacksStack((ItemStack)inputStack.getItem().getCraftingRemainingItem(inputStack), (ItemStack)outputStack))) {
                        if (inputStack.getCount() != 1) {
                            return;
                        }
                        FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)fluidHandlerItem, (int)itemContents.getAmount(), (boolean)true);
                        if (transferred.getAmount() == itemContents.getAmount()) {
                            ItemStack emptyContainerStack = fluidHandlerItem.getContainer();
                            ItemStack excess = itemHandler.insertItem(outputSlot, emptyContainerStack, true);
                            if (excess.isEmpty()) {
                                itemHandler.extractItem(inputSlot, 1, false);
                                itemHandler.insertItem(outputSlot, emptyContainerStack, false);
                            }
                        } else if (!transferred.isEmpty()) {
                            itemHandler.extractItem(inputSlot, 1, false);
                            itemHandler.insertItem(inputSlot, fluidHandlerItem.getContainer().copy(), false);
                        }
                    } else if (itemHandler.getStackInSlot(outputSlot).isEmpty()) {
                        ItemStack workStack = ItemHandlerHelper.copyStackWithSize((ItemStack)inputStack, (int)1);
                        IOHelper.getFluidHandlerForItem(workStack).ifPresent(workHandler -> {
                            FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)workHandler, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true);
                            if (!transferred.isEmpty()) {
                                itemHandler.extractItem(inputSlot, 1, false);
                                ItemStack filledContainerStack = workHandler.getContainer();
                                itemHandler.insertItem(outputSlot, filledContainerStack, false);
                            }
                        });
                    }
                });
            });
        });
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        if (this instanceof IHeatExchangingTE) {
            registry.registerLuaMethod(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireArgs(args, 0, 1, "face? (down/up/north/south/west/east)");
                    Direction dir = args.length == 0 ? null : this.getDirForString((String)args[0]);
                    IHeatExchangerLogic logic = ((IHeatExchangingTE)((Object)AbstractPneumaticCraftBlockEntity.this)).getHeatExchanger(dir);
                    double temp = logic == null ? HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)AbstractPneumaticCraftBlockEntity.this.level, AbstractPneumaticCraftBlockEntity.this.worldPosition) : logic.getTemperature();
                    return new Object[]{temp};
                }
            });
        }
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getResourceKey((Object)this.getType()).map(rk -> rk.location().toString()).orElse("unknown");
    }

    public boolean hasItemCapability() {
        return true;
    }

    public boolean hasFluidCapability() {
        return false;
    }

    public boolean hasEnergyCapability() {
        return false;
    }

    public final IItemHandler getItemHandler() {
        return this.getItemHandler(null);
    }

    public final IFluidHandler getFluidHandler() {
        return this.getFluidHandler(null);
    }

    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return null;
    }

    public IEnergyStorage getEnergyHandler(@Nullable Direction dir) {
        return null;
    }

    public UpgradeHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public BlockCapabilityCache<IItemHandler, Direction> createItemHandlerCache(Direction dir) {
        BlockCapabilityCache blockCapabilityCache;
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockCapabilityCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite(), () -> !this.isRemoved(), () -> {});
        } else {
            blockCapabilityCache = null;
        }
        return blockCapabilityCache;
    }

    public BlockCapabilityCache<IFluidHandler, Direction> createFluidHandlerCache(Direction dir) {
        BlockCapabilityCache blockCapabilityCache;
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockCapabilityCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getBlockPos().relative(dir), (Object)dir.getOpposite(), () -> !this.isRemoved(), () -> {});
        } else {
            blockCapabilityCache = null;
        }
        return blockCapabilityCache;
    }

    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        CamouflageableBlockEntity c;
        BlockState camoState;
        AbstractPneumaticCraftBlockEntity i2;
        PneumaticCraftUtils.collectNonEmptyItems(this.getItemHandler(), drops);
        if (!this.shouldPreserveStateOnBreak()) {
            UpgradeHandler uh = this.getUpgradeHandler();
            for (int i2 = 0; i2 < uh.getSlots(); ++i2) {
                if (uh.getStackInSlot(i2).isEmpty()) continue;
                drops.add((Object)uh.getStackInSlot(i2));
            }
        }
        if ((i2 = this) instanceof CamouflageableBlockEntity && (camoState = (c = (CamouflageableBlockEntity)((Object)i2)).getCamouflage()) != null) {
            drops.add((Object)CamouflageableBlockEntity.getStackForState(camoState));
        }
    }

    public boolean shouldPreserveStateOnBreak() {
        return this.preserveStateOnBreak;
    }

    public void setPreserveStateOnBreak(boolean preserveStateOnBreak) {
        this.preserveStateOnBreak = preserveStateOnBreak;
    }

    public String getCurrentRecipeIdSynced() {
        return "";
    }

    @Override
    public void onUpgradesChanged() {
        this.actualSpeedMult = (float)Math.pow((Double)ConfigHelper.common().machines.speedUpgradeSpeedMultiplier.get(), Math.min(10, this.getUpgrades(ModUpgrades.SPEED.get())));
        this.actualUsageMult = (float)Math.pow((Double)ConfigHelper.common().machines.speedUpgradeUsageMultiplier.get(), Math.min(10, this.getUpgrades(ModUpgrades.SPEED.get())));
    }

    public UpgradeCache getUpgradeCache() {
        return this.upgradeCache;
    }

    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
    }

    public int countPlayersUsing() {
        return (int)this.nonNullLevel().players().stream().filter(player -> player.containerMenu instanceof AbstractPneumaticCraftMenu).filter(player -> ((AbstractPneumaticCraftMenu)player.containerMenu).blockEntity == this).count();
    }

    public void requestModelDataUpdate() {
        if (this.level != null && this.level.isClientSide && this.level == ClientUtils.getClientLevel()) {
            this.level.getModelDataManager().requestRefresh((BlockEntity)this);
        }
    }

    public class UpgradeHandler
    extends BaseItemStackHandler {
        UpgradeHandler(int upgradeSize) {
            super(AbstractPneumaticCraftBlockEntity.this, upgradeSize);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            PNCUpgrade upgrade = PNCUpgrade.from(stack);
            if (upgrade == null) {
                return 0;
            }
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.te, upgrade);
        }

        private boolean isUnique(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || PNCUpgrade.from(stack) != PNCUpgrade.from(this.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        private boolean isApplicable(ItemStack stack) {
            PNCUpgrade upgrade = PNCUpgrade.from(stack);
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(AbstractPneumaticCraftBlockEntity.this, upgrade) > 0;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AbstractPneumaticCraftBlockEntity.this.upgradeCache.invalidateCache();
        }
    }
}

