/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.Validate;

public class RedstoneController<T extends BlockEntity> {
    private static final Pattern RS_TAG_PATTERN = Pattern.compile("^redstone:(\\d+)$");
    private final WeakReference<T> teRef;
    private final List<RedstoneMode<T>> modes;
    @GuiSynced
    private int currentMode;
    @GuiSynced
    private int currentRedstonePower = -1;

    public RedstoneController(T te) {
        this.teRef = new WeakReference<T>(te);
        this.modes = new StandardReceivingModes().modes();
    }

    public RedstoneController(T te, List<RedstoneMode<T>> modes) {
        Validate.isTrue((modes.size() >= 2 ? 1 : 0) != 0, (String)"must have at least 2 modes!", (Object[])new Object[0]);
        this.teRef = new WeakReference<T>(te);
        this.modes = modes;
    }

    public int getModeCount() {
        return this.modes.size();
    }

    public RedstoneMode<T> getModeDetails(int idx) {
        return this.modes.get(idx);
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        if (currentMode != this.currentMode && currentMode >= 0 && currentMode < this.modes.size()) {
            this.currentMode = currentMode;
            BlockEntity te = (BlockEntity)this.teRef.get();
            if (te != null) {
                ((IRedstoneControl)te).onRedstoneModeChanged(this.currentMode);
                te.setChanged();
            }
        }
    }

    public int getCurrentRedstonePower() {
        if (this.currentRedstonePower < 0) {
            this.updateRedstonePower();
        }
        return this.currentRedstonePower;
    }

    public boolean shouldRun() {
        BlockEntity te = (BlockEntity)this.teRef.get();
        return te != null && this.modes.get((int)this.currentMode).runPredicate.test(te);
    }

    public boolean shouldEmit() {
        BlockEntity te = (BlockEntity)this.teRef.get();
        return te != null && this.modes.get((int)this.currentMode).emissionPredicate.test(te);
    }

    public void serialize(CompoundTag tag) {
        if (this.currentMode != 0) {
            tag.putInt("redstoneMode", this.currentMode);
        }
    }

    public void deserialize(CompoundTag tag) {
        this.currentMode = tag.getInt("redstoneMode");
    }

    public boolean parseRedstoneMode(String tag) {
        Matcher m = RS_TAG_PATTERN.matcher(tag);
        if (m.matches() && m.groupCount() == 1) {
            this.setCurrentMode(Integer.parseInt(m.group(1)));
            return true;
        }
        return false;
    }

    public void updateRedstonePower() {
        BlockEntity te = (BlockEntity)this.teRef.get();
        if (te != null) {
            this.currentRedstonePower = Objects.requireNonNull(te.getLevel()).getBestNeighborSignal(te.getBlockPos());
        }
    }

    public boolean isEmitter() {
        return !this.modes.isEmpty() && this.modes.get(0) instanceof EmittingRedstoneMode;
    }

    public Component getRedstoneTabTitle() {
        BlockEntity te = (BlockEntity)this.teRef.get();
        return te != null ? ((IRedstoneControl)te).getRedstoneTabTitle() : Component.empty();
    }

    public Component getDescription() {
        BlockEntity te = (BlockEntity)this.teRef.get();
        if (te != null) {
            return ((IRedstoneControl)te).getRedstoneTabTitle().append(": ").append((Component)PneumaticCraftUtils.xlate(this.modes.get(this.currentMode).getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        return Component.empty();
    }

    private static class StandardReceivingModes<T extends BlockEntity> {
        private StandardReceivingModes() {
        }

        public List<RedstoneMode<T>> modes() {
            return ImmutableList.of(new ReceivingRedstoneMode<BlockEntity>("standard.always", new ItemStack((ItemLike)Items.GUNPOWDER), te -> true), new ReceivingRedstoneMode<BlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.REDSTONE), te -> ((IRedstoneControl)te).getCurrentRedstonePower() > 0), new ReceivingRedstoneMode<BlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.REDSTONE_TORCH), te -> ((IRedstoneControl)te).getCurrentRedstonePower() == 0));
        }
    }

    public static abstract class RedstoneMode<T extends BlockEntity> {
        private final String id;
        private final Either<ItemStack, ResourceLocation> texture;
        private final Predicate<T> runPredicate;
        private final Predicate<T> emissionPredicate;

        public RedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.left((Object)stackIcon), runPredicate, emissionPredicate);
        }

        public RedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this(id, (Either<ItemStack, ResourceLocation>)Either.right((Object)texture), runPredicate, emissionPredicate);
        }

        private RedstoneMode(String id, Either<ItemStack, ResourceLocation> texture, Predicate<T> runPredicate, Predicate<T> emissionPredicate) {
            this.id = id;
            this.runPredicate = runPredicate;
            this.emissionPredicate = emissionPredicate;
            this.texture = texture;
        }

        public String getId() {
            return this.id;
        }

        public Either<ItemStack, ResourceLocation> getTexture() {
            return this.texture;
        }

        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.redstoneBehaviour." + this.id;
        }
    }

    public static class EmittingRedstoneMode<T extends BlockEntity>
    extends RedstoneMode<T> {
        public EmittingRedstoneMode(String id, ResourceLocation texture, Predicate<T> emissionPredicate) {
            super(id, texture, (T te) -> false, emissionPredicate);
        }

        public EmittingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> emissionPredicate) {
            super(id, stackIcon, (T te) -> false, emissionPredicate);
        }
    }

    public static class ReceivingRedstoneMode<T extends BlockEntity>
    extends RedstoneMode<T> {
        public ReceivingRedstoneMode(String id, ResourceLocation texture, Predicate<T> runPredicate) {
            super(id, texture, runPredicate, (T t) -> false);
        }

        public ReceivingRedstoneMode(String id, ItemStack stackIcon, Predicate<T> runPredicate) {
            super(id, stackIcon, runPredicate, (T te) -> false);
        }
    }
}

