/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.commons.lang3.Validate;

public class SideConfigurator<T>
implements INBTSerializable<CompoundTag> {
    public static final String BASE_BUTTON_TAG = "SideConf";
    private static final RelativeFace[][] FACING_MATRIX = SideConfigurator.setupFacingMatrix();
    private final List<ConnectionEntry<T>> entries = new ArrayList<ConnectionEntry<T>>();
    private final String id;
    private final ISideConfigurable sideConfigurable;
    private final Map<String, Integer> idxMap = new HashMap<String, Integer>();
    private Supplier<T> nullFaceHandler = () -> null;
    private final byte[] faces = new byte[RelativeFace.values().length];
    private final byte[] defaultFaces = new byte[RelativeFace.values().length];

    public SideConfigurator(String id, ISideConfigurable sideConfigurable) {
        this.id = id;
        this.sideConfigurable = sideConfigurable;
        this.entries.add(null);
    }

    public int registerHandler(String id, ItemStack textureStack, BaseCapability<T, ?> cap, Supplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, (Either<ItemStack, ResourceLocation>)Either.left((Object)textureStack), cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    public int registerHandler(String id, ResourceLocation texture, BaseCapability<T, ?> cap, Supplier<T> handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry<T>(id, (Either<ItemStack, ResourceLocation>)Either.right((Object)texture), cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    private int setDefaultSides(RelativeFace ... defaultRelativeFaces) {
        Validate.isTrue((this.entries.size() <= 127 ? 1 : 0) != 0, (String)"No more than 127 entries allowed", (Object[])new Object[0]);
        byte idx = (byte)(this.entries.size() - 1);
        for (RelativeFace relativeFace : defaultRelativeFaces) {
            this.faces[relativeFace.ordinal()] = idx;
            this.defaultFaces[relativeFace.ordinal()] = idx;
        }
        return idx;
    }

    public void setNullFaceHandler(String id) {
        this.nullFaceHandler = this.entries.get((int)this.idxMap.get((Object)id).intValue()).handler;
    }

    private boolean shouldSaveNBT() {
        return !Arrays.equals(this.faces, this.defaultFaces);
    }

    public boolean handleButtonPress(String tag, boolean hasShiftDown) {
        if (tag.startsWith(BASE_BUTTON_TAG)) {
            try {
                RelativeFace relativeFace = RelativeFace.valueOf(tag.split("\\.")[1]);
                this.cycleValue(relativeFace, hasShiftDown);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getButtonTag(RelativeFace relativeFace) {
        return "SideConf." + relativeFace.toString();
    }

    private void cycleValue(RelativeFace relativeFace, boolean hasShiftDown) {
        int idx = relativeFace.ordinal();
        int n = 0;
        while (n++ < this.entries.size()) {
            ConnectionEntry<T> c;
            if (hasShiftDown) {
                int n2 = idx;
                this.faces[n2] = (byte)(this.faces[n2] - 1);
                if (this.faces[n2] < 0) {
                    this.faces[idx] = (byte)(this.entries.size() - 1);
                }
            } else {
                int n3 = idx;
                this.faces[n3] = (byte)(this.faces[n3] + 1);
                if (this.faces[n3] >= this.entries.size()) {
                    this.faces[idx] = 0;
                }
            }
            if (!this.sideConfigurable.isValid(relativeFace, (c = this.entries.get(this.faces[idx])) == null ? null : c.handler.get())) continue;
            return;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getTranslationKey() {
        return "pneumaticcraft.gui.sideConfigurator.title." + this.id;
    }

    public T getHandler(Direction facing) {
        if (facing == null) {
            return this.nullFaceHandler.get();
        }
        ConnectionEntry<T> c = this.entries.get(this.faces[this.getRelativeFace(facing).ordinal()]);
        return c == null ? null : (T)c.handler.get();
    }

    private static RelativeFace[][] setupFacingMatrix() {
        RelativeFace[][] result = new RelativeFace[4][];
        for (Direction f : DirectionUtil.HORIZONTALS) {
            result[f.get2DDataValue()] = new RelativeFace[4];
            for (RelativeFace rf : RelativeFace.HORIZONTALS) {
                Direction f2 = SideConfigurator.rot(f, rf);
                result[f.get2DDataValue()][f2.get2DDataValue()] = rf;
            }
        }
        return result;
    }

    private static Direction rot(Direction in, RelativeFace rf) {
        return switch (rf) {
            case RelativeFace.RIGHT -> in.getCounterClockWise();
            case RelativeFace.LEFT -> in.getClockWise();
            case RelativeFace.BACK -> in.getOpposite();
            default -> in;
        };
    }

    private RelativeFace getRelativeFace(Direction facing) {
        return switch (facing) {
            case Direction.UP -> RelativeFace.TOP;
            case Direction.DOWN -> RelativeFace.BOTTOM;
            default -> FACING_MATRIX[this.sideConfigurable.byIndex().get2DDataValue()][facing.get2DDataValue()];
        };
    }

    public Component getFaceLabel(RelativeFace relativeFace) {
        ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
        return c == null ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator.unconnected", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.sideConfigurator." + this.id + "." + c.id, new Object[0]);
    }

    public ConnectionEntry<?> getEntry(RelativeFace face) {
        return this.entries.get(this.faces[face.ordinal()]);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag l = new ListTag();
        for (byte face : this.faces) {
            l.add((Object)ByteTag.valueOf((byte)face));
        }
        tag.put("faces", (Tag)l);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag l = nbt.getList("faces", 1);
        for (int i = 0; i < l.size() && i < this.faces.length; ++i) {
            this.faces[i] = ((ByteTag)l.get(i)).getAsByte();
            if (this.faces[i] >= 0 && this.faces[i] < this.entries.size()) continue;
            this.faces[i] = 0;
        }
    }

    public static CompoundTag writeToNBT(ISideConfigurable sideConfigurable) {
        CompoundTag tag = new CompoundTag();
        for (SideConfigurator<?> sc : sideConfigurable.getSideConfigurators()) {
            if (!sc.shouldSaveNBT()) continue;
            CompoundTag subtag = sc.serializeNBT();
            tag.put(sc.id, (Tag)subtag);
        }
        return tag;
    }

    public static void readFromNBT(CompoundTag tag, ISideConfigurable sideConfigurable) {
        for (SideConfigurator<?> sc : sideConfigurable.getSideConfigurators()) {
            if (!tag.contains(sc.id)) continue;
            CompoundTag subtag = tag.getCompound(sc.id);
            sc.deserializeNBT(subtag);
        }
    }

    public static enum RelativeFace {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT,
        FRONT,
        BACK;

        public static final RelativeFace[] HORIZONTALS;

        static {
            HORIZONTALS = new RelativeFace[4];
            RelativeFace.HORIZONTALS[0] = LEFT;
            RelativeFace.HORIZONTALS[1] = RIGHT;
            RelativeFace.HORIZONTALS[2] = FRONT;
            RelativeFace.HORIZONTALS[3] = BACK;
        }
    }

    public record ConnectionEntry<T>(String id, Either<ItemStack, ResourceLocation> texture, BaseCapability<T, ?> cap, Supplier<T> handler) {
    }
}

