/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.inventory.AirCompressorMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;

public class AirCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<AirCompressorBlockEntity>,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private final AirCompressorFuelHandler itemHandler = new AirCompressorFuelHandler();
    private static final int FUEL_SLOT = 0;
    @GuiSynced
    public int burnTime;
    @GuiSynced
    private int maxBurnTime;
    @GuiSynced
    public final RedstoneController<AirCompressorBlockEntity> rsController = new RedstoneController<AirCompressorBlockEntity>(this);
    @GuiSynced
    public int curFuelUsage;
    @GuiSynced
    public float airPerTick;
    private float airBuffer;

    public AirCompressorBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.AIR_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE, 5000);
    }

    AirCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state, tier, volume, 4);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new AirCompressorMenu(i, playerInventory, this.getBlockPos());
    }

    public boolean isActive() {
        return this.getBlockState().hasProperty((Property)PNCBlockStateProperties.ON) && (Boolean)this.getBlockState().getValue((Property)PNCBlockStateProperties.ON) != false;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isActive()) {
            this.spawnBurningParticle();
        }
    }

    @Override
    public void tickServer() {
        BlockState state;
        boolean newIsActive;
        ItemStack fuelStack;
        int itemBurnTime;
        this.airPerTick = (float)this.getBaseProduction() * this.getSpeedMultiplierFromUpgrades() * (float)this.getHeatEfficiency() / 100.0f;
        if (this.rsController.shouldRun() && this.burnTime < this.curFuelUsage && (itemBurnTime = (fuelStack = this.itemHandler.getStackInSlot(0)).getBurnTime(RecipeType.SMELTING)) > 0) {
            this.burnTime += itemBurnTime;
            this.maxBurnTime = this.burnTime;
            if (fuelStack.hasCraftingRemainingItem()) {
                this.itemHandler.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
            } else {
                this.itemHandler.extractItem(0, 1, false);
            }
        }
        this.curFuelUsage = (int)((float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() / 10.0f);
        if (this.burnTime >= this.curFuelUsage) {
            this.burnTime -= this.curFuelUsage;
            this.airBuffer += this.airPerTick;
            if (this.airBuffer >= 1.0f) {
                int toAdd = (int)this.airBuffer;
                this.addAir(toAdd);
                this.airBuffer -= (float)toAdd;
                this.addHeatForAir(toAdd);
            }
        }
        boolean bl = newIsActive = this.burnTime > this.curFuelUsage;
        if (this.isActive() != newIsActive && (state = this.getBlockState()).hasProperty((Property)PNCBlockStateProperties.ON)) {
            this.nonNullLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)PNCBlockStateProperties.ON, (Comparable)Boolean.valueOf(newIsActive)));
        }
        this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    private void spawnBurningParticle() {
        Level level = this.nonNullLevel();
        if (level.random.nextInt(3) != 0) {
            return;
        }
        float px = (float)this.getBlockPos().getX() + 0.5f;
        float py = (float)this.getBlockPos().getY() + level.random.nextFloat() * 6.0f / 16.0f;
        float pz = (float)this.getBlockPos().getZ() + 0.5f;
        float f3 = 0.5f;
        float f4 = level.random.nextFloat() * 0.4f - 0.2f;
        switch (this.getRotation()) {
            case EAST: {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)(px - f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)(px + f3), (double)py, (double)(pz + f4), 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)(px + f4), (double)py, (double)(pz - f3), 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)(px + f4), (double)py, (double)(pz + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public int getBurnTimeRemainingScaled(int parts) {
        if (this.maxBurnTime == 0 || this.burnTime < this.curFuelUsage) {
            return 0;
        }
        return parts * this.burnTime / this.maxBurnTime;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.burnTime = tag.getInt("burnTime");
        this.maxBurnTime = tag.getInt("maxBurn");
        this.itemHandler.deserializeNBT(tag.getCompound("Items"));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("burnTime", this.burnTime);
        tag.putInt("maxBurn", this.maxBurnTime);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public RedstoneController<AirCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private class AirCompressorFuelHandler
    extends BaseItemStackHandler {
        AirCompressorFuelHandler() {
            super(AirCompressorBlockEntity.this, 1);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.isEmpty() || itemStack.getBurnTime(RecipeType.SMELTING) > 0 && FluidUtil.getFluidContained((ItemStack)itemStack).isEmpty());
        }
    }
}

