/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.FluxCompressorMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FluxCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<FluxCompressorBlockEntity>,
MenuProvider,
IHeatExchangingTE {
    private static final int BASE_FE_PRODUCTION = 40;
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private float airPerTick;
    private float airBuffer;
    private boolean isEnabled;
    @GuiSynced
    private final RedstoneController<FluxCompressorBlockEntity> rsController = new RedstoneController<FluxCompressorBlockEntity>(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();

    public FluxCompressorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.FLUX_COMPRESSOR.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public boolean hasEnergyCapability() {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyHandler(@Nullable Direction dir) {
        return dir == this.getRotation() ? null : this.energy;
    }

    public int getHeatEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void tickServer() {
        super.tickServer();
        Level level = this.nonNullLevel();
        if (level.getGameTime() % 5L == 0L) {
            this.airPerTick = 40.0f * this.getSpeedUsageMultiplierFromUpgrades() * ((float)this.getHeatEfficiency() / 100.0f) * ((float)((Integer)ConfigHelper.common().machines.fluxCompressorEfficiency.get()).intValue() / 100.0f);
            this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades());
        }
        boolean newEnabled = false;
        if (this.rsController.shouldRun() && this.energy.getEnergyStored() >= this.rfPerTick) {
            this.airBuffer += this.airPerTick;
            if (this.airBuffer >= 1.0f) {
                int toAdd = (int)this.airBuffer;
                this.addAir(toAdd);
                this.airBuffer -= (float)toAdd;
                this.heatExchanger.addHeat((double)toAdd / 20.0);
            }
            this.energy.extractEnergy(this.rfPerTick, false);
            newEnabled = true;
        }
        if ((level.getGameTime() & 7L) == 0L && newEnabled != this.isEnabled) {
            this.isEnabled = newEnabled;
            BlockState state = level.getBlockState(this.worldPosition);
            level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)PNCBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(this.isEnabled)));
        }
        this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation().getOpposite() : null);
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().getOpposite();
    }

    @Override
    public RedstoneController<FluxCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.energy.writeToNBT(tag);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.energy.readFromNBT(tag);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    public int getInfoEnergyPerTick() {
        return this.rfPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public float getAirRate() {
        return this.airPerTick;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new FluxCompressorMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

