/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.LiquidCompressorMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LiquidCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<LiquidCompressorBlockEntity>,
ISerializableTanks,
MenuProvider {
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    @DescSynced
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 16000){

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return FuelRegistry.getInstance().getFuelValue(LiquidCompressorBlockEntity.this.level, stack.getFluid()) > 0;
        }
    };
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private double internalFuelBuffer;
    private float burnMultiplier = 1.0f;
    @GuiSynced
    public final RedstoneController<LiquidCompressorBlockEntity> rsController = new RedstoneController<LiquidCompressorBlockEntity>(this);
    @GuiSynced
    public float airPerTick;
    private float airBuffer;

    public LiquidCompressorBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.LIQUID_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE, 5000);
    }

    LiquidCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state, tier, volume, 4);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.tank;
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public boolean isActive() {
        return this.getBlockState().hasProperty((Property)PNCBlockStateProperties.ON) && (Boolean)this.getBlockState().getValue((Property)PNCBlockStateProperties.ON) != false;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isActive() && this.nonNullLevel().random.nextInt(5) == 0) {
            ClientUtils.emitParticles(this.getLevel(), this.getBlockPos(), (ParticleOptions)ParticleTypes.SMOKE);
        }
    }

    @Override
    public void tickServer() {
        BlockState state;
        super.tickServer();
        this.processFluidItem(0, 1);
        boolean newIsActive = false;
        this.airPerTick = (float)this.getBaseProduction() * this.burnMultiplier * this.getSpeedMultiplierFromUpgrades() * ((float)this.getHeatEfficiency() / 100.0f);
        if (this.rsController.shouldRun()) {
            double fuelValue;
            double usageRate = (float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() * this.burnMultiplier;
            if (this.internalFuelBuffer < usageRate && (fuelValue = (double)FuelRegistry.getInstance().getFuelValue(this.level, this.tank.getFluid().getFluid()) / 1000.0) > 0.0) {
                int usedFuel = Math.min(this.tank.getFluidAmount(), (int)(usageRate / fuelValue) + 1);
                this.tank.drain(usedFuel, IFluidHandler.FluidAction.EXECUTE);
                this.internalFuelBuffer += (double)usedFuel * fuelValue;
                this.burnMultiplier = FuelRegistry.getInstance().getBurnRateMultiplier(this.level, this.tank.getFluid().getFluid());
            }
            if (this.internalFuelBuffer >= usageRate) {
                newIsActive = true;
                this.internalFuelBuffer -= usageRate;
                this.airBuffer += this.airPerTick;
                if (this.airBuffer >= 1.0f) {
                    int toAdd = (int)this.airBuffer;
                    this.addAir(toAdd);
                    this.airBuffer -= (float)toAdd;
                    this.addHeatForAir(toAdd);
                }
            }
        }
        if (newIsActive != this.isActive() && (state = this.getBlockState()).hasProperty((Property)PNCBlockStateProperties.ON)) {
            this.nonNullLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)PNCBlockStateProperties.ON, (Comparable)Boolean.valueOf(newIsActive)));
        }
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = this.getRotation();
        return orientation == dir || orientation == dir.getOpposite() || dir == Direction.UP;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT());
        tag.putDouble("internalFuelBuffer", this.internalFuelBuffer);
        tag.putFloat("burnMultiplier", this.burnMultiplier);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.itemHandler.deserializeNBT(tag.getCompound("Items"));
        this.internalFuelBuffer = tag.getDouble("internalFuelBuffer");
        this.burnMultiplier = tag.getFloat("burnMultiplier");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getItemHandler(@javax.annotation.Nullable Direction dir) {
        return this.itemHandler;
    }

    @Override
    public RedstoneController<LiquidCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new LiquidCompressorMenu(i, playerInventory, this.getBlockPos());
    }
}

