/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ManualCompressorBlockEntity
extends AbstractAirHandlingBlockEntity {
    public static final int TICKS_PER_PUMP_STEP = 4;
    public int ticksUntilNextPumpStep = 0;
    private static final int airPerPumpCycle = (Integer)ConfigHelper.common().machines.manualCompressorAirPerCycle.get();
    private final int effectiveVolume = this.airHandler.getVolume() * 5;
    @DescSynced
    public int pumpCycleProgress = 0;
    @DescSynced
    public int storedAir = 0;
    public double pumprodVerticalOffsetCurrent = 0.0;
    public double pumprodVerticalOffsetPrevious = 0.0;
    public double pumprodVerticalOffsetCurrentTick = 0.0;
    public double pumprodVerticalOffsetPreviousTick = 0.0;
    public long pumpStepStartTick = 0L;

    ManualCompressorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, PressureTier tier, int volume) {
        super(type, pos, state, tier, volume, 0);
    }

    public ManualCompressorBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.MANUAL_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE, 5000);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.level.getGameTime() <= this.pumpStepStartTick + 4L) {
            int currentPumpStepTick = Math.abs(this.ticksUntilNextPumpStep - 4);
            double offsetPerTick = (this.pumprodVerticalOffsetCurrent - this.pumprodVerticalOffsetPrevious) / 4.0;
            this.pumprodVerticalOffsetCurrentTick = this.pumprodVerticalOffsetPrevious + offsetPerTick * (double)currentPumpStepTick;
            this.pumprodVerticalOffsetPreviousTick = this.pumprodVerticalOffsetPrevious + offsetPerTick * (double)(currentPumpStepTick - 1);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.storedAir != this.airHandler.getAir() && this.airHandler.getAir() % 250 == 0 || Math.abs(this.storedAir - this.airHandler.getAir()) > 500) {
            this.storedAir = this.airHandler.getAir();
        }
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        if (this.ticksUntilNextPumpStep != 0) {
            --this.ticksUntilNextPumpStep;
        }
    }

    public void setPumprodVerticalOffset() {
        double pumprodVerticalOffset = (double)this.pumpCycleProgress / 14.814814814814815;
        if (this.pumprodVerticalOffsetPrevious != pumprodVerticalOffset) {
            this.pumprodVerticalOffsetPrevious = this.pumprodVerticalOffsetCurrent;
            this.pumprodVerticalOffsetCurrent = pumprodVerticalOffset;
        }
        this.pumpStepStartTick = this.level.getGameTime();
    }

    public void onPumpCycleStep(Player player) {
        if (this.ticksUntilNextPumpStep == 0) {
            float hungerDrain = ((Double)ConfigHelper.common().machines.manualCompressorHungerDrainPerCycleStep.get()).floatValue();
            if (this.pumpCycleProgress != 100) {
                int progressToAdd = Math.max((int)Math.round((double)(this.effectiveVolume - this.storedAir) / 500.0), 0);
                this.pumpCycleProgress = Math.min(this.pumpCycleProgress + progressToAdd, 100);
                player.causeFoodExhaustion(hungerDrain);
                if (this.pumpCycleProgress == 100) {
                    this.onPumpCycleComplete();
                }
            } else {
                this.pumpCycleProgress = 0;
                player.causeFoodExhaustion(hungerDrain * 2.0f);
            }
            this.setPumprodVerticalOffset();
            this.ticksUntilNextPumpStep = 4;
        }
    }

    public void onPumpCycleComplete() {
        if (this.airHandler.getAir() + airPerPumpCycle > this.effectiveVolume) {
            this.addAir(this.effectiveVolume - this.airHandler.getAir());
        } else {
            this.addAir(airPerPumpCycle);
        }
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }
}

