/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.compressor;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.inventory.ThermalCompressorMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ThermalCompressorBlockEntity
extends AbstractAirHandlingBlockEntity
implements IHeatTinted,
IRedstoneControl<ThermalCompressorBlockEntity>,
MenuProvider,
IHeatExchangingTE {
    private static final double AIR_GEN_MULTIPLIER = 0.05;
    private final double[] airGenerated = new double[2];
    @GuiSynced
    private final IHeatExchangerLogic[] heatExchangers = new IHeatExchangerLogic[4];
    private final IHeatExchangerLogic connector1;
    private final IHeatExchangerLogic connector2;
    private final IHeatExchangerLogic dummyExchanger;
    @DescSynced
    private final SyncedTemperature[] syncedTemperatures = new SyncedTemperature[4];
    @GuiSynced
    private final RedstoneController<ThermalCompressorBlockEntity> rsController = new RedstoneController<ThermalCompressorBlockEntity>(this);

    public ThermalCompressorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.THERMAL_COMPRESSOR.get(), pos, state, PressureTier.TIER_ONE_HALF, 5000, 4);
        IntStream.range(0, this.heatExchangers.length).forEach(i -> {
            this.heatExchangers[i] = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
            this.heatExchangers[i].setThermalCapacity(2.0);
        });
        for (int i2 = 0; i2 < this.syncedTemperatures.length; ++i2) {
            this.syncedTemperatures[i2] = new SyncedTemperature(this.heatExchangers[i2]);
        }
        this.connector1 = this.makeConnector(Direction.NORTH);
        this.connector2 = this.makeConnector(Direction.EAST);
        this.dummyExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    private IHeatExchangerLogic makeConnector(Direction side) {
        IHeatExchangerLogic connector = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
        connector.setThermalResistance(200.0);
        connector.addConnectedExchanger(this.getHeatExchanger(side));
        connector.addConnectedExchanger(this.getHeatExchanger(side.getOpposite()));
        return connector;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        for (IHeatExchangerLogic heatExchanger : this.heatExchangers) {
            heatExchanger.tick();
        }
        if (this.rsController.shouldRun()) {
            this.connector1.tick();
            this.connector2.tick();
            this.equaliseHeat(Direction.NORTH, this.generatePressure(Direction.NORTH));
            this.equaliseHeat(Direction.EAST, this.generatePressure(Direction.EAST));
        }
        for (int i = 0; i < this.heatExchangers.length; ++i) {
            this.syncedTemperatures[i].tick();
        }
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction side) {
        if (side == null) {
            return this.dummyExchanger;
        }
        return side.getAxis() == Direction.Axis.Y ? null : this.heatExchangers[side.get2DDataValue()];
    }

    @Override
    public void initHeatExchangersOnPlacement(Level world, BlockPos pos) {
        double temp = HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)world, pos);
        for (IHeatExchangerLogic logic : this.heatExchangers) {
            logic.setTemperature(temp);
        }
    }

    private void equaliseHeat(Direction side, double airProduced) {
        double heatToAdd = airProduced / 5.0;
        IHeatExchangerLogic h1 = this.getHeatExchanger(side);
        IHeatExchangerLogic h2 = this.getHeatExchanger(side.getOpposite());
        if (h1.getTemperature() > h2.getTemperature()) {
            h1.addHeat(-heatToAdd);
            h2.addHeat(heatToAdd);
        } else {
            h1.addHeat(heatToAdd);
            h2.addHeat(-heatToAdd);
        }
    }

    public double airProduced(Direction side) {
        if (this.nonNullLevel().isClientSide) {
            double diff = Math.abs(this.getHeatExchanger(side).getTemperatureAsInt() - this.getHeatExchanger(side.getOpposite()).getTemperatureAsInt());
            return diff < 10.0 ? 0.0 : diff * 0.05;
        }
        double diff = Math.abs(this.getHeatExchanger(side).getTemperature() - this.getHeatExchanger(side.getOpposite()).getTemperature());
        return diff < 10.0 ? 0.0 : diff * 0.05;
    }

    private double generatePressure(Direction side) {
        int sideIdx;
        double airProduced = this.airProduced(side);
        int n = sideIdx = side.getAxis() == Direction.Axis.Z ? 1 : 0;
        this.airGenerated[n] = this.airGenerated[n] + airProduced;
        if (this.airGenerated[sideIdx] > 1.0) {
            int toAdd = (int)this.airGenerated[sideIdx];
            this.addAir(toAdd);
            int n2 = sideIdx;
            this.airGenerated[n2] = this.airGenerated[n2] - (double)toAdd;
        }
        return airProduced;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.getAxis() == Direction.Axis.Y;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return HeatUtil.getColourForTemperature(this.syncedTemperatures[tintIndex].getSyncedTemp());
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        for (int i = 0; i < 4; ++i) {
            tag.put("side" + i, (Tag)this.heatExchangers[i].serializeNBT());
        }
        tag.put("connector1", (Tag)this.connector1.serializeNBT());
        tag.put("connector2", (Tag)this.connector2.serializeNBT());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        for (int i = 0; i < 4; ++i) {
            this.heatExchangers[i].deserializeNBT(tag.getCompound("side" + i));
        }
        this.connector1.deserializeNBT(tag.getCompound("connector1"));
        this.connector2.deserializeNBT(tag.getCompound("connector2"));
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public RedstoneController<ThermalCompressorBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ThermalCompressorMenu(i, playerInventory, this.getBlockPos());
    }
}

